/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hdm.business.domain.parttime.external.IParttimeAdminOrgExternalService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.parttime.service.impl.helper.DirectLeaderHelper;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hdm.opplugin.parttime.BatchPartBaseOp;
import org.apache.commons.lang3.time.StopWatch;

public class BatchPartSaveOp
extends BatchPartBaseOp {
    private static final Log LOGGER = LogFactory.getLog(BatchPartSaveOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] batchParttimeBills = args.getDataEntities();
        DynamicObjectCollection entryentity = batchParttimeBills[0].getDynamicObjectCollection("entryentity");
        Object[] regBills = new DynamicObject[entryentity.size()];
        entryentity.toArray(regBills);
        this.setCompany((DynamicObject[])regBills);
        this.setWorkRoleId((DynamicObject[])regBills);
        this.setSuperiorByInvokeInf((DynamicObject[])regBills);
        this.setHisJobByPosition((DynamicObject[])regBills);
        StopWatch stopWatch = new StopWatch("setJobByStdPosition AffiliateAdminOrg");
        stopWatch.start();
        Arrays.stream(regBills).forEach(dynamicObject -> {
            this.setJobByStdPosition((DynamicObject)dynamicObject);
            this.setAffiliateAdminOrg((DynamicObject)dynamicObject);
        });
        stopWatch.stop();
        LOGGER.info("setJobByStdPosition AffiliateAdminOrg finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        this.changeVidToBoId((DynamicObject[])regBills);
    }

    private void setWorkRoleId(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            String positionType = dynamicObject.getString("apositiontype");
            if (!"1".equals(positionType)) continue;
            long roleId = dynamicObject.getLong("aposition.workrole.id");
            dynamicObject.set("aworkrole_id", (Object)roleId);
        }
    }

    private void setSuperiorByInvokeInf(DynamicObject[] dataEntities) {
        try {
            StopWatch stopWatch = new StopWatch("setSuperiorByInvokeInf");
            stopWatch.start();
            long[] personIdArr = ORM.create().genLongIds("hrpi_person", dataEntities.length);
            AtomicInteger i = new AtomicInteger();
            HashMap dynVsIdMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
            Arrays.stream(dataEntities).forEach(dataEntity -> dynVsIdMap.put(dataEntity, personIdArr[i.getAndIncrement()]));
            List infInParamList = DirectLeaderHelper.buildParamMap((DynamicObject[])dataEntities, (Map)dynVsIdMap);
            Map idVsLeaderListMap = IParttimeBillService.getInstance().getLeaderByRuleFromHRPI(infInParamList);
            if (!CollectionUtils.isEmpty((Map)idVsLeaderListMap)) {
                for (DynamicObject dataEntity2 : dataEntities) {
                    Long dummyId = (Long)dynVsIdMap.get(dataEntity2);
                    List leaderList = idVsLeaderListMap.getOrDefault(dummyId, Lists.newArrayListWithExpectedSize((int)0));
                    List personIdList = leaderList.stream().filter(map -> Objects.nonNull(map.get("person.id"))).map(map -> (Long)map.get("person.id")).collect(Collectors.toList());
                    this.setSuperior(dataEntity2, personIdList);
                }
            }
            stopWatch.stop();
            LOGGER.info("setSuperiorByPosition finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        }
        catch (Exception exception) {
            LOGGER.error("\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25\uff1a", (Throwable)exception);
        }
    }

    private void changeVidToBoId(DynamicObject[] dataEntities) {
        StopWatch stopWatch = new StopWatch("changeVidToBoId");
        stopWatch.start();
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            Date effectDate = dataEntity.getDate("effectdate");
            if (effectDate.after(new Date()) || DateUtils.isSameDay((Date)effectDate, (Date)new Date())) {
                IParttimeBillService.getInstance().changeToBoId(dataEntity);
            }
        });
        stopWatch.stop();
        LOGGER.info("changeVidToBoId finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void setAffiliateAdminOrg(DynamicObject dataEntity) {
        DynamicObject adminOrg = dataEntity.getDynamicObject("aadminorg");
        Long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)adminOrg);
        dataEntity.set("affiliateadminorg_id", (Object)(adminOrgId != 0L ? adminOrgId : null));
    }

    private Map<Long, Map<String, Long>> getHrBu(List<Long> adminOrgIdList) {
        StopWatch stopWatch = new StopWatch("getHrBu");
        stopWatch.start();
        List list = HRServiceUtil.getHrBuByBusinessType(adminOrgIdList);
        HashMap<Long, Map<String, Long>> hrBuMap = new HashMap<Long, Map<String, Long>>(list.size());
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (Map map : list) {
                Long adminOrgId = (Long)map.get("adminOrgId");
                hrBuMap.put(adminOrgId, map);
            }
        }
        stopWatch.stop();
        LOGGER.info("getHrBu finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        return hrBuMap;
    }

    private void setCompany(DynamicObject[] dataEntities) {
        StopWatch stopWatch = new StopWatch("setCompany");
        stopWatch.start();
        List<Long> adminOrgIdList = Arrays.stream(dataEntities).map(dynamicObject -> {
            DynamicObject adminOrg = dynamicObject.getDynamicObject("aadminorg");
            return HRDyObjectPropUtil.getId((DynamicObject)adminOrg);
        }).distinct().collect(Collectors.toList());
        Map<Long, Map<String, Long>> hrBuMap = this.getHrBu(adminOrgIdList);
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            DynamicObject adminOrg = dynamicObject.getDynamicObject("aadminorg");
            long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)adminOrg);
            Map hrBu = (Map)hrBuMap.get(adminOrgId);
            if (hrBu != null) {
                dynamicObject.set("hrbu_id", hrBu.get("hrBuId"));
            }
        });
        stopWatch.stop();
        LOGGER.info("setCompany finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void setJobByStdPosition(DynamicObject dataEntity) {
        String positionType;
        switch (positionType = dataEntity.getString("apositiontype")) {
            case "0": {
                DynamicObject stdPositionObject = dataEntity.getDynamicObject("astdposition");
                long jobId = stdPositionObject.getLong("job.id");
                dataEntity.set("bjob_id", (Object)jobId);
                break;
            }
        }
    }

    private void setHisJobByPosition(DynamicObject[] dataEntities) {
        Map jobIdMap;
        Date effectDate;
        StopWatch stopWatch = new StopWatch("setHisJobByPosition");
        stopWatch.start();
        ArrayList<DynamicObject> aPositionDynamicObjectList = new ArrayList<DynamicObject>();
        HashMap<Long, List> queryHisJobParams = new HashMap<Long, List>();
        for (DynamicObject dataEntity : dataEntities) {
            String positionType = dataEntity.getString("apositiontype");
            if (!"1".equals(positionType)) continue;
            aPositionDynamicObjectList.add(dataEntity);
            effectDate = dataEntity.getDate("effectdate");
            DynamicObject dynamicObject = dataEntity.getDynamicObject("aposition");
            long jobId = dynamicObject.getLong("job.id");
            if (jobId == 0L) continue;
            List dateList = queryHisJobParams.computeIfAbsent(jobId, list -> new ArrayList());
            dateList.add(effectDate);
        }
        if (queryHisJobParams.size() < 1) {
            return;
        }
        Map hisJobMap = IParttimeAdminOrgExternalService.getInstance().selectJobHisVersionInfo(queryHisJobParams);
        if (hisJobMap == null || hisJobMap.get("data") == null) {
            LOGGER.error("IHBJMHisVerService selectJobHisVersionInfo result exception");
            return;
        }
        List dataList = (List)hisJobMap.get("data");
        HashMap<Long, Map> jobBoIdMap = new HashMap<Long, Map>();
        for (Map map : dataList) {
            Long boid = (Long)map.get("boId");
            Date searchTime = (Date)map.get("searchTime");
            Long jobId = (Long)map.get("id");
            jobIdMap = jobBoIdMap.computeIfAbsent(boid, list -> new HashMap());
            jobIdMap.put(searchTime, jobId);
        }
        for (DynamicObject dynamicObject : aPositionDynamicObjectList) {
            effectDate = dynamicObject.getDate("effectdate");
            long jobBoId = dynamicObject.getLong("aposition.job.id");
            jobIdMap = (Map)jobBoIdMap.get(jobBoId);
            if (jobIdMap == null) continue;
            Long jobId = (Long)jobIdMap.get(effectDate);
            dynamicObject.set("bjob_id", (Object)jobId);
        }
        stopWatch.stop();
        LOGGER.info("setHisJobByPosition finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void setJobByPosition(DynamicObject[] dataEntities) {
        List positionVidList = Arrays.stream(dataEntities).filter(dataEntity -> {
            String positionType = dataEntity.getString("apositiontype");
            return "1".equals(positionType);
        }).map(dataEntity -> dataEntity.getLong("aposition.id")).collect(Collectors.toList());
        if (positionVidList.size() < 1) {
            return;
        }
        Map positionHisMap = IParttimeAdminOrgExternalService.getInstance().invokeQueryPositionHisByVid(positionVidList);
        Object data = positionHisMap.get("data");
        if (data == null) {
            return;
        }
        List hisDataList = (List)((Map)data).get("hisdata");
        if (hisDataList == null || hisDataList.size() < 1) {
            return;
        }
        HashMap<Long, Long> hisJobMap = new HashMap<Long, Long>(hisDataList.size());
        for (Map map : hisDataList) {
            Long positionVid = (Long)map.get("id");
            Long jobVid = (Long)map.get("jobVid");
            hisJobMap.put(positionVid, jobVid);
        }
        for (DynamicObject dynamicObject : dataEntities) {
            String positionType = dynamicObject.getString("apositiontype");
            if (!"1".equals(positionType)) continue;
            long positionVid = dynamicObject.getLong("aposition.id");
            dynamicObject.set("bjob", hisJobMap.get(positionVid));
        }
    }

    private void setSuperiorByPosition(DynamicObject[] dataEntities) {
    }

    private void setSuperiorStdPosition(DynamicObject[] dataEntities) {
        String positionType;
        StopWatch stopWatch = new StopWatch("setSuperiorStdPosition");
        stopWatch.start();
        ArrayList<Long> orgIdList = new ArrayList<Long>(dataEntities.length);
        ArrayList<DynamicObject> positionDynamicObjectList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            positionType = dynamicObject.getString("apositiontype");
            if (!"0".equals(positionType)) continue;
            long adminOrgId = dynamicObject.getLong("aadminorg.id");
            orgIdList.add(adminOrgId);
            positionDynamicObjectList.add(dynamicObject);
        }
        if (orgIdList.size() > 0) {
            List list = PersonExternalService.getInstance().invokeGetMainChargeInfoByOrg(orgIdList.stream().distinct().collect(Collectors.toList()));
            if (list == null || list.size() < 1) {
                return;
            }
            HashMap<Long, List> superiorMap = new HashMap<Long, List>(list.size());
            for (Map map : list) {
                Long adminorg = (Long)map.get("adminorg");
                Long personId = (Long)map.get("person");
                List superiorList = superiorMap.computeIfAbsent(adminorg, value -> new ArrayList());
                superiorList.add(personId);
            }
            for (DynamicObject dynamicObject : positionDynamicObjectList) {
                long adminOrgId;
                List superiorList;
                positionType = dynamicObject.getString("apositiontype");
                if (!"0".equals(positionType) || (superiorList = (List)superiorMap.get(adminOrgId = dynamicObject.getLong("aadminorg.id"))) == null || superiorList.size() <= 0) continue;
                this.setSuperior(dynamicObject, superiorList);
            }
        }
        stopWatch.stop();
        LOGGER.info("setSuperiorStdPosition finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void setSuperior(DynamicObject dyn, List superiorList) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = dyn.getDynamicObjectCollection("asuperior").getDynamicObjectType();
        for (Object superiorId : superiorList) {
            DynamicObject superiorObject = new DynamicObject(dynamicObjectType);
            superiorObject.set("fbasedataid_id", superiorId);
            collection.add((Object)superiorObject);
        }
        if (collection.size() > 0) {
            dyn.set("asuperior", (Object)collection);
        }
    }
}

