/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;

public class BatchParttimeEventOp
extends HRDataBaseOp {
    private DynamicObject[] effectBillArray;

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        List fieldKeys = event.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("id", "billstatus", "entryentity", "issubmit"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] batchPartBills = e.getDataEntities();
        switch (e.getOperationKey()) {
            case "unsubmit": {
                this.unSubmit(batchPartBills);
                break;
            }
            case "wfauditnotpass": {
                this.auditDisagree(batchPartBills);
                break;
            }
            case "wfauditpass": {
                List<DynamicObject> dynamicObjects = this.auditPass(batchPartBills);
                this.effectBillArray = dynamicObjects.toArray(new DynamicObject[0]);
                break;
            }
            case "wfrejecttosubmit": {
                this.auditReject(batchPartBills);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] batchBills = e.getDataEntities();
        List<DynamicObjectCollection> dynamicObjectCollectionList = Arrays.stream(batchBills).map(batchBill -> batchBill.getDynamicObjectCollection("entryentity")).collect(Collectors.toList());
        ArrayList pkValueList = new ArrayList();
        dynamicObjectCollectionList.forEach(dynamicObjectCollection -> dynamicObjectCollection.forEach(dynamicObject -> pkValueList.add(dynamicObject.getPkValue())));
        DynamicObject[] partBills = ParttimeApplyRepository.getInstance().load(new QFilter[]{new QFilter("id", "in", pkValueList)});
        switch (e.getOperationKey()) {
            case "wfrejecttosubmit": {
                PerChgBizUtils.personChangeRecord((DynamicObject[])partBills, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_DISCARDSCHEDULE);
                break;
            }
            case "wfauditpass": {
                Set effectBillIds = Arrays.stream(this.effectBillArray).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                DynamicObject[] effectBills = ParttimeApplyRepository.getInstance().load(new QFilter("id", "in", effectBillIds).toArray());
                PerChgBizUtils.personChangeOfPart((DynamicObject[])effectBills);
                break;
            }
        }
    }

    private void unSubmit(DynamicObject[] batchPartBills) {
        Arrays.stream(batchPartBills).forEach(temp -> {
            temp.set("billstatus", (Object)"A");
            temp.set("issubmit", (Object)"0");
            DynamicObject[] bills = this.setParttimeBillStatusByBatchPart((DynamicObject)temp, "A", null, "A");
            ParttimeApplyRepository.getInstance().update(bills);
            PerChgBizUtils.personChangeRecord((DynamicObject[])bills, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_DISCARDSCHEDULE);
        });
    }

    private void auditDisagree(DynamicObject[] batchPartBills) {
        Arrays.stream(batchPartBills).forEach(temp -> {
            temp.set("billstatus", (Object)"E");
            DynamicObject[] bills = this.setParttimeBillStatusByBatchPart((DynamicObject)temp, "E", "-1", "C");
            ParttimeApplyRepository.getInstance().update(bills);
            PerChgBizUtils.personChangeRecord((DynamicObject[])bills, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_DISCARDSCHEDULE);
        });
    }

    private DynamicObject[] setParttimeBillStatusByBatchPart(DynamicObject batchPart, String targetBillStatus, String parttimeStatus, String targetAuditStatus) {
        DynamicObjectCollection entryEntity = batchPart.getDynamicObjectCollection("entryentity");
        DynamicObject[] bills = this.getParttimeBillById(entryEntity);
        Iterator<DynamicObject> iterator = new ArrayList<DynamicObject>(Arrays.asList(bills)).iterator();
        while (iterator.hasNext()) {
            DynamicObject bill = iterator.next();
            String orginParttimeStatus = bill.getString("parttimestatus");
            if ("-1".equals(orginParttimeStatus)) {
                iterator.remove();
                continue;
            }
            bill.set("billstatus", (Object)targetBillStatus);
            bill.set("auditstatus", (Object)targetAuditStatus);
            if (!HRStringUtils.isNotEmpty((String)parttimeStatus)) continue;
            bill.set("parttimestatus", (Object)parttimeStatus);
        }
        return bills;
    }

    private List<DynamicObject> auditPass(DynamicObject[] batchPartBills) {
        ArrayList<DynamicObject> effectBills = new ArrayList<DynamicObject>();
        Arrays.stream(batchPartBills).forEach(temp -> {
            temp.set("billstatus", (Object)"C");
            DynamicObject[] bills = this.setParttimeBillStatusByBatchPart((DynamicObject)temp, "C", null, "C");
            DynamicObject[] dynamicObjects = IParttimeBillService.getInstance().auditPassEvent(bills);
            effectBills.addAll(Arrays.asList(dynamicObjects));
        });
        return effectBills;
    }

    private void auditReject(DynamicObject[] batchPartBills) {
        Arrays.stream(batchPartBills).forEach(temp -> {
            temp.set("billstatus", (Object)"G");
            DynamicObject[] bills = this.setParttimeBillStatusByBatchPart((DynamicObject)temp, "G", null, "A");
            ParttimeApplyRepository.getInstance().update(bills);
        });
    }

    private DynamicObject[] getParttimeBillById(DynamicObjectCollection dynamicObjectCollection) {
        List pkValueIdList = dynamicObjectCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", pkValueIdList);
        return ParttimeApplyRepository.getInstance().load(new QFilter[]{qFilter});
    }
}

