/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.opplugin.parttime.PartBaseOp;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;

public class PartBillDiscardOp
extends PartBaseOp {
    private static final Log LOGGER = LogFactory.getLog(PartBillDiscardOp.class);
    private static final Set<String> INPROCESS_BILLSTATUS = Arrays.stream(new String[]{"B", "G", "D"}).collect(Collectors.toSet());

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                String fails;
                OperateOption option = this.getOption();
                if (option.containsVariable("success")) {
                    return;
                }
                if (option.containsVariable("failIds") && !StringUtils.isEmpty((CharSequence)(fails = option.getVariableValue("failIds")))) {
                    Set failIds = (Set)SerializationUtils.fromJsonString((String)fails, Set.class);
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        Long pkValue = (Long)dataEntity.getDataEntity().getPkValue();
                        if (!failIds.contains(pkValue)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u201c\u5ba1\u6279\u901a\u8fc7\u201d\u4e14\u517c\u804c\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u517c\u804c\u6d41\u7a0b\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"PartBillDiscardOp_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                    }
                }
                if (this.dataEntities.length == 1) {
                    Set failIds = ParttimeServiceHelper.validateTerminateFlow((Object[])new Object[]{this.dataEntities[0].getDataEntity().getPkValue()});
                    if (failIds.isEmpty()) {
                        return;
                    }
                    this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u201c\u5ba1\u6279\u901a\u8fc7\u201d\u4e14\u517c\u804c\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u517c\u804c\u6d41\u7a0b\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"PartBillDiscardOp_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs event) {
        super.afterExecuteOperationTransaction(event);
        DynamicObject[] bills = event.getDataEntities();
        PerChgBizUtils.personChangeRecord((DynamicObject[])bills, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_DISCARDSCHEDULE);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        DynamicObject[] bills;
        super.beginOperationTransaction(event);
        for (DynamicObject bill : bills = event.getDataEntities()) {
            this.discardWorkFlow(bill);
            if (!HRStringUtils.equals((String)bill.getString("billstatus"), (String)"C")) {
                bill.set("billstatus", (Object)"F");
            }
            bill.set("auditstatus", (Object)"F");
            bill.set("parttimestatus", (Object)"-1");
        }
        ParttimeApplyRepository.getInstance().update(bills);
    }

    private void discardWorkFlow(DynamicObject partTimeBill) {
        String billId;
        Long instanceId;
        String billStatus = partTimeBill.getString("billstatus");
        if (INPROCESS_BILLSTATUS.contains(billStatus) && !Objects.isNull(instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)(billId = partTimeBill.get("id").toString()))) && !instanceId.equals(0L)) {
            try (TXHandle txHandle = TX.notSupported();){
                LOGGER.info("PartBill terminate work flow , instanceid : [{}]", (Object)instanceId);
                IHSSCService.getInstance().terminateSSCTask(partTimeBill);
                WorkflowServiceHelper.abandon((Long)instanceId);
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
        }
    }
}

