/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.external.IJobExternalService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.transfer.service.external.PositionExternalService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.opplugin.parttime.PartBaseOp;
import kd.hr.hdm.opplugin.parttime.validator.PartBillPChValidator;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;

public class PartBillSubmitAndEffectOp
extends PartBaseOp {
    private static final Log LOGGER = LogFactory.getLog(PartBillSubmitAndEffectOp.class);
    private DynamicObject[] effectBillArray;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs event) {
        super.onPreparePropertys(event);
        List fieldKeys = event.getFieldKeys();
        fieldKeys.add("apositiontype");
        fieldKeys.add("isexistsworkflow");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PartBillPChValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        this.doSubmitAndEffect(args);
    }

    private void doSubmitAndEffect(BeginOperationTransactionArgs args) {
        DynamicObject[] bills = args.getDataEntities();
        DynamicObject[] effectBills = (DynamicObject[])Arrays.stream(bills).filter(bill -> {
            Date effectDate = bill.getDate("effectdate");
            if (effectDate == null) {
                return false;
            }
            effectDate = HRDateTimeUtils.truncateDate((Date)effectDate);
            Date now = HRDateTimeUtils.truncateDate((Date)new Date());
            return HRDateTimeUtils.dayAfter((Date)now, (Date)effectDate) || HRDateTimeUtils.dayEquals((Date)now, (Date)effectDate);
        }).toArray(DynamicObject[]::new);
        Arrays.stream(effectBills).forEach(effectBill -> effectBill.set("isexistsworkflow", (Object)Boolean.FALSE));
        List reqList = IParttimeBillService.getInstance().createReqList(effectBills);
        if (null != reqList && reqList.size() > 0) {
            ArrayList<Map> bJobReqList = new ArrayList<Map>(reqList.size());
            ArrayList<Map> stdPositionReqList = new ArrayList<Map>(reqList.size());
            for (Map map : reqList) {
                if (map.get("job") != null) {
                    bJobReqList.add(map);
                }
                if (map.get("standardposition") == null) continue;
                stdPositionReqList.add(map);
            }
            if (bJobReqList.size() > 0) {
                Map darkPositionByJob = IJobExternalService.getInstance().getDarkPositionByJob(bJobReqList);
                IParttimeBillService.getInstance().fillTheDarkPosition(effectBills, darkPositionByJob);
            }
            if (stdPositionReqList.size() > 0) {
                Map darkPositionByStdPosition = PositionExternalService.getInstance().invokerAddDarkPosition(stdPositionReqList);
                IParttimeBillService.getInstance().fillTheDarkPosition(effectBills, darkPositionByStdPosition);
            }
        }
        IParttimeBillService.getInstance().changeToBoId(effectBills);
        Set effectSet = Arrays.stream(effectBills).map(effectBill -> effectBill.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] notEffectDys = (DynamicObject[])Arrays.stream(bills).filter(bill -> !effectSet.contains(bill.getLong("id"))).toArray(DynamicObject[]::new);
        this.effectBillArray = effectBills;
        PerChgBizUtils.personChangeRecord((DynamicObject[])notEffectDys, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_ADDNEW);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if ("submiteffect".equals(e.getOperationKey())) {
            Set effectBillIds = Arrays.stream(this.effectBillArray).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            LOGGER.info("\u63d0\u4ea4\u5e76\u751f\u6548\u5f00\u59cb\u8c03\u7528\u4e8b\u52a1\u53d8\u52a8: {}", (Object[])this.effectBillArray);
            DynamicObject[] effectBills = ParttimeApplyRepository.getInstance().load(new QFilter("id", "in", effectBillIds).toArray());
            PerChgBizUtils.personChangeOfPart((DynamicObject[])effectBills);
        }
    }
}

