/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;

public class BatchPartSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObjectCollection partBillCollection = dataEntities[0].getDataEntity().getDynamicObjectCollection("entryentity");
        Map<Long, ExtendedDataEntity> dataEntityMap = Arrays.stream(dataEntities).filter(ParttimeValidateHelper.filterBillStatus).collect(Collectors.toMap(dataEntity -> dataEntity.getDataEntity().getLong("id"), Function.identity()));
        List dataValidates = DataValidateBuilder.builderCollection((List)partBillCollection.subList(0, partBillCollection.size()));
        ParttimeValidateHelper.listErmanFileChangeValidate.accept(this.filterError(dataValidates));
        ParttimeValidateHelper.listQuitValidate.accept(this.filterError(dataValidates));
        ParttimeValidateHelper.listCrossValidate.accept(this.filterError(dataValidates));
        this.showErrorMsg(dataValidates, dataEntityMap);
    }

    private List<DataValidate<DynamicObject>> filterError(List<DataValidate<DynamicObject>> dataValidates) {
        return dataValidates.stream().filter(dataValidate -> ValidateRangeEnum.VALIDATE_PASS == dataValidate.getValidatorContext().getRange()).collect(Collectors.toList());
    }

    private void showErrorMsg(List<DataValidate<DynamicObject>> dataValidates, Map<Long, ExtendedDataEntity> dataEntityMap) {
        dataValidates.forEach(dataValidate -> {
            ValidateRangeEnum range = dataValidate.getValidatorContext().getRange();
            String errMsg = dataValidate.getValidatorContext().map2String();
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)dataEntityMap.get(((DynamicObject)dataValidate.getData()).getLong("id"));
            switch (range) {
                case VALIDATE_WARN: 
                case VALIDATE_CONFIRM: {
                    this.addWarningMessage(dataEntity, errMsg);
                    break;
                }
                case VALIDATE_ERROR: {
                    this.addFatalErrorMessage(dataEntity, errMsg);
                    break;
                }
            }
        });
    }
}

