/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hdm.business.common.impl.ImportValidateServiceImpl;
import kd.hr.hdm.business.domain.parttime.validate.BatchParttimeValidateHelper;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.opplugin.parttime.validator.PartBillPChValidator;
import org.apache.commons.lang3.time.StopWatch;

public class PartBillPChHrImportValidator
extends PartBillPChValidator {
    public boolean isAddBillNoForContent() {
        if ("hr_import".equals(applySource)) {
            return false;
        }
        return super.isAddBillNoForContent();
    }

    @Override
    public void validate() {
        StopWatch stopWatch1 = new StopWatch("setApplySource start");
        stopWatch1.start();
        this.setApplySource();
        if (!"hr_import".equals(applySource)) {
            return;
        }
        stopWatch1.stop();
        LOGGER.info("setApplySource finish ,cost time :{}", (Object)stopWatch1.getNanoTime());
        StopWatch stopWatch = new StopWatch("PartBillPChHrImportValidator validate start");
        stopWatch.start();
        ArrayList<DynamicObject> partBills = new ArrayList<DynamicObject>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> dataEntityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject partBill = dataEntity.getDataEntity();
            partBills.add(partBill);
            dataEntityMap.put(partBill.getLong("id"), dataEntity);
        }
        List dataValidates = DataValidateBuilder.builderCollection(partBills);
        this.hrImportValidate(dataValidates);
        this.showErrorMsg(dataValidates, dataEntityMap);
        stopWatch.stop();
        LOGGER.info("PartBillPChHrImportValidator validate finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void hrImportValidate(List<DataValidate<DynamicObject>> dataValidates) {
        List ermanfileIds = dataValidates.stream().map(dv -> ((DynamicObject)dv.getData()).getLong("partperson.id")).distinct().collect(Collectors.toList());
        List ermanfiles = PersonExternalService.getInstance().invokeGetCardFields(ermanfileIds);
        Map ermanfileMap = ermanfiles.stream().collect(Collectors.toMap(map -> (Long)map.get("id"), Function.identity()));
        if (CollectionUtils.isEmpty((Collection)ermanfiles)) {
            return;
        }
        dataValidates.forEach(dataValidate -> {
            if (!this.validatePositionType((DataValidate<DynamicObject>)dataValidate)) {
                return;
            }
            Long ermanfileId = ((DynamicObject)dataValidate.getData()).getLong("partperson.id");
            Map map = (Map)ermanfileMap.get(ermanfileId);
            Date startdate = (Date)map.get("startdate");
            this.validateEffectDate((DataValidate<DynamicObject>)dataValidate, startdate);
            this.validatePrimaryPosition((DataValidate<DynamicObject>)dataValidate, map);
            this.validatePartpersonOrg((DataValidate<DynamicObject>)dataValidate);
        });
        this.setPersonFieldsValueByHRImport(this.filterError(dataValidates), ermanfiles);
        this.validateAdminOrg(this.filterError(dataValidates), applySource);
        this.validatePositonJobStsPositionFirstbsed(this.filterError(dataValidates));
        BatchParttimeValidateHelper.validateRepeatPattimeBill(this.filterError(dataValidates));
        ParttimeValidateHelper.listLicenseCheck.accept(this.filterError(dataValidates));
        ParttimeValidateHelper.listCrossValidate.accept(this.filterError(dataValidates));
    }

    private void setPersonFieldsValueByHRImport(List<DataValidate<DynamicObject>> dataValidates, List<Map<String, Object>> ermanfiles) {
        Map ermanfileMaps = ermanfiles.stream().collect(Collectors.toMap(map -> (Long)map.get("id"), Function.identity()));
        dataValidates.forEach(dataValidate -> {
            long ermanfileId = ((DynamicObject)dataValidate.getData()).getLong("partperson.id");
            Map ermanfileMap = (Map)ermanfileMaps.get(ermanfileId);
            this.setFieldValue((DynamicObject)dataValidate.getData(), ermanfileMap);
        });
    }

    private boolean validatePositionType(DataValidate<DynamicObject> dataValidate) {
        DynamicObject dataEntity = (DynamicObject)dataValidate.getData();
        String errorMsg = new ImportValidateServiceImpl().validatePositionType(dataEntity.getString("apositiontype"), dataEntity.getDynamicObject("astdposition"), dataEntity.getDynamicObject("aposition"), dataEntity.getDynamicObject("bjob"));
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            return false;
        }
        return true;
    }
}

