/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.reg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.url.UrlService;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.reg.RegMessageServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.repository.RegAskDetailsRepository;
import kd.hr.hdm.opplugin.reg.validator.RegExamRemindValidator;

public class RegExamRemindOp
extends AbstractOperationServicePlugIn {
    private static final String CONTENT_URL_STR = "%s/?formId=hdm_regexamreply&detailId=%s&ermanfile=%s";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().add("person");
        args.getFieldKeys().add("bemployee.id");
        args.getFieldKeys().add("examperson");
        args.getFieldKeys().add("opinion");
        args.getFieldKeys().add("message");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new RegExamRemindValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        Set personIds = Arrays.stream(dataEntities).map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
        Map erManFileMap = IHRPIService.getInstance().queryPrimaryErManFileByPersonIds(new String[]{"id", "person"}, new ArrayList(personIds));
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject erManFile = (DynamicObject)erManFileMap.get(dataEntity.getLong("person.id"));
            long erManFileId = erManFile.getLong("id");
            Long messageId = dataEntity.getLong("message");
            RegMessageServiceHelper.deleteMessage((Long)messageId);
            Long personId = dataEntity.getLong("person.id");
            Long askPersonId = dataEntity.getLong("examperson.id");
            Long detailId = dataEntity.getLong("id");
            String contentUrl = String.format(CONTENT_URL_STR, UrlService.getDomainContextUrl(), detailId, erManFileId);
            String messageTemplateNumber = "hdm_regexam_other_urge";
            Map userIdMap = RegPeronalBillHelper.getInstance().queryUserIdMap(Collections.singletonList(personId));
            if (askPersonId.equals(userIdMap.get(personId))) {
                messageTemplateNumber = "hdm_regexam_yourself_urge";
            }
            LocaleString tag = ResManager.getLocaleString((String)"\u8f6c\u6b63\u8003\u8bc4", (String)"RegExamRemindOp_0", (String)"hr-hdm-opplugin");
            long newMessageId = RegMessageServiceHelper.sendMessageNotice((String)contentUrl, Collections.singletonList(askPersonId), (String)messageTemplateNumber, (long)erManFileId, (LocaleString)tag);
            dataEntity.set("message", (Object)newMessageId);
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        RegAskDetailsRepository.getRepository().save(args.getDataEntities());
    }
}

