/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.reg.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.repository.RegApplyRepository;
import kd.hr.hdm.common.reg.enums.PostponeAskResultEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;

public class RegRemindConfirmDelayValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List ids = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map regBillMap = RegApplyRepository.getRepository().queryByIds(new String[]{"postponeaskresult", "billstatus", "person"}, ids);
        this.setAddBillNoForContent(false);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObject regBill = (DynamicObject)regBillMap.get(dynamicObject.getLong("id"));
            String personNumber = regBill.getString("person.number");
            String postponeAskResult = regBill.getString("postponeaskresult");
            String message = null;
            if (HRStringUtils.isEmpty((String)postponeAskResult)) {
                message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u4fe1\u606f\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u5458\u5de5\u65e0\u9700\u786e\u8ba4\u5ef6\u671f\u4fe1\u606f\u3002", (String)"RegRemindConfirmDelayValidator_2", (String)"hr-hdm-opplugin", (Object[])new Object[0]), personNumber);
            } else if (!HRStringUtils.equals((String)postponeAskResult, (String)PostponeAskResultEnum.PENDING_FEEDBACK.getCode())) {
                message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u5458\u5de5\u5df2\u53cd\u9988\u5ef6\u671f\u7ed3\u679c\u4e3a\u201c%2$s\u201d\uff0c\u65e0\u9700\u63d0\u9192\u786e\u8ba4\u3002", (String)"RegRemindConfirmDelayValidator_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]), personNumber, Optional.ofNullable(PostponeAskResultEnum.getName((String)postponeAskResult)).orElse(""));
            } else {
                String billStatus = regBill.getString("billstatus");
                if (!(HRStringUtils.equals((String)billStatus, (String)RegBillStatusEnum.APPROVING.getCode()) || HRStringUtils.equals((String)billStatus, (String)RegBillStatusEnum.WAITRESUBMIT.getCode()) || HRStringUtils.equals((String)billStatus, (String)RegBillStatusEnum.ALREADYSUBMIT.getCode()))) {
                    message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u5355\u636e\u72b6\u6001\u5df2\u53d8\u66f4\u4e3a\u201d%2$s\u201c\uff0c\u65e0\u9700\u63d0\u9192\u786e\u8ba4\u3002", (String)"RegRemindConfirmDelayValidator_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]), personNumber, RegBillStatusEnum.getName((String)billStatus));
                }
            }
            if (HRStringUtils.isNotEmpty((String)message)) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, message);
            }
        });
    }
}

