/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.IBatchTransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.opplugin.transfer.validator.BatchTransferApprovalAgreeValidator;

public class BatchTransferApprovalAgreeOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("entryentity.arealityorg", "entryentity.realitydate", "entryentity.arealityjob", "entryentity.arealityposition"));
        fieldKeys.add("entryentity.person");
        fieldKeys.add("entryentity.bdepemp");
        fieldKeys.add("entryentity.laborreltype");
        fieldKeys.add("entryentity.bjob");
        fieldKeys.add("entryentity.bposition");
        fieldKeys.add("entryentity.borg");
        fieldKeys.add("entryentity.bemployee");
        fieldKeys.add("entryentity.affaction");
        fieldKeys.add("entryentity.bmanagescope");
        fieldKeys.addAll(TransferStaffService.getInstance().getMapFieldSet());
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new BatchTransferApprovalAgreeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            this.occupyStaff(dataEntity);
        }
    }

    private void occupyStaff(DynamicObject dataEntity) {
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject[] oldTransferBillList = TransferBillRepository.getInstance().query("arealityorg,realitydate,arealityjob,arealityposition", entryentity.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList()));
        Map oldTransferBillMap = Arrays.stream(oldTransferBillList).collect(Collectors.toMap(transferBill -> transferBill.getLong("id"), Function.identity()));
        ArrayList createStaffTransferBill = Lists.newArrayListWithExpectedSize((int)entryentity.getRowCount());
        ArrayList updateStaffTransferBill = Lists.newArrayListWithExpectedSize((int)entryentity.getRowCount());
        for (DynamicObject transferBill2 : entryentity) {
            DynamicObject oldTransferBill = (DynamicObject)oldTransferBillMap.get(transferBill2.getLong("id"));
            if (oldTransferBill == null) {
                createStaffTransferBill.add(transferBill2);
                continue;
            }
            if (!IBatchTransferValidatorService.getInstance().isMvpFieldChanged(transferBill2, oldTransferBill)) continue;
            updateStaffTransferBill.add(transferBill2);
        }
        TransferStaffService.getInstance().occupyStaff((List)createStaffTransferBill, false);
        TransferStaffService.getInstance().occupyStaff((List)updateStaffTransferBill, true);
    }
}

