/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.IEffectTransferService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferStatusEnum;

public class BatchTransferSubmitEffectOp
extends HRDataBaseOp {
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"kd.hr.hdm.opplugin.transfer.BatchTransferSubmitEffectOp", (int)5, (int)1000);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("auditstatus");
        fieldKeys.add("billstatus");
        fieldKeys.addAll(TransferStaffService.getInstance().getMapFieldSet());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject batchTransferBill = dataEntities[0];
        if (batchTransferBill == null) {
            return;
        }
        DynamicObjectCollection transferBillCollection = batchTransferBill.getDynamicObjectCollection("entryentity");
        batchTransferBill.set("auditstatus", (Object)"C");
        batchTransferBill.set("billstatus", (Object)"C");
        List<DynamicObject> transferBillList = Arrays.asList(TransferBillRepository.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), transferBillCollection.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList())));
        transferBillList.forEach(transferBill -> {
            transferBill.set("transferstatus", (Object)TransferStatusEnum.TO_EFFECT.getStatus());
            transferBill.set("auditstatus", (Object)"C");
            transferBill.set("billstatus", (Object)"C");
        });
        TransferBillRepository.getInstance().batchUpdate(transferBillList);
        this.createOccupyStaff(transferBillList);
        THREAD_POOL.execute(() -> this.effectTransfer(transferBillList));
    }

    private void createOccupyStaff(List<DynamicObject> transferBillList) {
        TransferStaffService.getInstance().occupyStaff(transferBillList, false);
    }

    private boolean isEffectTransfer(DynamicObject transferBill) {
        Calendar now = Calendar.getInstance();
        return HRDateTimeUtils.dayBefore((Date)transferBill.getDate("realitydate"), (Date)now.getTime());
    }

    private void effectTransfer(List<DynamicObject> transferBillList) {
        ArrayList sendMsgDyList = new ArrayList();
        transferBillList.forEach(transferBill -> {
            if (this.isEffectTransfer((DynamicObject)transferBill)) {
                IEffectTransferService.getInstance().effectTransfer(transferBill);
            } else {
                sendMsgDyList.add(transferBill);
            }
        });
        ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(sendMsgDyList, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
    }
}

