/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferStatusEnum;

public class BatchTransferSubmitOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("auditstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("issubmit");
        fieldKeys.addAll(TransferStaffService.getInstance().getMapFieldSet());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject batchTransferBill = dataEntities[0];
        if (batchTransferBill == null) {
            return;
        }
        DynamicObjectCollection transferBillCollection = batchTransferBill.getDynamicObjectCollection("entryentity");
        batchTransferBill.set("auditstatus", (Object)"B");
        batchTransferBill.set("billstatus", (Object)"B");
        batchTransferBill.set("issubmit", (Object)"1");
        List<DynamicObject> billList = Arrays.asList(TransferBillRepository.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), transferBillCollection.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList())));
        billList.forEach(transferBill -> {
            transferBill.set("auditstatus", (Object)"B");
            transferBill.set("billstatus", (Object)"B");
            transferBill.set("transferstatus", (Object)TransferStatusEnum.TRANSFERING.getStatus());
        });
        TransferBillRepository.getInstance().batchUpdate(billList);
        this.createOccupyStaff(billList);
        ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(billList, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
    }

    private void createOccupyStaff(List<DynamicObject> transferBillList) {
        TransferStaffService.getInstance().occupyStaff(transferBillList, false);
    }
}

