/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.opplugin.transfer.validator.TransferApprovalAgreeValidator;

public class TransferApprovalAgreeOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("arealityorg", "realitydate", "arealityjob", "arealityposition"));
        fieldKeys.add("person");
        fieldKeys.add("bdepemp");
        fieldKeys.add("laborreltype");
        fieldKeys.add("bjob");
        fieldKeys.add("bposition");
        fieldKeys.add("borg");
        fieldKeys.add("bemployee");
        fieldKeys.add("affaction");
        fieldKeys.add("bmanagescope");
        fieldKeys.addAll(TransferStaffService.getInstance().getMapFieldSet());
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TransferApprovalAgreeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        this.createOccupyStaff(Arrays.asList(dataEntities));
    }

    private void createOccupyStaff(List<DynamicObject> transferBillList) {
        DynamicObject[] oldTransferBills = TransferBillRepository.getInstance().query("arealityorg,realitydate,arealityjob,arealityposition", transferBillList.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList()));
        Map oldTransferBillMap = Arrays.stream(oldTransferBills).collect(Collectors.toMap(oldTransferBill -> oldTransferBill.getLong("id"), Function.identity()));
        ArrayList staffUpdateTransferBillList = new ArrayList();
        transferBillList.stream().forEach(transferBill -> {
            if (this.isMvpFieldChanged((DynamicObject)transferBill, (DynamicObject)oldTransferBillMap.get(transferBill.getLong("id")))) {
                staffUpdateTransferBillList.add(transferBill);
            }
        });
        TransferStaffService.getInstance().occupyStaff(staffUpdateTransferBillList, true);
    }

    private boolean isMvpFieldChanged(DynamicObject newTransferBill, DynamicObject oldTransferBill) {
        return newTransferBill.getLong("arealityorg.id") != oldTransferBill.getLong("arealityorg.id") || newTransferBill.getLong("arealityjob.id") != oldTransferBill.getLong("arealityjob.id") || newTransferBill.getLong("arealityposition.id") != oldTransferBill.getLong("arealityposition.id") || !HRDateTimeUtils.dayEquals((Date)newTransferBill.getDate("realitydate"), (Date)oldTransferBill.getDate("realitydate"));
    }
}

