/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer.mytransfer;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.common.HPFSTemplatePropertyHandler;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.opplugin.transfer.validator.MyTransferSubmitValidator;

public class MyTransferApplySubmitOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MyTransferSubmitValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("transferstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("billno");
        fieldKeys.add("bdepemp");
        fieldKeys.add("person");
        fieldKeys.add("arealityorg");
        fieldKeys.add("arealityposition");
        fieldKeys.add("arealityjob");
        fieldKeys.add("laborreltype");
        fieldKeys.add("realitydate");
        fieldKeys.add("bjob");
        fieldKeys.add("bposition");
        fieldKeys.add("borg");
        fieldKeys.add("aorg");
        fieldKeys.add("acompany");
        fieldKeys.add("bcompany");
        fieldKeys.add("affaction");
        fieldKeys.add("transferdate");
        fieldKeys.add("originator");
        fieldKeys.addAll(TransferStaffService.getInstance().getMapFieldSet());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity2 : dataEntities = e.getDataEntities()) {
            if (dataEntity2.getLong("affaction.id") == 0L) {
                this.setAffaction(dataEntity2);
            }
            dataEntity2.set("transferstatus", (Object)"1");
            dataEntity2.set("billstatus", (Object)"B");
            dataEntity2.set("auditstatus", (Object)"B");
            ITransferBillService.getInstance().setBMainOrg(dataEntity2);
        }
        List passList = Arrays.stream(dataEntities).filter(dataEntity -> 0L != dataEntity.getLong("arealityorg.id") && !HRObjectUtils.isEmpty((Object)dataEntity.get("realitydate"))).collect(Collectors.toList());
        TransferStaffService.getInstance().occupyStaff(passList, false);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List dys = Arrays.stream(e.getDataEntities()).filter(dataEntity -> dataEntity.getDate("transferdate") != null).collect(Collectors.toList());
        ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(dys, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
    }

    private void setAffaction(DynamicObject dataEntity) {
        boolean newChgAction = HPFSTemplatePropertyHandler.isNewChgAction((String)"hdm_transfer_hpfs_new");
        long affactionId = 1050L;
        if (0L == dataEntity.getLong("acompany.id") || dataEntity.getLong("bcompany.id") == dataEntity.getLong("acompany.id")) {
            if (newChgAction) {
                affactionId = 201050L;
            }
        } else {
            affactionId = 1060L;
            if (newChgAction) {
                affactionId = 201060L;
            }
        }
        dataEntity.set("affaction_id", (Object)affactionId);
    }
}

