/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer.validator;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.TransferStaffEnum;

public class TransferApprovalAgreeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject[] oldTransferBills = TransferBillRepository.getInstance().query("arealityorg,realitydate,arealityjob,arealityposition", Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList()));
        Map oldTransferBillMap = Arrays.stream(oldTransferBills).collect(Collectors.toMap(oldTransferBill -> oldTransferBill.getLong("id"), Function.identity()));
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            this.staffOccupyValidate(dataEntity2, (DynamicObject)oldTransferBillMap.get(dataEntity2.getBillPkId()));
        }
    }

    private void staffOccupyValidate(ExtendedDataEntity dataEntity, DynamicObject oldTransferBill) {
        DynamicObject transferBill = dataEntity.getDataEntity();
        if (this.isMvpFieldChanged(transferBill, oldTransferBill)) {
            StaffResponse staffUseInfoDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(TransferStaffEnum.UPDATE.name(), Collections.singletonList(transferBill));
            if (staffUseInfoDetail == null) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferApprovalAgreeValidator_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                return;
            }
            StaffQueryOutParamMap staffUseInfoDetailData = (StaffQueryOutParamMap)staffUseInfoDetail.getData();
            StaffQueryOutParam staffQueryOutParam = (StaffQueryOutParam)staffUseInfoDetailData.get((Object)TransferStaffVO.getQueryStaffKey((DynamicObject)transferBill));
            boolean allow = staffQueryOutParam.isAllow();
            if (!allow) {
                this.addFatalErrorMessage(dataEntity, staffQueryOutParam.getReasonList().toString());
            }
        }
    }

    private boolean isMvpFieldChanged(DynamicObject newTransferBill, DynamicObject oldTransferBill) {
        return newTransferBill.getLong("arealityorg.id") != oldTransferBill.getLong("arealityorg.id") || newTransferBill.getLong("arealityjob.id") != oldTransferBill.getLong("arealityjob.id") || newTransferBill.getLong("arealityposition.id") != oldTransferBill.getLong("arealityposition.id") || !HRDateTimeUtils.dayEquals((Date)newTransferBill.getDate("realitydate"), (Date)oldTransferBill.getDate("realitydate"));
    }
}

