/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.validator.reg;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.business.reg.validator.RegApplyValidatorHelper;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;

public class HrSupplementValidator
extends AbstractValidator {
    public void validate() {
        List validateContentDTOS;
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        String errorMsg = IRegProbationService.getInstance().getMustInputErrorMsg(extendedDataEntities[0].getDataEntity());
        if (errorMsg.length() > 0) {
            this.addFatalErrorMessage(extendedDataEntities[0], errorMsg);
            return;
        }
        if (!this.validateFiledRequired(extendedDataEntities)) {
            return;
        }
        List regBills = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map resultMap = RegApplyValidatorHelper.regApplyValidate(regBills, (String)"work_flow_event", (boolean)false, (boolean)false, (boolean)true);
        Map validateMap = (Map)resultMap.get(extendedDataEntities[0].getDataEntity().getLong("id"));
        if (validateMap != null && HRCollUtil.isNotEmpty((Collection)(validateContentDTOS = (List)validateMap.get(RegBillServiceEnum.ERROR.getCode())))) {
            validateContentDTOS.forEach(validateContentDTO -> this.addFatalErrorMessage(extendedDataEntities[0], validateContentDTO.getTitle()));
        }
    }

    private boolean validateFiledRequired(ExtendedDataEntity[] extendedDataEntities) {
        for (ExtendedDataEntity entity : extendedDataEntities) {
            DynamicObject bill = entity.getDataEntity();
            long regCategory = bill.getLong("regcategory_id");
            Date regDate = bill.getDate("effectdate");
            long regCommentId = bill.getLong("regcomment.id");
            long actionId = bill.getLong("affaction.id");
            if ((!RegCommentEnum.AGREE.getId().equals(regCommentId) || regDate != null) && 0L != regCategory && 0L != actionId) continue;
            return false;
        }
        return true;
    }
}

