/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.validator.reg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;

public class RegAppBillMobileValidator
extends HRDataBaseValidator {
    private static final String FORMAT = "yyyy-MM-dd";

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        this.submitValidate(extendedDataEntities);
    }

    private void submitValidate(ExtendedDataEntity[] extendedDataEntities) {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            HashMap<String, List<String>> errorMap = new HashMap<String, List<String>>();
            errorMap.put(RegBillServiceEnum.WARNING.getCode(), new ArrayList());
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
            IRegBillService.getInstance().doValidateBillInProcess(dynamicObject, errorMap, Boolean.FALSE);
            if (this.showMessage(extendedDataEntity, errorMap)) {
                return;
            }
            IPersonAboutService.getInstance().doValidatePersonQuitAlready(dynamicObject, errorMap, Boolean.FALSE);
            if (this.showMessage(extendedDataEntity, errorMap)) {
                return;
            }
            IRegBillService.getInstance().doValidateEffectDateAfterEntryDate(dynamicObject, errorMap, RegBillServiceEnum.ERROR);
            if (this.showMessage(extendedDataEntity, errorMap)) {
                return;
            }
            IPersonAboutService.getInstance().doPersonCrossValidate(dynamicObject, errorMap, Boolean.FALSE);
            IRegBillService.getInstance().doValidateEffectDateAfterPreActualDate(dynamicObject, errorMap, RegBillServiceEnum.WARNING);
            if (!this.showMessage(extendedDataEntity, errorMap)) continue;
            return;
        }
    }

    private boolean showMessage(ExtendedDataEntity extendedDataEntity, Map<String, List<String>> errorMap) {
        List<String> errorList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
        if (!CollectionUtils.isEmpty(errorList)) {
            for (String info : errorList) {
                this.addErrorMessage(extendedDataEntity, info);
            }
            return true;
        }
        List<String> warnList = errorMap.get(RegBillServiceEnum.WARNING.getCode());
        if (!CollectionUtils.isEmpty(warnList)) {
            for (String info : warnList) {
                this.addWarningMessage(extendedDataEntity, info);
            }
            return true;
        }
        return false;
    }
}

