/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.validator.reg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.business.reg.domain.service.common.IRegDateService;
import kd.hr.hdm.business.reg.validator.RegApplyValidatorHelper;
import kd.hr.hdm.business.repository.LaborrelstatusRepository;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.ValidateContext;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.hdm.common.transfer.constants.TransferLabRelConstants;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import org.apache.commons.lang.StringUtils;

public class RegAppBillValidator
extends HRDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(RegAppBillValidator.class);
    private List<Long> personIds;
    public static final String SUFFIX_ID = "_id";

    public void validate() {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        if (Boolean.parseBoolean((String)variables.get("batchimport"))) {
            this.doImportProcesses(this.dataEntities);
        }
        if ("regApplyList".equals(variables.get("regApplyList"))) {
            LOGGER.info("validate start....");
            List rebBillList = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Map resultMap = RegApplyValidatorHelper.regApplyValidate(rebBillList, (String)"operate_event", (boolean)false, (boolean)false, (boolean)true);
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                long regBillId = extendedDataEntity.getDataEntity().getLong("id");
                Map validateMap = (Map)resultMap.get(regBillId);
                if (validateMap == null) continue;
                StringBuilder sb = new StringBuilder();
                validateMap.values().forEach(validateContentDTOS -> {
                    if (validateContentDTOS.size() > 0) {
                        validateContentDTOS.forEach(validateContentDTO -> {
                            sb.append(validateContentDTO.getTitle());
                            sb.append("\r\n");
                        });
                    }
                });
                if (sb.length() <= 0) continue;
                this.addFatalErrorMessage(extendedDataEntity, sb.toString());
            }
        }
    }

    private void doImportProcesses(ExtendedDataEntity[] dataEntities) {
        LOGGER.info("###RegAppBillValidator.doImportProcesses start, data size is:{}", (Object)dataEntities.length);
        List<DataValidate<DynamicObject>> dataValidates = Arrays.stream(dataEntities).map(item -> new DataValidate((Object)item.getDataEntity(), new ValidateContext())).collect(Collectors.toList());
        LOGGER.info("###RegAppBillValidator.buildRegAppBillData start");
        this.buildRegAppBillData(dataValidates);
        LOGGER.info("###RegAppBillValidator.importValidate start");
        this.validateErmanfileAndOrgIsDifferent(dataEntities);
        this.importValidate(dataValidates);
        LOGGER.info("###RegAppBillValidator.filterValidatePass start");
        List<DataValidate<DynamicObject>> validatePassList = this.filterValidatePass(dataValidates);
        LOGGER.info("###RegAppBillValidator.validateBeforeSave start, filter pass data size is:{}", (Object)validatePassList.size());
        if (HRCollUtil.isNotEmpty(validatePassList)) {
            this.validateBeforeSave(validatePassList);
        }
        LOGGER.info("###RegAppBillValidator.validateBeforeSave completed");
        this.showErrorMsg(dataValidates);
    }

    private void validateErmanfileAndOrgIsDifferent(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject regBilll = dataEntity.getDataEntity();
            long ermanfileOrg = regBilll.getLong("ermanfile.org.id");
            long org = regBilll.getLong("org.id");
            LOGGER.info("\u6821\u9a8c\u5bfc\u5165\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7 ermanfileOrg={}, org={}", (Object)ermanfileOrg, (Object)org);
            if (org == 0L || ermanfileOrg == org) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u6b63\u4eba\u5458\u4e0d\u5728\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u7684\u7ba1\u7406\u6743\u9650\u8303\u56f4\u5185\uff1b", (String)"RegAppBillValidator_12", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void importValidate(List<DataValidate<DynamicObject>> dataValidates) {
        Map personLicensesMap = HRCertValidateServiceHelper.checkPersonLicenses(this.personIds);
        List affactionIds = dataValidates.stream().map(dv -> ((DynamicObject)dv.getData()).getLong("affaction.id")).distinct().collect(Collectors.toList());
        Map laborrelstatusMap = PersonnelChangeServiceHelper.getLaborrelstatusByAffactions(affactionIds);
        for (DataValidate<DynamicObject> dataValidate : dataValidates) {
            Map validateResult = dataValidate.getValidatorContext().getValidateResult();
            if (HRMapUtils.isEmpty((Map)validateResult)) {
                this.validateLicense(dataValidate, personLicensesMap);
            }
            if (HRMapUtils.isEmpty((Map)validateResult)) {
                this.executeRegComment(dataValidate, laborrelstatusMap);
            }
            if (HRMapUtils.isEmpty((Map)validateResult)) {
                this.executeRegCategory(dataValidate);
            }
            if (!HRMapUtils.isEmpty((Map)validateResult)) continue;
            this.executeEffectDate(dataValidate);
        }
    }

    private void validateProbationLaw(List<DataValidate<DynamicObject>> dataValidateList) {
        List regBillList = dataValidateList.stream().map(DataValidate::getData).collect(Collectors.toList());
        Map validateMap = IRegProbationService.getInstance().batchValidateProbationPostponeByRuleEngine(regBillList, "operate_event", false);
        dataValidateList.forEach(dataValidate -> {
            ValidateRangeEnum range;
            long regBillId = ((DynamicObject)dataValidate.getData()).getLong("id");
            DataValidate ruleResult = (DataValidate)validateMap.get(regBillId);
            if (ruleResult != null && ValidateRangeEnum.VALIDATE_ERROR == (range = ruleResult.getValidatorContext().getRange())) {
                Map validateResult = ruleResult.getValidatorContext().getValidateResult();
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", (String)validateResult.get("title"));
            }
        });
    }

    private void buildRegAppBillData(List<DataValidate<DynamicObject>> dataValidates) {
        this.personIds = new ArrayList<Long>(dataValidates.size());
        for (DataValidate<DynamicObject> item2 : dataValidates) {
            DynamicObject regAppBill = (DynamicObject)item2.getData();
            DynamicObject erManFile = regAppBill.getDynamicObject("ermanfile");
            regAppBill.set("person", erManFile.get("person"));
            long personId = erManFile.getLong("person.id");
            this.personIds.add(personId);
        }
        Map primaryErManFileMap = HRServiceUtil.listPrimaryErmanFile(this.personIds);
        if (primaryErManFileMap == null || primaryErManFileMap.size() < 1) {
            dataValidates.forEach(dataValidate -> dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_2", ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u7b26\u5408\u53d1\u8d77\u8f6c\u6b63\u4e1a\u52a1\u7684\u6761\u4ef6\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"RegAppBillValidator_2", (String)"hr-hdm-opplugin", (Object[])new Object[0])));
            return;
        }
        List<Long> employeeIds = primaryErManFileMap.values().stream().map(dy -> dy.getLong("employee.id")).collect(Collectors.toList());
        Map<Long, Map<String, Object>> tutorsMap = this.getTutorsMapByEmployeeIds(employeeIds);
        List primaryErManFileIds = primaryErManFileMap.values().stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        Map<Long, Map> personCardFieldsMap = IPersonAboutService.getInstance().batchBuildPersonChangeParams(primaryErManFileIds).stream().collect(Collectors.toMap(item -> (Long)item.get("person_id"), item -> item, (k1, k2) -> k1));
        Map<Long, Map> regInfoMap = IPersonAboutService.getInstance().batchBuildRegInfo(employeeIds).stream().collect(Collectors.toMap(item -> (Long)item.get("person_id"), item -> item, (k1, k2) -> k1));
        HashMap<Long, DynamicObject> laborrelStatusMap = new HashMap<Long, DynamicObject>(8);
        for (DataValidate<DynamicObject> dataValidate2 : dataValidates) {
            Map personReturnMap;
            DynamicObject regAppBill = (DynamicObject)dataValidate2.getData();
            long personId = regAppBill.getDynamicObject("ermanfile").getLong("person.id");
            DynamicObject primaryErManFile = (DynamicObject)primaryErManFileMap.get(personId);
            regAppBill.set("ermanfile", (Object)primaryErManFile);
            DynamicObject employeeObj = primaryErManFile.getDynamicObject("employee");
            if (Objects.nonNull(employeeObj)) {
                regAppBill.set("bemployee", (Object)employeeObj);
                Map<String, Object> tutorMap = tutorsMap.get(employeeObj.getLong("id"));
                if (Objects.nonNull(tutorMap)) {
                    this.buildEmptutorInfo(regAppBill, tutorMap);
                }
            }
            if (Objects.nonNull(personReturnMap = personCardFieldsMap.get(personId))) {
                Long filetypeId = (Long)personReturnMap.get("filetype_id");
                Long laborrelStatusId = (Long)personReturnMap.get("laborrelstatus_id");
                String businessStatus = String.valueOf(personReturnMap.get("businessstatus"));
                Map validateResult = dataValidate2.getValidatorContext().getValidateResult();
                DynamicObject cacheLaborrelStatus = (DynamicObject)laborrelStatusMap.get(laborrelStatusId);
                if (Objects.isNull(cacheLaborrelStatus) && Objects.nonNull(cacheLaborrelStatus = LaborrelstatusRepository.getInstance().queryOne("labrelstatuscls", (Object)laborrelStatusId))) {
                    laborrelStatusMap.put(laborrelStatusId, cacheLaborrelStatus);
                }
                if (Objects.isNull(cacheLaborrelStatus)) {
                    LOGGER.error("###RegAppBillValidator.buildRegAppBillData error, cacheLaborrelStatus is null, laborrelStatusId is :{}", (Object)laborrelStatusId);
                    return;
                }
                DynamicObject labrelStatuscls = cacheLaborrelStatus.getDynamicObject("labrelstatuscls");
                long labrelStatusclsId = labrelStatuscls.getLong("id");
                if (LabRelConstants.QUIT.equals(labrelStatusclsId) && HRMapUtils.isEmpty((Map)validateResult)) {
                    String errMsg = ResManager.loadKDString((String)"\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"RegAppBillValidator_8", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                    dataValidate2.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_8", errMsg);
                }
                boolean isFileTypeEmp = TransferLabRelConstants.FILE_TYPE_EMP.equals(filetypeId);
                boolean isTakeEffect = "1".equals(businessStatus);
                if (!(!HRMapUtils.isEmpty((Map)validateResult) || isFileTypeEmp && labrelStatusclsId == LabRelConstants.PROBATION && isTakeEffect)) {
                    String errMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u7b26\u5408\u53d1\u8d77\u8f6c\u6b63\u4e1a\u52a1\u7684\u6761\u4ef6\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"RegAppBillValidator_2", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                    if (dataValidate2.getValidatorContext().getValidateResult().size() == 0) {
                        dataValidate2.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_2", errMsg);
                    }
                }
            } else {
                dataValidate2.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_2", ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u7b26\u5408\u53d1\u8d77\u8f6c\u6b63\u4e1a\u52a1\u7684\u6761\u4ef6\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"RegAppBillValidator_2", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                return;
            }
            this.buildPersonInfo(regAppBill, personReturnMap);
            Map regInfo = regInfoMap.get(regAppBill.getLong("person_id"));
            if (!Objects.nonNull(regInfo)) continue;
            this.buildRegInfo(regAppBill, regInfo);
        }
    }

    private void executeRegCategory(DataValidate<DynamicObject> dataValidate) {
        DynamicObject regAppBill = (DynamicObject)dataValidate.getData();
        DynamicObject regCategory = regAppBill.getDynamicObject("regcategory");
        if (RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) {
            this.setPostponeInfo(regAppBill);
            this.executeProbation(dataValidate);
            return;
        }
        this.judgeRegEarly(dataValidate);
    }

    private void executeEffectDate(DataValidate<DynamicObject> dataValidate) {
        DynamicObject regAppBill = (DynamicObject)dataValidate.getData();
        Date entryDate = regAppBill.getDate("entrydate");
        Date effectDate = regAppBill.getDate("effectdate");
        if (Objects.isNull(entryDate) || Objects.isNull(effectDate)) {
            return;
        }
        if (effectDate.before(entryDate)) {
            String errMsg = ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegAppBillValidator_3", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_3", errMsg);
            return;
        }
        this.judgeRegEarly(dataValidate);
    }

    private void executeRegComment(DataValidate<DynamicObject> dataValidate, Map<Long, List<DynamicObject>> laborrelstatusMap) {
        DynamicObject regAppBill = (DynamicObject)dataValidate.getData();
        DynamicObject regCommentObj = regAppBill.getDynamicObject("regcomment");
        if (Objects.nonNull(regCommentObj) && 1010L == regCommentObj.getLong("id")) {
            regAppBill.set("probationex", null);
            regAppBill.set("postponedate", null);
            if (Objects.isNull(regAppBill.getDate("effectdate"))) {
                String errMsg = ResManager.loadKDString((String)"\u5982\u679c\u8f6c\u6b63\u610f\u89c1\u4e3a\u201c\u540c\u610f\u8f6c\u6b63\u201d\uff0c\u9700\u586b\u5199\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"RegAppBillValidator_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_0", errMsg);
            }
            long affactionId = regAppBill.getLong("affaction.id");
            if (laborrelstatusMap == null || !laborrelstatusMap.containsKey(affactionId)) {
                String errMsg = ResManager.loadKDString((String)"\u201c\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u586b\u5199\u6709\u8bef\uff0c \u8bf7\u4fee\u6539\u3002", (String)"RegAppBillValidator_13", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_13", errMsg);
            } else {
                List<DynamicObject> laborrelstatusDys = laborrelstatusMap.get(affactionId);
                Set laborrelstatusList = laborrelstatusDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                if (!laborrelstatusList.contains(regAppBill.getLong("laborrelstatus.id"))) {
                    String errMsg = ResManager.loadKDString((String)"\u201c\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u586b\u5199\u6709\u8bef\uff0c \u8bf7\u4fee\u6539\u3002", (String)"RegAppBillValidator_13", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                    dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_13", errMsg);
                }
            }
        }
        if (Objects.nonNull(regCommentObj) && 1020L == regCommentObj.getLong("id")) {
            regAppBill.set("effectdate", null);
        }
    }

    private void validateBeforeSave(List<DataValidate<DynamicObject>> validatePassList) {
        LOGGER.info("###RegAppBillValidator doBatchValidateBillInProcess start");
        IRegBillService.getInstance().doBatchValidateBillInProcess(validatePassList);
        List<DataValidate<DynamicObject>> passDataValidates = this.filterValidatePass(validatePassList);
        LOGGER.info("###RegAppBillValidator doPersonCrossValidateBatchForRegAppImport start, doBatchValidateBillInProcess pass data size is:{}", (Object)passDataValidates.size());
        if (HRCollUtil.isNotEmpty(passDataValidates)) {
            this.personCrossValidate(passDataValidates);
        }
    }

    private void personCrossValidate(List<DataValidate<DynamicObject>> validatePassList) {
        Map crossBatchMap = IPersonAboutService.getInstance().doPersonCrossValidateBatchForRegAppImport(validatePassList.stream().map(DataValidate::getData).collect(Collectors.toList()));
        if (Boolean.TRUE.equals(crossBatchMap.get("success"))) {
            Map crossListMap = (Map)crossBatchMap.get("data");
            for (DataValidate<DynamicObject> dataValidate : validatePassList) {
                Map validateResult = dataValidate.getValidatorContext().getValidateResult();
                if (!HRMapUtils.isEmpty((Map)validateResult)) continue;
                DynamicObject data = (DynamicObject)dataValidate.getData();
                Long depEmpId = data.getDynamicObject("ermanfile").getLong("depemp_id");
                HashMap errorMap = new HashMap(2);
                errorMap.put(RegBillServiceEnum.WARNING.getCode(), new ArrayList());
                errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
                IPersonAboutService.getInstance().doPersonCrossValidateForBatch(data, errorMap, (List)crossListMap.get(depEmpId), Boolean.FALSE);
                List errorMsgList = (List)errorMap.get(RegBillServiceEnum.ERROR.getCode());
                for (String errorMsg : errorMsgList) {
                    dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "errorMsg", errorMsg);
                }
            }
        }
    }

    private void judgeRegEarly(DataValidate<DynamicObject> dataValidate) {
        DynamicObject regAppBill = (DynamicObject)dataValidate.getData();
        Date effectDate = regAppBill.getDate("effectdate");
        Date preEffectDate = regAppBill.getDate("preactualdate");
        long regCategoryId = regAppBill.getLong("regcategory.id");
        if (regCategoryId == 0L || ObjectUtils.isEmpty((Object)effectDate) || ObjectUtils.isEmpty((Object)preEffectDate)) {
            return;
        }
        if (RegCategoryEnum.INADVANCE.getId() == regCategoryId && preEffectDate.compareTo(effectDate) <= 0 && dataValidate.getValidatorContext().getValidateResult().size() == 0) {
            String errMsg = ResManager.loadKDString((String)"\u5982\u679c\u5458\u5de5\u63d0\u524d\u8f6c\u6b63\uff0c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u9700\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegAppBillValidator_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_1", errMsg);
        }
    }

    private void executeProbation(DataValidate<DynamicObject> dataValidate) {
        DynamicObject regAppBill = (DynamicObject)dataValidate.getData();
        Date entryDate = regAppBill.getDate("entrydate");
        if (Objects.nonNull(entryDate)) {
            int count = regAppBill.getInt("probationex");
            int oldCount = regAppBill.getInt("probation");
            String unit = regAppBill.getString("probationunitex");
            String oldUnit = regAppBill.getString("probationunit");
            Date oldDate = IRegDateService.getInstance().calcDate(entryDate, oldCount, oldUnit);
            Date postPoneDate = IRegDateService.getInstance().calcDate(entryDate, count, unit);
            if (!ObjectUtils.isEmpty((Object)oldDate) && !ObjectUtils.isEmpty((Object)postPoneDate) && postPoneDate.compareTo(oldDate) <= 0 && dataValidate.getValidatorContext().getValidateResult().size() == 0) {
                String errMsg = ResManager.loadKDString((String)"\u5ef6\u957f\u8bd5\u7528\u671f\u9700\u5927\u4e8e\u539f\u8bd5\u7528\u671f\u201c%s\u201d\u3002", (String)"RegAppBillValidator_5", (String)"hr-hdm-opplugin", (Object[])new Object[]{oldCount + RegDateUnitEnum.getName((String)oldUnit)});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_5", errMsg);
                return;
            }
            regAppBill.set("postponedate", (Object)postPoneDate);
        }
    }

    private void setPostponeInfo(DynamicObject regBill) {
        int postponeProbation = regBill.getInt("postponeprobation");
        int postponeEx = regBill.getInt("probationex");
        if (postponeProbation > 0) {
            Map postponeInfoMap = IRegProbationService.getInstance().getPostponeInfoOfEdit(regBill);
            regBill.set("probationex", postponeInfoMap.get("probationex"));
            regBill.set("probationunitex", postponeInfoMap.get("probationunitex"));
        } else if (postponeEx > 0) {
            String probationEXunit;
            String probationUnit = regBill.getString("probationunit");
            if (probationUnit.equals(probationEXunit = regBill.getString("probationunitex"))) {
                int probationEx = regBill.getInt("probationex");
                int probation = regBill.getInt("probation");
                regBill.set("postponeprobation", (Object)(probationEx - probation));
                regBill.set("postponeprobationunit", (Object)probationUnit);
            } else {
                Date preActualDate = regBill.getDate("preactualdate");
                Date entryDate = regBill.getDate("entrydate");
                Date postponeDate = IRegDateService.getInstance().calcDate(entryDate, postponeEx, probationEXunit);
                long dateDiff = HRDateTimeUtils.dateDiff((String)"d", (Date)preActualDate, (Date)postponeDate);
                regBill.set("postponeprobation", (Object)dateDiff);
                regBill.set("postponeprobationunit", (Object)RegDateUnitEnum.DAY.getCode());
            }
        }
    }

    private void buildRegInfo(DynamicObject regAppBill, Map<String, Object> regReturnMap) {
        regAppBill.set("entrydate", regReturnMap.get("startdate"));
        regAppBill.set("probation", regReturnMap.get("probation"));
        regAppBill.set("probationunit", regReturnMap.get("probationunit"));
        regAppBill.set("preactualdate", regReturnMap.get("preregulardate"));
    }

    private void buildPersonInfo(DynamicObject regAppBill, Map<String, Object> personReturnMap) {
        regAppBill.set("bhrbu_id", personReturnMap.get("org_id"));
        regAppBill.set("bempgroup_id", personReturnMap.get("empgroup_id"));
        regAppBill.set("badminorg_id", personReturnMap.get("adminorg_id"));
        regAppBill.set("person_id", personReturnMap.get("person_id"));
        regAppBill.set("bemployee_id", personReturnMap.get("employee_id"));
        regAppBill.set("cmpemp_id", personReturnMap.get("managingscope_id"));
        regAppBill.set("bposition_id", personReturnMap.get("position_id"));
        regAppBill.set("standardpost_id", personReturnMap.get("stdposition_id"));
        regAppBill.set("bjob_id", personReturnMap.get("job_id"));
        regAppBill.set("bdependencytype_id", personReturnMap.get("dependencytype_id"));
        regAppBill.set("laborreltype_id", personReturnMap.get("laborreltype_id"));
    }

    private void buildEmptutorInfo(DynamicObject regAppBill, Map<String, Object> tutorMap) {
        regAppBill.set("tutor", tutorMap.get("tutor_id"));
        DynamicObject erManFile = (DynamicObject)tutorMap.get("erManFile");
        if (Objects.nonNull(erManFile)) {
            DynamicObject empposorgrel = (DynamicObject)erManFile.get("empposrel");
            regAppBill.set("tutorenterprise", (Object)empposorgrel.getString("company.name"));
            regAppBill.set("tutoradminorg", (Object)empposorgrel.getString("adminorg.name"));
            String position = empposorgrel.getString("position.name");
            String stdPosition = empposorgrel.getString("stdposition.name");
            regAppBill.set("tutorposition", (Object)(StringUtils.isNotEmpty((String)stdPosition) ? stdPosition : position));
        }
    }

    private Map<Long, Map<String, Object>> getTutorsMapByEmployeeIds(List<Long> employeeIds) {
        HashMap<Long, Map<String, Object>> tutorAndErManFileMap = new HashMap<Long, Map<String, Object>>(employeeIds.size());
        List tutorList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchEmployeeAttachs", (Object[])new Object[]{employeeIds, null, "hrpi_emptutor"});
        HashMap<Long, Map> tutorsMap = new HashMap<Long, Map>(employeeIds.size());
        ArrayList<Long> tutorIds = new ArrayList<Long>(tutorList.size());
        if (!CollectionUtils.isEmpty((Collection)tutorList)) {
            for (Map item : tutorList) {
                Long tutorId = (Long)item.get("tutor_id");
                if (tutorId == 0L) continue;
                tutorAndErManFileMap.put((Long)item.get("employee_id"), item);
                tutorsMap.put(tutorId, item);
                tutorIds.add(tutorId);
            }
        }
        Map tutorPrimaryErManFileMap = HRServiceUtil.listPrimaryErmanFile(tutorIds);
        for (Map.Entry tutorPrimaryErManFile : tutorPrimaryErManFileMap.entrySet()) {
            ((Map)tutorsMap.get(tutorPrimaryErManFile.getKey())).put("erManFile", tutorPrimaryErManFile.getValue());
        }
        return tutorAndErManFileMap;
    }

    private void showErrorMsg(List<DataValidate<DynamicObject>> dataValidates) {
        Map dataEntityMap = Arrays.stream(this.dataEntities).collect(Collectors.toMap(dataEntity -> dataEntity.getDataEntity().getLong("id"), Function.identity()));
        dataValidates.forEach(dataValidate -> {
            ValidateRangeEnum range = dataValidate.getValidatorContext().getRange();
            String errMsg = dataValidate.getValidatorContext().map2String();
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)dataEntityMap.get(((DynamicObject)dataValidate.getData()).getLong("id"));
            if (ValidateRangeEnum.VALIDATE_ERROR.getRange().equals(range.getRange())) {
                this.addFatalErrorMessage(dataEntity, errMsg);
            }
        });
    }

    private List<DataValidate<DynamicObject>> filterValidatePass(List<DataValidate<DynamicObject>> dataValidates) {
        return dataValidates.stream().filter(dataValidate -> ValidateRangeEnum.VALIDATE_PASS == dataValidate.getValidatorContext().getRange()).collect(Collectors.toList());
    }

    private void validateLicense(DataValidate<DynamicObject> dataValidate, Map<Long, Map<String, Object>> personLicensesMap) {
        DynamicObject regAppBill = (DynamicObject)dataValidate.getData();
        long personId = regAppBill.getLong("person_id");
        Map<String, Object> personInfo = personLicensesMap.get(personId);
        String errMsg = null;
        try {
            if (HRMapUtils.isEmpty(personInfo)) {
                errMsg = ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"RegAppBillValidator_9", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            }
            if (Boolean.FALSE.equals(personInfo.get("status"))) {
                String name = (String)personInfo.get("name");
                String number = (String)personInfo.get("number");
                errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u8f6c\u6b63\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"RegAppBillValidator_10", (String)"hr-hdm-opplugin", (Object[])new Object[0]), name, number);
            }
        }
        catch (Exception e) {
            errMsg = ResManager.loadKDString((String)"\u6821\u9a8c\u8bb8\u53ef\u5f02\u5e38", (String)"RegAppBillValidator_11", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            LOGGER.error("###RegAppBillValidator.validateLicense error:", (Throwable)e);
        }
        LOGGER.info("###RegAppBillValidator.validateLicense msg:{}, personId:{}", (Object)errMsg, (Object)personId);
        if (!HRStringUtils.isBlank((CharSequence)errMsg)) {
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_7", errMsg);
        }
    }
}

