/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.PostponeAskResultUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.ProbationRemarkUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.opplugin.validator.reg.RegAppBillValidator;

public class BatchRegAppBillOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(BatchRegAppBillOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RegAppBillValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("bemployee", "person", "billno", "ermanfile", "effectdate", "cmpemp", "preactualdate", "laborrelstatus", "laborreltype", "affaction", "entrydate", "regbilltype", "probationunitex", "submittime", "regcategory", "regcomment", "probationex", "org", "ismobile", "postponedate", "probation", "probationunit", "preactualdate", "regstatus", "syncstatus", "termreason", "termdate", "termuser", "isexistsworkflow", "modifytime", "billstatus", "auditstatus", "probationremark", "postponeaskresult", "postponeprobation", "isdirectregular"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] regBillObjs = e.getDataEntities();
        LOGGER.info("submitEffect save start: {},{}", (Object)regBillObjs.length, (Object)regBillObjs[0].getLong("id"));
        this.batchExecuteSubmitAndEffect(regBillObjs);
        IRegProbationService.getInstance().setPostponeAskResult(regBillObjs, PostponeAskResultUpdateSourceEnum.HR_SUBMIT_AND_EFFECT_BILL);
        IRegProbationService.getInstance().setProbationRemark(regBillObjs, ProbationRemarkUpdateSourceEnum.HR_SUBMIT_AND_EFFECT_BILL);
    }

    private void batchExecuteSubmitAndEffect(DynamicObject[] regBillObjs) {
        Date date = new Date();
        for (DynamicObject regBillObj : regBillObjs) {
            regBillObj.set("isdirectregular", (Object)"1");
            regBillObj.set("regbilltype", (Object)RegBillTypeEnum.QUICKSINGLE.getStatus());
            regBillObj.set("submittime", (Object)date);
        }
        IRegBillService service = IRegBillService.getInstance();
        service.syncRegTrace(regBillObjs, "1030");
        service.batchExecuteAuditPassed(regBillObjs);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] originBills = e.getDataEntities();
        List pkS = Arrays.stream(originBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] billObjs = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkS)});
        Map<String, List<DynamicObject>> billMap = Arrays.stream(billObjs).collect(Collectors.groupingBy(bill -> bill.getString("regstatus")));
        billMap.forEach((regStatus, list) -> {
            if (RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(regStatus) || RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) {
                IRegEffectService.getInstance().updateReg(list);
            } else if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus)) {
                IRegBillService.getInstance().updateSyncStatus(list, "-1");
                IRegEffectService.getInstance().effectReg(list);
            }
            if (RegBusinessStatusEnum.WAIT_REG.getCode().equals(regStatus)) {
                IRegEffectService.getInstance().delayReg(list);
            }
        });
    }
}

