/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.opplugin.web.reg.BatchRegBillBaseOp;

public class BatchRegApplyBillSubmitEffectOp
extends BatchRegBillBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObjectCollection entryentity = dataEntities[0].getDynamicObjectCollection("entryentity");
        Object[] regBills = new DynamicObject[entryentity.size()];
        entryentity.toArray(regBills);
        this.executeSubmitAndEffect((DynamicObject[])regBills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObjectCollection entryentity = dataEntities[0].getDynamicObjectCollection("entryentity");
        Object[] regBills = new DynamicObject[entryentity.size()];
        entryentity.toArray(regBills);
        this.submitAndEffect((DynamicObject[])regBills);
    }

    private void executeSubmitAndEffect(DynamicObject[] regBills) {
        this.setRegBillValue(regBills);
        IRegBillService service = IRegBillService.getInstance();
        service.syncRegTrace(regBills, "1030");
        service.batchExecuteAuditPassed(regBills);
    }

    private void setRegBillValue(DynamicObject[] regBills) {
        for (DynamicObject regBill : regBills) {
            regBill.set("isdirectregular", (Object)"1");
            regBill.set("regbilltype", (Object)RegBillTypeEnum.QUICKSINGLE.getStatus());
            regBill.set("submittime", (Object)new Date());
            regBill.set("entrybillstatus", (Object)"C");
            regBill.set("entryauditstatus", (Object)"C");
        }
    }

    private void submitAndEffect(DynamicObject[] regBills) {
        List pkS = Arrays.stream(regBills).map(regBill -> regBill.getLong("id")).collect(Collectors.toList());
        DynamicObject[] billObjs = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkS)});
        Map<String, List<DynamicObject>> billMap = Arrays.stream(billObjs).collect(Collectors.groupingBy(bill -> bill.getString("regstatus")));
        billMap.forEach((regStatus, list) -> {
            if (RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(regStatus) || RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) {
                IRegEffectService.getInstance().updateReg(list);
            } else if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus)) {
                IRegBillService.getInstance().updateSyncStatus(list, "-1");
                IRegEffectService.getInstance().effectReg(list);
            }
            if (RegBusinessStatusEnum.WAIT_REG.getCode().equals(regStatus)) {
                IRegEffectService.getInstance().delayReg(list);
            }
        });
    }
}

