/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.opplugin.web.reg.BatchRegBillBaseOp;

public class BatchRegApplyBillSubmitOp
extends BatchRegBillBaseOp {
    private static final ThreadPool THREADPOOL = ThreadPools.newFixedThreadPool((String)"BatchRegApplyBillSubmitOpThreadPool", (int)4);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject batchRegBill = dataEntities[0];
        DynamicObjectCollection entryentity = batchRegBill.getDynamicObjectCollection("entryentity");
        batchRegBill.set("issubmit", (Object)"1");
        Object[] regBills = new DynamicObject[entryentity.size()];
        entryentity.toArray(regBills);
        this.setBillStatus((DynamicObject[])regBills);
        IRegBillService.getInstance().executeSubmit((DynamicObject[])regBills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject batchRegBill = dataEntities[0];
        DynamicObjectCollection entryentity = batchRegBill.getDynamicObjectCollection("entryentity");
        List pkS = entryentity.stream().map(orginBill -> orginBill.getLong("id")).collect(Collectors.toList());
        DynamicObject[] bills = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkS)});
        this.sendCrossMessage(bills);
    }

    private void setBillStatus(DynamicObject[] regBills) {
        for (DynamicObject regBill : regBills) {
            regBill.set("entrybillstatus", (Object)"B");
            regBill.set("entryauditstatus", (Object)"B");
        }
    }

    private void sendCrossMessage(DynamicObject[] bills) {
        THREADPOOL.execute(() -> {
            IRegEffectService.getInstance().updateReg(bills);
            IPersonAboutService.getInstance().doUpdatePersonCrossData(bills, "1010");
        }, RequestContext.get());
    }
}

