/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.domain.service.common.IDataBaseAboutService;
import kd.hr.hdm.business.repository.RegcommentRepository;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;

public class RegAppBillImportOp
extends BatchImportPlugin {
    private static final String APP_KEY = "hdm_regappbill_import";
    private static final String REPEAT_KEY = "KEY_RegAppBillImportOp_NUMBER_";
    private static final Log LOGGER = LogFactory.getLog(RegAppBillImportOp.class);
    private Map<String, Long> noAgreeCategoryMap;
    private Map<String, Long> agreeCategoryMap;
    private Map<Long, String> regcommentMap;

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            FormView formView = (FormView)view.get(ctx);
            formView.setVisible(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        LOGGER.info("###RegAppBillImportOp start import, the batch data size is : [{}]", (Object)rowdatas.size());
        Iterator<ImportBillData> it = rowdatas.iterator();
        IDataBaseAboutService dataBaseAboutService = IDataBaseAboutService.getInstance();
        List<DynamicObject> categoryList = Arrays.asList(dataBaseAboutService.listRegCateGory());
        this.noAgreeCategoryMap = categoryList.stream().filter(i -> RegCommentEnum.DISAGREE.getId().equals(i.getLong("group.id"))).collect(Collectors.toMap(temp -> temp.getString("number"), temp -> temp.getLong("id"), (o, n) -> n));
        this.agreeCategoryMap = categoryList.stream().filter(i -> RegCommentEnum.AGREE.getId().equals(i.getLong("group.id"))).collect(Collectors.toMap(temp -> temp.getString("number"), temp -> temp.getLong("id"), (o, n) -> n));
        DynamicObject[] regcomments = RegcommentRepository.getInstance().queryAllEnabled("id, name");
        this.regcommentMap = Arrays.stream(regcomments).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLocaleString("name").getLocaleValue(), (oldV, newV) -> oldV));
        Set numbers = rowdatas.stream().map(i -> i.getData().getJSONObject("ermanfile").getString("number")).collect(Collectors.toSet());
        DynamicObject[] dynamicObjects = IHSPMService.getInstance().listPrimaryErManFilesByEmpNumber(new ArrayList(numbers));
        Map<String, DynamicObject> ermanfileMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity()));
        String type = ((JSONObject)rowdatas.get(0).getData().get((Object)"affaction")).containsKey((Object)"number") ? "number" : "name";
        Set affactions = rowdatas.stream().map(importBillData -> importBillData.getData().getJSONObject("affaction").getString(type)).collect(Collectors.toSet());
        Map newAffactionMap = PersonnelChangeServiceHelper.getNewAffactionMap((String)type, affactions, (String)"hdm_reg_hpfs_new");
        LOGGER.info("###RegAppBillImportOp start basic validate");
        while (it.hasNext()) {
            ImportBillData importBillData2 = it.next();
            boolean validatePass = this.validateImportBillData(importBillData2, ermanfileMap, logger, newAffactionMap);
            if (validatePass) continue;
            it.remove();
        }
        LOGGER.info("###RegAppBillImportOp basic validate completed");
        return super.save(rowdatas, logger);
    }

    private boolean validateImportBillData(ImportBillData importBillData, Map<String, DynamicObject> ermanfileMap, ImportLogger impLogger, Map<String, DynamicObject> newAffactionMap) {
        boolean isSuccess;
        String errorMsg = "";
        JSONObject data = importBillData.getData();
        JSONObject erManFileJson = data.getJSONObject("ermanfile");
        String key = REPEAT_KEY + RequestContext.get().getTraceId();
        IHRAppCache cache = HRAppCache.get((String)APP_KEY);
        ArrayList<String> numbers = (ArrayList<String>)cache.get(key, List.class);
        if (CollectionUtils.isEmpty((Collection)numbers)) {
            numbers = new ArrayList<String>(10);
        }
        String number = erManFileJson.getString("number");
        String name = erManFileJson.getString("name");
        if (ermanfileMap != null && ermanfileMap.containsKey(number)) {
            DynamicObject ermanfile = ermanfileMap.get(number);
            erManFileJson.put("importprop", (Object)"id");
            erManFileJson.put("id", (Object)ermanfile.getLong("id"));
            erManFileJson.put("number", (Object)number);
            data.put("baffiliateadminorg", JsonObjectUtil.genJSONObject.apply(ermanfile.getLong("affiliateadminorg_id")));
            String nameInDb = ermanfile.getString("name");
            if (!HRStringUtils.isBlank((CharSequence)name) && Objects.nonNull(nameInDb) && !nameInDb.equals(name)) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5de5\u53f7\u4e0e\u59d3\u540d\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"RegAppBillImportValidator_5", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                impLogger.log(Integer.valueOf(importBillData.getStartIndex()), errorMsg);
            }
        }
        if (numbers.contains(number)) {
            errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u6279\u6b21\u4e2d\u5de5\u53f7\u91cd\u590d\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"RegAppBillImportValidator_3", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            impLogger.log(Integer.valueOf(importBillData.getStartIndex()), errorMsg);
        } else {
            numbers.add(number);
            cache.put(key, numbers);
        }
        JSONObject affaction = (JSONObject)data.get((Object)"affaction");
        String type = affaction.containsKey((Object)"number") ? "number" : "name";
        String affactionValue = data.getJSONObject("affaction").getString(type);
        if (!newAffactionMap.isEmpty() && newAffactionMap.containsKey(affactionValue)) {
            data.put("affaction", JsonObjectUtil.genJSONObject.apply(newAffactionMap.get(affactionValue).getLong("id")));
        } else {
            errorMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegAppBillImportValidator_7", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            impLogger.log(Integer.valueOf(importBillData.getStartIndex()), errorMsg);
        }
        String regComment = data.getJSONObject("regcomment").getString("name");
        boolean isAgree = this.regcommentMap.getOrDefault(RegCommentEnum.AGREE.getId(), "").equals(regComment);
        if (isAgree && Objects.isNull(data.get((Object)"effectdate"))) {
            errorMsg = ResManager.loadKDString((String)"\u5982\u679c\u8f6c\u6b63\u610f\u89c1\u4e3a\u201c\u540c\u610f\u8f6c\u6b63\u201d\uff0c\u9700\u586b\u5199\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"RegAppBillImportValidator_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            impLogger.log(Integer.valueOf(importBillData.getStartIndex()), errorMsg);
        }
        if (isAgree && Objects.isNull(data.get((Object)"laborrelstatus"))) {
            errorMsg = ResManager.loadKDString((String)"\u8f6c\u6b63\u610f\u89c1\u4e3a\u201c\u540c\u610f\u8f6c\u6b63\u201d\u65f6\uff0c\u201c\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegAppBillImportValidator_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            impLogger.log(Integer.valueOf(importBillData.getStartIndex()), errorMsg);
        }
        if (!isAgree && !Objects.isNull(data.get((Object)"laborrelstatus"))) {
            data.remove((Object)"laborrelstatus");
        }
        String regCategoryNumber = data.getJSONObject("regcategory").getString("number");
        if (isAgree && this.noAgreeCategoryMap.get(regCategoryNumber) != null || !isAgree && this.agreeCategoryMap.get(regCategoryNumber) != null) {
            errorMsg = ResManager.loadKDString((String)"\u201c\u8f6c\u6b63\u5206\u7c7b\u201d\u548c\u201c\u8f6c\u6b63\u610f\u89c1\u201d\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegAppBillImportValidator_6", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            impLogger.log(Integer.valueOf(importBillData.getStartIndex()), errorMsg);
        }
        boolean isPostPhone = RegCategoryEnum.POSTPHONE.getId().equals(this.noAgreeCategoryMap.get(regCategoryNumber));
        Object pro = data.get((Object)"probationex");
        Object proUnit = data.get((Object)"probationunitex");
        if (!isAgree && isPostPhone && (Objects.isNull(pro) || Objects.isNull(proUnit)) && !(isSuccess = this.validatePostponeInfo(data))) {
            errorMsg = ResManager.loadKDString((String)"\u8f6c\u6b63\u610f\u89c1\u4e3a\u201c\u4e0d\u540c\u610f\u8f6c\u6b63\u201d\u4e14\u8f6c\u6b63\u5206\u7c7b\u4e3a\u201c\u5ef6\u671f\u8f6c\u6b63\u201d\u65f6\uff0c\u201c\u5ef6\u957f\u8bd5\u7528\u671f\u957f\u5ea6/\u5355\u4f4d\u201d\u5fc5\u586b\u3002", (String)"RegAppBillImportValidator_4", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            impLogger.log(Integer.valueOf(importBillData.getStartIndex()), errorMsg);
        }
        if (!HRStringUtils.isBlank((CharSequence)errorMsg)) {
            impLogger.fail();
            return false;
        }
        return true;
    }

    private boolean validatePostponeInfo(JSONObject data) {
        Object postponeProbation = data.get((Object)"postponeprobation");
        Object postponeProbationUnit = data.get((Object)"postponeprobationunit");
        Object probationEx = data.get((Object)"probationex");
        Object probationExUnit = data.get((Object)"probationunitex");
        if (!(Objects.isNull(postponeProbation) || "0".equals(postponeProbation) || Objects.isNull(postponeProbationUnit))) {
            return true;
        }
        return !Objects.isNull(probationEx) && !Objects.isNull(probationExUnit);
    }
}

