/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.PostponeAskResultUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.ProbationRemarkUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.opplugin.validator.reg.RegAppBillValidator;

public class RegAppBillOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(RegAppBillOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RegAppBillValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("bemployee", "person", "billno", "ermanfile", "effectdate", "cmpemp", "preactualdate", "laborrelstatus", "laborreltype", "affaction", "entrydate", "regbilltype", "probationunitex", "submittime", "regcategory", "regcomment", "probationex", "org", "ismobile", "postponedate", "probation", "probationunit", "preactualdate", "regstatus", "syncstatus", "termreason", "termdate", "termuser", "isexistsworkflow", "modifytime", "billstatus", "auditstatus", "probationremark", "postponeaskresult"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] regBillObjs = e.getDataEntities();
        try {
            List employeeIdList = Arrays.stream(regBillObjs).map(temp -> temp.getLong("bemployee.id")).collect(Collectors.toList());
            List personIdList = Arrays.stream(regBillObjs).map(temp -> temp.getLong("person.id")).collect(Collectors.toList());
            PostponeAskResultUpdateSourceEnum postponeAskResultUpdateSourceEnum = null;
            ProbationRemarkUpdateSourceEnum probationRemarkUpdateSourceEnum = null;
            switch (e.getOperationKey()) {
                case "submit": {
                    this.validateProcessIn(regBillObjs);
                    postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.HR_SUBMIT_BILL;
                    probationRemarkUpdateSourceEnum = ProbationRemarkUpdateSourceEnum.HR_SUBMIT_BILL;
                    this.executeSubmit(regBillObjs);
                    break;
                }
                case "submiteffect": {
                    this.validateProcessIn(regBillObjs);
                    postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.HR_SUBMIT_AND_EFFECT_BILL;
                    probationRemarkUpdateSourceEnum = ProbationRemarkUpdateSourceEnum.HR_SUBMIT_AND_EFFECT_BILL;
                    this.executeSubmitAndEffect(regBillObjs[0]);
                    break;
                }
                case "save": {
                    this.validateProcessIn(regBillObjs);
                    postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.HR_SAVE_BILL;
                    probationRemarkUpdateSourceEnum = ProbationRemarkUpdateSourceEnum.HR_SAVE_BILL;
                    String type = regBillObjs[0].getString("regbilltype");
                    RegProcessServiceHelper.updateWhenRegBatch(employeeIdList, personIdList, (boolean)RegBillTypeEnum.QUICKSINGLE.getStatus().equals(type), (String)"1010", null);
                    break;
                }
            }
            IRegProbationService.getInstance().setPostponeAskResult(regBillObjs, postponeAskResultUpdateSourceEnum);
            IRegProbationService.getInstance().setProbationRemark(regBillObjs, probationRemarkUpdateSourceEnum);
        }
        catch (Exception ex) {
            LOGGER.error("regApply beginOperationTransaction exception:", (Throwable)ex);
            IRegBillService.getInstance().releaseDLock(regBillObjs[0]);
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u6570\u636e\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"RegAppBillOp_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
        }
    }

    private void executeSubmit(DynamicObject[] bills) {
        IRegBillService.getInstance().executeSubmit(bills);
    }

    private void executeSubmitAndEffect(DynamicObject regBillObj) {
        regBillObj.set("isdirectregular", (Object)"1");
        regBillObj.set("regbilltype", (Object)RegBillTypeEnum.QUICKSINGLE.getStatus());
        regBillObj.set("submittime", (Object)new Date());
        IRegBillService service = IRegBillService.getInstance();
        service.syncRegTrace(new DynamicObject[]{regBillObj}, "1030");
        regBillObj.set("billstatus", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
        service.executeAuditPassed(regBillObj);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] originBills = e.getDataEntities();
        List pkS = Arrays.stream(originBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] billObjs = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkS)});
        switch (e.getOperationKey()) {
            case "save": {
                IRegBillService.getInstance().releaseDLock(originBills[0]);
                break;
            }
            case "submiteffect": {
                IRegBillService.getInstance().releaseDLock(originBills[0]);
                String regStatus = billObjs[0].getString("regstatus");
                if (RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(regStatus) || RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) {
                    IRegEffectService.getInstance().updateReg(billObjs[0]);
                }
                if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus)) {
                    IRegBillService.getInstance().updateSyncStatus(Collections.singletonList(billObjs[0]), "-1");
                    IRegEffectService.getInstance().effectReg(billObjs[0]);
                }
                if (!RegBusinessStatusEnum.WAIT_REG.getCode().equals(regStatus)) break;
                IRegEffectService.getInstance().delayReg(billObjs[0]);
                break;
            }
            case "submit": {
                IRegBillService.getInstance().releaseDLock(originBills[0]);
                IRegEffectService.getInstance().updateReg(billObjs);
                IPersonAboutService.getInstance().doUpdatePersonCrossData(billObjs, "1010");
            }
        }
    }

    private void validateProcessIn(DynamicObject[] bills) {
        if (bills.length > 1) {
            return;
        }
        IRegBillService.getInstance().beforeBeginTransactionValidateProcessIn(bills[0]);
    }
}

