/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.mq.sender.RegMQHelper;
import kd.hr.hdm.business.reg.RegAskServiceHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;

public class RegAskSubmitOp
extends HRDataBaseOp {
    private boolean isChangeStatus = false;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject object = e.getDataEntities()[0];
        if (HRStringUtils.equals((String)e.getOperationKey(), (String)"submit")) {
            boolean isAgree = object.getBoolean("checkboxagree");
            String opinion = isAgree ? "1" : "0";
            object.set("opinion", (Object)opinion);
            object.set("status", (Object)"1030");
            String comment = object.getString("commentshow");
            object.set("comment", (Object)comment);
            object.set("finshtime", (Object)new Date());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject object = e.getDataEntities()[0];
        if (HRStringUtils.equals((String)e.getOperationKey(), (String)"submit")) {
            Long employee = object.getLong("bemployee");
            Long personId = object.getDynamicObject("person").getLong("id");
            Long resultId = object.getLong("result");
            Long detailId = object.getLong("id");
            QFilter commonFilter = new QFilter("result", "=", (Object)resultId).and("isnewest", "=", (Object)Boolean.TRUE);
            DynamicObject[] objects = RegAskServiceHelper.DETAILS_SERVICE_HELPER.query("result,bemployee,person,askperson,opinion,status,isnewest", new QFilter[]{commonFilter});
            boolean hasDisagree = false;
            HashMap maps = Maps.newHashMapWithExpectedSize((int)objects.length);
            for (DynamicObject obj : objects) {
                if (!hasDisagree && "0".equals(obj.getString("opinion"))) {
                    hasDisagree = true;
                }
                long askPersonId = obj.getLong("askperson_id");
                String status = obj.getString("status");
                if (maps.containsKey(askPersonId) && (!maps.containsKey(askPersonId) || !"1030".equals(status))) continue;
                maps.put(askPersonId, obj);
            }
            boolean showResult = maps.values().stream().noneMatch(dynamicObject -> "1020".equals(dynamicObject.getString("status")));
            boolean allComplete = maps.values().stream().allMatch(dynamicObject -> "1030".equals(dynamicObject.getString("status")));
            if (allComplete) {
                hasDisagree = maps.values().stream().anyMatch(dynamicObject -> dynamicObject.getString("opinion").equals("0"));
            }
            ArrayList<Long> askPerson = new ArrayList<Long>();
            askPerson.add(object.getLong("askperson_id"));
            RegAskServiceHelper.updateOldAskDetails((Long)employee, askPerson, (Long)detailId);
            if (showResult) {
                String askResult = hasDisagree ? "0" : "1";
                RegAskServiceHelper.updateAskResult((Long)employee, (Long)personId, (String)askResult);
                this.isChangeStatus = RegProcessServiceHelper.updateWhenAsk((long)employee, (long)personId, (String)"1030");
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (this.isChangeStatus) {
            DynamicObject detail = e.getDataEntities()[0];
            Long erManFileId = detail.getLong("ermanfile");
            RegMQHelper.getInstance().syncProcessStatus(erManFileId, this.isChangeStatus, false);
        }
    }
}

