/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.enums.PostponeAskResultUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.ProbationRemarkUpdateSourceEnum;

public class RegHrSupplySubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("bemployee", "person", "billno", "ermanfile", "effectdate", "cmpemp", "preactualdate", "laborrelstatus", "laborreltype", "affaction", "entrydate", "regbilltype", "probationunitex", "submittime", "regcategory", "regcomment", "probationex", "org", "ismobile", "postponedate", "probation", "probationunit", "preactualdate", "regstatus", "syncstatus", "termreason", "termdate", "termuser", "isexistsworkflow", "modifytime", "billstatus", "auditstatus", "probationremark", "postponeaskresult"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] regBillObjects = e.getDataEntities();
        IRegProbationService.getInstance().setPostponeAskResult(regBillObjects, PostponeAskResultUpdateSourceEnum.HR_SUBMIT_BILL);
        IRegProbationService.getInstance().setProbationRemark(regBillObjects, ProbationRemarkUpdateSourceEnum.HR_SUBMIT_BILL);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] originBills = e.getDataEntities();
        List pkValues = Arrays.stream(originBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] billObjs = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkValues)});
        switch (e.getOperationKey()) {
            case "supplement": {
                IPersonAboutService.getInstance().doUpdatePersonCrossData(billObjs, "1030");
            }
        }
    }
}

