/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.opplugin.web.reg.RegEventBaseOp;

public class RegRejectToSubmitEventOp
extends RegEventBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] regBillObjs = e.getDataEntities();
        switch (e.getOperationKey()) {
            case "wfrejecttosubmit": {
                IRegBillService.getInstance().executeAuditToSubmit(regBillObjs);
                break;
            }
            case "wfrejecttoedit": {
                IRegBillService.getInstance().executeAuditToEdit(regBillObjs);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] originBills = e.getDataEntities();
        if ("wfrejecttosubmit".equals(e.getOperationKey())) {
            List pkS = Arrays.stream(originBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] objects = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkS)});
            IRegEffectService.getInstance().updateReg(objects);
            IPersonAboutService.getInstance().doUpdatePersonCrossData(objects, "1040");
        }
    }
}

