/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.enums.PostponeAskResultUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.ProbationRemarkUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.util.HRServiceUtil;
import org.apache.commons.lang.StringUtils;

public class RegSelfAppBaseOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(RegSelfAppBaseOp.class);
    private boolean isChangeStatus = false;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bemployee");
        fieldKeys.add("bposition");
        fieldKeys.add("bjob");
        fieldKeys.add("regbilltype");
        fieldKeys.add("person");
        fieldKeys.add("effectdate");
        fieldKeys.add("preregdate");
        fieldKeys.add("org");
        fieldKeys.add("modifytime");
        fieldKeys.add("syncstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("probationremark");
        fieldKeys.add("postponeaskresult");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] regBillObjects = e.getDataEntities();
        DynamicObject bill = regBillObjects[0];
        try {
            this.setErmanFile(bill);
            String operationKey = e.getOperationKey();
            PostponeAskResultUpdateSourceEnum postponeAskResultUpdateSourceEnum = null;
            ProbationRemarkUpdateSourceEnum probationRemarkUpdateSourceEnum = null;
            if ("selfsubmit".equals(operationKey)) {
                IRegBillService.getInstance().beforeBeginTransactionValidateProcessIn(bill);
                this.setBillSubmitOperate(bill);
                IRegBillService.getInstance().executeSubmit(regBillObjects);
                postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.PERSONNEL_SUBMIT_BILL;
                probationRemarkUpdateSourceEnum = ProbationRemarkUpdateSourceEnum.PERSONNEL_SAVE_BILL;
            }
            if ("save_mobile".equals(operationKey) || "save_self_pc".equals(operationKey)) {
                IRegBillService.getInstance().beforeBeginTransactionValidateProcessIn(bill);
                this.setBillSaveOperate(bill);
                this.isChangeStatus = this.updateProgress(bill);
                postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.PERSONNEL_SAVE_BILL;
                probationRemarkUpdateSourceEnum = ProbationRemarkUpdateSourceEnum.PERSONNEL_SAVE_BILL;
            }
            IRegProbationService.getInstance().setPostponeAskResult(regBillObjects, postponeAskResultUpdateSourceEnum);
            IRegProbationService.getInstance().setProbationRemark(regBillObjects, probationRemarkUpdateSourceEnum);
        }
        catch (Exception ex) {
            LOGGER.error("selfRegApply beginOperationTransaction exception:", (Throwable)ex);
            IRegBillService.getInstance().releaseDLock(bill);
            throw new KDBizException(ex.getMessage());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] billObjs = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if ("selfsubmit".equals(operationKey)) {
            IRegBillService.getInstance().releaseDLock(billObjs[0]);
            IRegEffectService.getInstance().updateReg(billObjs);
            IPersonAboutService.getInstance().doUpdatePersonCrossData(billObjs, "1010");
        }
        if ("save_mobile".equals(operationKey) || "save_self_pc".equals(operationKey)) {
            IRegBillService.getInstance().releaseDLock(billObjs[0]);
            if (this.isChangeStatus) {
                IRegEffectService.getInstance().updateReg(billObjs);
            }
        }
    }

    private void setBillSubmitOperate(DynamicObject regBill) {
        long creatorId = regBill.getLong("creator_id");
        if (creatorId == 0L) {
            regBill.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            regBill.set("createtime", (Object)new Date());
        }
        regBill.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
        regBill.set("modifytime", (Object)new Date());
        regBill.set("submittime", (Object)new Date());
        regBill.set("billstatus", (Object)"B");
        regBill.set("auditstatus", (Object)"B");
        regBill.set("isexistsworkflow", (Object)Boolean.TRUE);
        this.buildRegCategory(regBill);
    }

    private void setBillSaveOperate(DynamicObject regBill) {
        this.buildRegCategory(regBill);
        regBill.set("modifytime", (Object)new Date());
        regBill.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
        String billStatus = regBill.getString("billstatus");
        if ("G".equals(billStatus)) {
            return;
        }
        regBill.set("billstatus", (Object)"A");
        regBill.set("auditstatus", (Object)"A");
        regBill.set("regstatus", (Object)"1010");
        regBill.set("syncstatus", (Object)"-2");
        regBill.set("createtime", (Object)new Date());
        regBill.set("creator_id", (Object)RequestContext.get().getCurrUserId());
    }

    private boolean updateProgress(DynamicObject bill) {
        boolean isChangeStatus = false;
        Long employee = bill.getLong("bemployee_id");
        QFilter filter = new QFilter("bemployee", "=", (Object)employee);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hdm_regprocess");
        DynamicObject processObject = helper.queryOne("regstatus,modifytime,modifier_id", new QFilter[]{filter});
        if (Objects.isNull(processObject)) {
            processObject = helper.generateEmptyDynamicObject();
            processObject.set("person", (Object)bill.getLong("person_id"));
            processObject.set("bemployee", (Object)employee);
            isChangeStatus = true;
        } else {
            String regStatus = processObject.getString("regstatus");
            if (!StringUtils.equals((String)regStatus, (String)"1010")) {
                isChangeStatus = true;
            }
        }
        if (isChangeStatus) {
            processObject.set("regstatus", (Object)"1010");
            processObject.set("modifytime", (Object)new Date());
            processObject.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
            helper.updateOne(processObject);
        }
        return isChangeStatus;
    }

    private void buildRegCategory(DynamicObject bill) {
        Date effectDate = bill.getDate("effectdate");
        if (effectDate == null) {
            return;
        }
        Date pre = bill.getDate("preactualdate");
        if (effectDate.before(pre)) {
            bill.set("regcategory_id", (Object)RegCategoryEnum.INADVANCE.getId());
        } else if (effectDate.equals(pre)) {
            bill.set("regcategory_id", (Object)RegCategoryEnum.NOMAL.getId());
        }
    }

    private void setErmanFile(DynamicObject bill) {
        long personId = bill.getLong("person_id");
        DynamicObject ermanFile = HRServiceUtil.getPrimaryErmanFile((Long)personId);
        if (ermanFile != null) {
            bill.set("ermanfile", (Object)ermanFile);
            bill.set("org", (Object)ermanFile.getDynamicObject("org"));
            bill.set("bhrbu", (Object)ermanFile.getDynamicObject("org"));
            bill.set("bempgroup", (Object)ermanFile.getDynamicObject("empgroup"));
            bill.set("baffiliateadminorg", (Object)ermanFile.getDynamicObject("affiliateadminorg"));
            bill.set("bdependency", (Object)ermanFile.getDynamicObject("dependency"));
            bill.set("bdependencytype", (Object)ermanFile.getDynamicObject("dependencytype"));
            bill.set("cmpemp", ermanFile.getDynamicObject("cmpemp").get("managingscope"));
            DynamicObject empPosorgrel = ermanFile.getDynamicObject("empposrel");
            bill.set("badminorg", (Object)empPosorgrel.getDynamicObject("adminorg"));
            bill.set("bposition", (Object)empPosorgrel.getDynamicObject("position"));
            bill.set("standardpost", (Object)empPosorgrel.getDynamicObject("stdposition"));
            bill.set("bjob", (Object)empPosorgrel.getDynamicObject("job"));
        }
    }
}

