/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.mservice.api.IPartBillService;

public class PartBillService
implements IPartBillService {
    private static final Log LOGGER = LogFactory.getLog(PartBillService.class);
    private static final String SELECT_PROPERTIES = "apositiontype, aposition, astdposition,bjob,aadminorg";

    public Map<String, Object> queryPositionInfoById(Long billPKId) {
        LOGGER.info("queryPositionInfoByIds param:{}", (Object)billPKId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hdm_parttimeapplybill");
        DynamicObject partBill = serviceHelper.queryOne(SELECT_PROPERTIES, (Object)billPKId);
        if (ObjectUtils.isEmpty((Object)partBill)) {
            LOGGER.error("query partBill is null, bill id:{}", (Object)billPKId);
            return Collections.emptyMap();
        }
        return this.buildResponseByParttime(partBill);
    }

    public Map<String, Object> quitNotice(Map<String, Object> quitInfo) {
        return IParttimeBillService.getInstance().dealQuitMessage(quitInfo);
    }

    public List<Map<String, Object>> queryPositionInfoByIds(List<Long> billIds) {
        LOGGER.info("queryPositionInfoByIds param:{}", billIds);
        if (HRCollUtil.isEmpty(billIds)) {
            return new ArrayList<Map<String, Object>>();
        }
        QFilter idFilter = new QFilter("id", "in", billIds);
        DynamicObject[] parttimeBills = ParttimeApplyRepository.getInstance().query(SELECT_PROPERTIES, new QFilter[]{idFilter}, null);
        if (parttimeBills == null || parttimeBills.length < 1) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(billIds.size());
        for (DynamicObject partBill : parttimeBills) {
            Map<String, Object> map = this.buildResponseByParttime(partBill);
            result.add(map);
        }
        return result;
    }

    private Map<String, Object> buildResponseByParttime(DynamicObject partBill) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", partBill.get("id"));
        result.put("positiontype", partBill.get("apositiontype"));
        result.put("position", partBill.get("aposition"));
        result.put("stdposition", partBill.get("astdposition"));
        result.put("adminorg", partBill.get("aadminorg"));
        result.put("job", partBill.get("bjob"));
        return result;
    }
}

