/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.mservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.domain.secondment.repository.SecondmentBackRepository;
import kd.hr.hdm.mservice.api.ISecondmentBackBillService;

public class SecondmentBackBillServiceImpl
implements ISecondmentBackBillService {
    private static final Log LOGGER = LogFactory.getLog(SecondmentBackBillServiceImpl.class);

    public Map<String, Object> queryBillById(Long billId) {
        try {
            LOGGER.info("SecondmentBackBillServiceImpl query bill Id: {}", (Object)billId);
            DynamicObject secondmentBackBill = SecondmentBackRepository.getInstance().queryOne("billno,countryback,countryin,backdate,enddate,duration,reachdate,startdate,secbackreason,person", billId);
            if (secondmentBackBill != null) {
                Map<String, Object> result = this.buildMap(secondmentBackBill);
                LOGGER.info("SecondmentBackBillServiceImpl query result {}", (Object)result.toString());
                return result;
            }
            LOGGER.info("SecondmentBackBill is null");
            return null;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            return null;
        }
    }

    private Map<String, Object> buildMap(DynamicObject secondmentBackBill) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("billno", secondmentBackBill.getString("billno"));
        result.put("countryback", secondmentBackBill.getLong("countryback.id"));
        result.put("countryin", secondmentBackBill.getLong("countryin.id"));
        result.put("backdate", secondmentBackBill.getDate("backdate"));
        result.put("enddate", secondmentBackBill.getDate("enddate"));
        result.put("duration", secondmentBackBill.getInt("duration"));
        result.put("reachdate", secondmentBackBill.getDate("reachdate"));
        result.put("startdate", secondmentBackBill.getDate("startdate"));
        result.put("secbackreason", secondmentBackBill.getLong("secbackreason.id"));
        result.put("person", secondmentBackBill.getLong("person.id"));
        return result;
    }
}

