/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.mservice.api.ITransferQuery;

public class TransferQueryImpl
implements ITransferQuery {
    private static final String SUCCESS = "200";
    private static final String FAIL = "201";
    public static final String SELECT_FIELDS = "id,arealityorg,arealityposition,arealitystposition,realitydate,transferclassify,transferreason,postpattern,arealityjob,appdispatchnum,appremoverel";

    public Map<String, Object> getTranserBillById(long id) {
        DynamicObject dynamicObject = ITransferBillService.getInstance().queryOne(SELECT_FIELDS, id);
        return this.buildDataMap(dynamicObject);
    }

    public Map<String, Object> listTranserBillById(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] query = ITransferBillService.getInstance().query(SELECT_FIELDS, qFilter.toArray());
        String errorMsg = "";
        String code = SUCCESS;
        if (query.length == 0) {
            errorMsg = String.format(Locale.ROOT, "can't find any transferbill by ids %s", ids.toString());
            code = FAIL;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(ids.size());
        for (DynamicObject dynamicObject : query) {
            Map<String, Object> dataMap = this.buildDataMap(dynamicObject);
            list.add(dataMap);
        }
        result.put("data", list);
        result.put("code", code);
        result.put("errorMsg", errorMsg);
        return result;
    }

    private Map<String, Object> buildDataMap(DynamicObject dynamicObject) {
        HashMap<String, Object> result = new HashMap<String, Object>(12);
        if (Objects.nonNull(dynamicObject)) {
            long arealityorg = this.getId(dynamicObject.getDynamicObject("arealityorg"));
            long arealityposition = this.getId(dynamicObject.getDynamicObject("arealityposition"));
            long arealitystposition = this.getId(dynamicObject.getDynamicObject("arealitystposition"));
            long transferreason = this.getId(dynamicObject.getDynamicObject("transferreason"));
            Date realitydate = dynamicObject.getDate("realitydate");
            String postpattern = dynamicObject.getString("postpattern");
            long arealityjob = this.getId(dynamicObject.getDynamicObject("arealityjob"));
            result.put("arealityorg", arealityorg);
            result.put("appdispatchnum", dynamicObject.getString("appdispatchnum"));
            result.put("appremoverel", this.getId(dynamicObject.getDynamicObject("appremoverel")));
            result.put("arealityposition", arealityposition);
            result.put("arealitystposition", arealitystposition);
            result.put("realitydate", realitydate);
            result.put("transferreason", transferreason);
            result.put("postpattern", postpattern);
            result.put("arealityjob", arealityjob);
        }
        return result;
    }

    private Long getId(DynamicObject dy) {
        if (ObjectUtils.isEmpty((Object)dy)) {
            return 0L;
        }
        return dy.getLong("id");
    }
}

