/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.application.reg.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.application.reg.service.IRegBillServiceForQuit;
import kd.hr.hdm.business.mq.sender.RegMQHelper;
import kd.hr.hdm.business.reg.RegTraceServiceHelper;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.repository.database.RegProcessRepository;
import kd.hr.hdm.business.reg.domain.repository.database.RegTraceRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.common.reg.constants.TrialPeriodResultConstants;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.reg.enums.RegNewAuditStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class RegBillServiceForQuitImpl
implements IRegBillServiceForQuit {
    private static final Log LOGGER = LogFactory.getLog(RegBillServiceForQuitImpl.class);
    private static final String EMPLOYEE_ID = "employee_id";
    private static final String EMPLOYEE_IDS = "employee_ids";
    private static final String ALABORRELSTATUS_ID = "alaborrelstatus_id";
    private static final String DEPEMP_ID = "depemp_id";
    private static final String PERSON_ID = "person_id";
    private static final String ERMANFILE_ID = "ermanfile_id";
    private static final String SUCCESS = "success";
    private static final String MSG = "msg";
    private static final String CONTRACT_ENDDATE = "contractenddate";
    private static final String selectProperties = "id,billno,person,bemployee,ermanfile,regbilltype,regstatus,billstatus,auditstatus,laborrelstatus,affaction,effectdate,preactualdate,termuser,termdate,termreason,modifytime";

    @Override
    public Map<String, Object> executePersonQuit(Map<String, Object> personQuitMessage) {
        LOGGER.info("quit application invoke the service param:{}", personQuitMessage);
        Map<String, Object> responseMap = new HashMap<String, Object>();
        Object employeeId = personQuitMessage.get(EMPLOYEE_ID);
        Object labStatusId = personQuitMessage.get(ALABORRELSTATUS_ID);
        Object contractEndDate = personQuitMessage.get(CONTRACT_ENDDATE);
        Object depEmpId = personQuitMessage.get(DEPEMP_ID);
        Object personId = personQuitMessage.get(PERSON_ID);
        if (ObjectUtils.isEmpty((Object)employeeId) || ObjectUtils.isEmpty((Object)labStatusId) || ObjectUtils.isEmpty((Object)contractEndDate) || ObjectUtils.isEmpty((Object)depEmpId) || ObjectUtils.isEmpty((Object)personId)) {
            responseMap.put(SUCCESS, Boolean.FALSE);
            responseMap.put(MSG, "Key information missed,please check the input params of employee_id,alaborrelstatus_id,contractenddate,depemp_id,person_id");
            return responseMap;
        }
        DynamicObject regBill = this.queryBillObjByEmpId(employeeId);
        try {
            if (ObjectUtils.isEmpty((Object)regBill)) {
                return this.updateRegStatusWhenNoBill((Long)employeeId, (Long)personId);
            }
            responseMap = this.updateRegStatusWhenHaveBill(regBill, (Long)labStatusId, (Date)contractEndDate);
            if (((Boolean)responseMap.get(SUCCESS)).booleanValue()) {
                IRegEffectService.getInstance().updateReg(regBill);
            }
        }
        catch (Exception e) {
            responseMap.put(SUCCESS, Boolean.FALSE);
            responseMap.put(MSG, "execute occur error when update reg status for the person ... ");
            LOGGER.error("execute occur error when update reg status:", (Throwable)e);
        }
        return responseMap;
    }

    @Override
    public Map<String, Object> executePersonQuitRevoke(Map<String, Object> personQuitRevokeMessage) {
        LOGGER.info("quit revoke operate invoke the service param:{}", personQuitRevokeMessage);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        Object employeeIds = personQuitRevokeMessage.get(EMPLOYEE_IDS);
        if (ObjectUtils.isEmpty((Object)employeeIds)) {
            responseMap.put(SUCCESS, Boolean.FALSE);
            responseMap.put(MSG, "Key information missed,please check the input params of employee_ids");
            return responseMap;
        }
        List employeeIdList = (List)employeeIds;
        DynamicObject[] dys = HDMRegBaseBillRepository.getInstance().query(selectProperties, new QFilter[]{new QFilter("bemployee", "in", (Object)employeeIdList)}, "modifytime desc");
        try {
            if (dys == null || dys.length < 1) {
                this.quitRevokeWhenNoBill(employeeIdList);
            } else {
                Map<Long, DynamicObject> regBillMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("bemployee.id"), dy -> dy, (o, n) -> o));
                ArrayList<Long> noBillEmployeeIds = new ArrayList<Long>();
                ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>();
                for (Long employeeId : employeeIdList) {
                    DynamicObject regBill = regBillMap.get(employeeId);
                    if (regBill == null) {
                        noBillEmployeeIds.add(employeeId);
                        continue;
                    }
                    String billStatus = regBill.getString("billstatus");
                    String regStatus = regBill.getString("regstatus");
                    String auditStatus = regBill.getString("auditstatus");
                    if (RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus) && RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus) || RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus) && RegNewAuditStatusEnum.CHECKED.getCode().equals(auditStatus) && RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus) || !RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) continue;
                    regBill.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
                    updateBills.add(regBill);
                }
                if (noBillEmployeeIds.size() > 0) {
                    this.quitRevokeWhenNoBill(noBillEmployeeIds);
                }
                if (updateBills.size() > 0) {
                    this.quitRevokeWhenHaveBill(updateBills);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("executePersonQuitRevoke error:", (Throwable)e);
            responseMap.put(SUCCESS, Boolean.FALSE);
            responseMap.put(MSG, "executePersonQuitRevoke error");
            return responseMap;
        }
        responseMap.put(SUCCESS, Boolean.TRUE);
        return responseMap;
    }

    private void quitRevokeWhenHaveBill(List<DynamicObject> updateBills) {
        IRegBillService.getInstance().update(updateBills.toArray(new DynamicObject[0]));
        List<Long> employeeIds = updateBills.stream().map(bill -> bill.getLong("bemployee.id")).collect(Collectors.toList());
        this.updateRegProcessByQuitRevoke(employeeIds);
    }

    private void quitRevokeWhenNoBill(List<Long> employeeIds) {
        this.updateRegProcessByQuitRevoke(employeeIds);
    }

    private void updateRegProcessByQuitRevoke(List<Long> employeeIds) {
        DynamicObject[] regProcessArr = RegProcessRepository.getInstance().query("bemployee,regstatus,trialperiodrst", new QFilter[]{new QFilter("bemployee", "in", employeeIds)});
        if (regProcessArr == null || regProcessArr.length < 1) {
            return;
        }
        Arrays.stream(regProcessArr).forEach(regProcess -> {
            regProcess.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
            regProcess.set("trialperiodrst", null);
        });
        RegProcessRepository.getInstance().update(regProcessArr);
        QFilter employeeFilter = new QFilter("bemployee", "in", employeeIds);
        employeeFilter.and(new QFilter("type", "=", (Object)"2010"));
        RegTraceRepository.getInstance().deleteByFilter(new QFilter[]{employeeFilter});
        this.syncPersonGenericData(employeeIds);
    }

    private void syncPersonGenericData(List<Long> employeeIds) {
        Object[] trialPeriodRsts;
        Object[] trialPeriods = IPersonAboutService.getInstance().queryTrialPeriodByEmployeeId(employeeIds);
        if (trialPeriods != null && trialPeriods.length > 0) {
            Arrays.stream(trialPeriods).forEach(trialPeriod -> {
                trialPeriod.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
                trialPeriod.set("trialperiodrst", null);
                trialPeriod.set("number", null);
            });
            IPersonAboutService.getInstance().reviseVersionBatch(Lists.newArrayList((Object[])trialPeriods));
        }
        if ((trialPeriodRsts = IPersonAboutService.getInstance().queryTrialPeriodRstByEmployeeId(employeeIds)) != null && trialPeriodRsts.length > 0) {
            Arrays.stream(trialPeriodRsts).forEach(trialPeriodRst -> trialPeriodRst.set("probationrst", null));
            IPersonAboutService.getInstance().reviseVersionBatch(Lists.newArrayList((Object[])trialPeriodRsts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> updateRegStatusWhenNoBill(long employeeId, long personId) {
        Map ermanFileIdMap = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanFileIdByEmployeeId", (Object[])new Object[]{Collections.singletonList(employeeId), true});
        if (ermanFileIdMap == null || ermanFileIdMap.size() < 1) {
            throw new KDBizException("query empty result through invoke 'getErmanFileIdByEmployeeId' by employeeId " + employeeId);
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try (TXHandle txHandle = TX.requiresNew();){
            List mapList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{Collections.singletonList(employeeId), "isprobation", "hrpi_empentrel"});
            if (CollectionUtils.isEmpty((Collection)mapList)) {
                throw new KDBizException("query empty result through invoke 'listBatchPropEmployeeAttachs' by empId " + employeeId);
            }
            boolean haveProbation = (Boolean)((Map)mapList.get(0)).get("isprobation");
            LOGGER.info("is haveProbation " + haveProbation);
            if (haveProbation) {
                List trialPeriodList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_trialperiod"});
                if (CollectionUtils.isEmpty((Collection)trialPeriodList)) {
                    throw new KDBizException("query trialPeriod empty result through invoke 'listBatchPropEmployeeAttachs' by empId " + employeeId);
                }
                String regStatus = String.valueOf(((Map)trialPeriodList.get(0)).get("regstatus"));
                if (!"1040".equals(regStatus) && !"1050".equals(regStatus)) {
                    DynamicObject process = RegProcessRepository.getInstance().queryOne("bemployee,person,regstatus,trialperiodrst", new QFilter[]{new QFilter("bemployee", "=", (Object)employeeId)});
                    if (ObjectUtils.isEmpty((Object)process)) {
                        process = RegProcessRepository.getInstance().generateEmptyDynamicObject();
                        process.set("person", (Object)personId);
                        process.set("bemployee", (Object)employeeId);
                    }
                    process.set("regstatus", (Object)RegBusinessStatusEnum.REJECT_REG.getCode());
                    process.set("trialperiodrst", (Object)TrialPeriodResultConstants.REG_NOT_PASS);
                    RegProcessRepository.getInstance().saveOne(process);
                    this.syncRegTrace(employeeId, personId);
                    responseMap.put(SUCCESS, Boolean.TRUE);
                    responseMap.put(MSG, "There is no data need to be execute ... ");
                }
            }
        }
        if (responseMap.get(SUCCESS) != null && ((Boolean)responseMap.get(SUCCESS)).booleanValue()) {
            RegMQHelper.getInstance().syncProcessStatus((Long)ermanFileIdMap.get(employeeId), true, false);
        }
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> updateRegStatusWhenHaveBill(DynamicObject regBill, long labStatusId, Date contractEndDate) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put(SUCCESS, Boolean.TRUE);
        responseMap.put(MSG, " ");
        try (TXHandle txHandle = TX.requiresNew();){
            String billStatus = regBill.getString("billstatus");
            String regStatus = regBill.getString("regstatus");
            if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus) || RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) {
                HashMap<String, Object> hashMap = responseMap;
                return hashMap;
            }
            if (RegBillStatusEnum.APPROVEREJECTED.getCode().equals(billStatus) || RegBillStatusEnum.ABANDONED.getCode().equals(billStatus)) {
                IRegBillService.getInstance().syncRegProcess(regBill, RegBusinessStatusEnum.REJECT_REG.getCode());
                HashMap<String, Object> hashMap = responseMap;
                return hashMap;
            }
            regBill.set("laborrelstatus", (Object)labStatusId);
            regBill.set("auditstatus", (Object)RegNewAuditStatusEnum.ABANDONED.getCode());
            regBill.set("regstatus", (Object)RegBusinessStatusEnum.REJECT_REG.getCode());
            if (!RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus) || !RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(regStatus)) {
                regBill.set("billstatus", (Object)RegBillStatusEnum.ABANDONED.getCode());
            }
            if (RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.APPROVING.getCode().equals(billStatus) || RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(regStatus)) {
                IPersonAboutService.getInstance().doUpdatePersonCrossData(regBill, "1040");
                IRegBillService.getInstance().terminateWorkFlow(regBill);
            }
            if (RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) {
                IRegBillService.getInstance().terminateWorkFlow(regBill);
            }
            regBill.set("termuser", (Object)1L);
            String dataString = DateUtils.formatDate((Date)contractEndDate, (Object[])new Object[]{"yyyy-MM-dd"});
            IRegBillService.getInstance().fillTerminateInfo(regBill, dataString);
            IRegBillService.getInstance().syncRegProcess(regBill, RegBusinessStatusEnum.REJECT_REG.getCode());
            IRegBillService.getInstance().syncRegTrace(Collections.singletonList(regBill), "1080", 1L);
            IRegBillService.getInstance().update(regBill);
        }
        return responseMap;
    }

    private void syncRegTrace(Long employeeId, Long personId) {
        List<Long> empIds = Collections.singletonList(employeeId);
        List<Long> personIds = Collections.singletonList(personId);
        RegTraceServiceHelper.logBatchRegular(empIds, personIds, 1L, "2010");
    }

    private DynamicObject queryBillObjByEmpId(Object empId) {
        QFilter filter = new QFilter("bemployee", "=", empId);
        String orderBy = "modifytime desc";
        return HDMRegBaseBillRepository.getInstance().queryOne(selectProperties, new QFilter[]{filter}, orderBy);
    }
}

