/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.application.transfer.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.mq.sender.TransferStaffSend;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferApproveStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;
import kd.hr.hpfs.business.domain.repository.config.DevParamConfigRepository;
import org.apache.commons.lang3.ArrayUtils;

public class TransferBillApplicationService
implements ITransferBillApplicationService {
    private static final Log LOGGER = LogFactory.getLog(TransferBillApplicationService.class);
    private static final String PARAM_EMPLOYEEID = "employee_id";
    private static final String RESULT_SUCCESS = "success";
    private static final String RESULT_MESSAGE = "msg";
    private static final Long TERMINATEREASON_QUIT_ID = 1070L;
    private static final List<String> ONTHEWAYSTATUS = Arrays.asList("0", "1", "4");
    private static final String SELECT_FIELDS = "id,billno,billstatus,auditstatus,transferoutstatus,transferinstatus,transferstatus,bemployee,terminationreason,terminationtime,terminationdesc";

    @Override
    public Map<String, Object> dealPersonQuit(Map<String, Object> quitInfo) {
        LOGGER.info("Transfer dealPersonQuit begin, the request param is :[{}]", quitInfo);
        if (!this.validateRequestParam(quitInfo)) {
            return this.buildResult(Boolean.FALSE, "Transfer dealPersonQuit request param error");
        }
        DynamicObject[] transferBills = this.listOnTheWayTransferBillsByEmployeeId((Long)quitInfo.get(PARAM_EMPLOYEEID));
        try (TXHandle tx = TX.requiresNew();){
            this.discardTransferBills(transferBills);
        }
        LOGGER.info("Transfer dealPersonQuit end", quitInfo);
        return this.buildResult(Boolean.TRUE, "");
    }

    @Override
    public void discardTransferBills(List<Long> transferBillIds) {
        LOGGER.info("TransferBillApplicationService >> discardTransferBill, the transferBillIds is [{}] ", transferBillIds);
        if (ObjectUtils.isEmpty(transferBillIds)) {
            LOGGER.warn("TransferBillApplicationService >> discardTransferBill, the transferBillIds is empty");
        }
        DynamicObject[] transferBills = this.listOnTheWayTransferBillsByTransferBillIds(transferBillIds);
        this.discardTransferBills(transferBills);
    }

    private void discardTransferBills(DynamicObject[] transferBills) {
        if (!ObjectUtils.isEmpty((Object)transferBills)) {
            Arrays.asList(transferBills).forEach(this::discard);
            TransferStaffSend.sendStaffTerminalMsg(Arrays.asList(transferBills));
            TransferBillRepository.getInstance().batchUpdate(Arrays.asList(transferBills));
        } else {
            LOGGER.warn("TransferBillApplicationService#discardTransferBills >> the transfefrBills is empty");
        }
    }

    private DynamicObject[] listOnTheWayTransferBillsByEmployeeId(Long employeeId) {
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        QFilter auditStatusFilter = new QFilter("transferstatus", "in", ONTHEWAYSTATUS);
        return TransferBillRepository.getInstance().query(TransferPageHelperUtil.QUERYFIELD, new QFilter[]{employeeFilter, auditStatusFilter});
    }

    private DynamicObject[] listOnTheWayTransferBillsByTransferBillIds(List<Long> transferBillIds) {
        QFilter idsFilter = new QFilter("id", "in", transferBillIds);
        QFilter auditStatusFilter = new QFilter("transferstatus", "in", ONTHEWAYSTATUS);
        return TransferBillRepository.getInstance().query(SELECT_FIELDS, new QFilter[]{idsFilter, auditStatusFilter});
    }

    private void discard(DynamicObject transferBill) {
        String transferStatus = transferBill.getString("transferstatus");
        LOGGER.info("Transfer dealQuit begin: the billId is : [{}], the transferStatus is : [{}]", (Object)transferBill.getString("id"), (Object)transferStatus);
        this.updateTransferBill2Discard(transferBill);
        switch (transferStatus) {
            case "1": {
                this.terminateWorkFlow(transferBill);
            }
            case "4": {
                ITransferPersonChangeService.getInstance().excutePersonChangeNotice(transferBill, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO);
                break;
            }
        }
    }

    private void terminateWorkFlow(DynamicObject transferBill) {
        String transferBillId = transferBill.getString("id");
        Long instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)transferBillId);
        if (!Objects.isNull(instanceId) && !instanceId.equals(0L)) {
            try {
                LOGGER.info("Transfer terminate work flow , billId is :[{}], instanceid : [{}]", (Object)transferBillId, (Object)instanceId);
                try (TXHandle txHandle = TX.notSupported();){
                    IHSSCService.getInstance().terminateSSCTask(transferBill);
                    WorkflowServiceHelper.abandon((Long)instanceId);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
        }
    }

    private Map<String, Object> buildRecordParam(String billId, Long instanceId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("billId", billId);
        map.put("instanceId", instanceId);
        return map;
    }

    private void updateTransferBill2Discard(DynamicObject transferBill) {
        transferBill.set("terminationreason", (Object)TERMINATEREASON_QUIT_ID);
        transferBill.set("terminationdesc", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u7ec8\u6b62", (String)"TransferBillApplicationService_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        transferBill.set("terminationtime", (Object)new Date());
        transferBill.set("auditstatus", (Object)"F");
        transferBill.set("billstatus", (Object)"F");
        transferBill.set("transferstatus", (Object)"3");
        transferBill.set("transferinstatus", (Object)TransferApproveStatusEnum.transferInDiscard.getApproveStatus());
        transferBill.set("transferoutstatus", (Object)TransferApproveStatusEnum.transferOutDiscard.getApproveStatus());
    }

    private boolean validateRequestParam(Map<String, Object> quitInfo) {
        return !ObjectUtils.isEmpty(quitInfo) && !ObjectUtils.isEmpty((Object)quitInfo.get(PARAM_EMPLOYEEID));
    }

    private Map<String, Object> buildResult(Boolean isSuccess, String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(RESULT_SUCCESS, isSuccess);
        result.put(RESULT_MESSAGE, msg);
        return result;
    }

    @Override
    public DynamicObject getAppointRemoveRelObj(String appDispatchNum, long employeeId) {
        Object[] appRemoveRelArr = this.queryAppointRemoveRel(appDispatchNum, employeeId);
        if (ArrayUtils.isEmpty((Object[])appRemoveRelArr) || appRemoveRelArr.length > 1) {
            LOGGER.info("TransferBillApplicationService.getAppointRemoveRelObj appRemoveRelArr not match");
            return null;
        }
        return appRemoveRelArr[0];
    }

    public DynamicObject[] queryAppointRemoveRel(String appDispatchNum, Long employeeId) {
        LOGGER.info("###TransferBillApplicationService.queryAppointRemovErels param employeeId:{},appdispatchnum:{}", (Object)employeeId, (Object)appDispatchNum);
        String selectFields = "company,adminorgvid,positionvid,jobvid,stdpositionvid,apositiontype";
        QFilter qFilters = new QFilter("employee", "=", (Object)employeeId).and(new QFilter("appointdispatchnymber", "=", (Object)appDispatchNum)).and(new QFilter("appointtypestatus", "=", (Object)"1")).and(new QFilter("empposrel", "=", (Object)0)).and(new QFilter("businessstatus", "=", (Object)"1"));
        String entityName = "hrpi_appointremoverel";
        DynamicObject[] appointRemovErels = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectFields, qFilters, entityName});
        LOGGER.info("###TransferBillApplicationService.queryAppointRemovErels result appointRemovErels length is :{}", (Object)appointRemovErels.length);
        return appointRemovErels;
    }

    @Override
    public boolean needConfirmAppointmentWritten() {
        DynamicObject paramConfig = DevParamConfigRepository.queryConfigByBusinessKey((String)"confirm_appointment_written");
        return paramConfig.getBoolean("businessvalue");
    }
}

