/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.handler.TransferHPFSTemplatePropertyHandler;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.bean.PersonBean;
import kd.sdk.hr.hpfs.business.config.repository.DevParamConfigRepository;
import kd.sdk.hr.hpfs.business.service.impl.PerSaveSuccessService;
import kd.sdk.hr.hpfs.utils.HpfsSetSysAndEnddateUtils;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;

public abstract class HPFSTemplatePropertyHandler {
    protected static final Log LOGGER = LogFactory.getLog(HPFSTemplatePropertyHandler.class);
    protected static final Date MAX_DATE = DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD);
    private static final int CORE_THREAD = Runtime.getRuntime().availableProcessors();
    private static final int MAX_THREAD = CORE_THREAD * 5;
    private static final String APPID_HR = "hr";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"HPFSTemplatePropertyHandler-Thread", (int)CORE_THREAD, (int)MAX_THREAD, (String)"hr");

    public void saveHPFSEffectMessage(DynamicObject[] bills) {
        DynamicObject[] dys = this.resetBills(bills);
        LOGGER.info("start HPFSTemplatePropertyHandler");
        Arrays.stream(dys).forEach(bill -> {
            try {
                this.setPreProperty((DynamicObject)bill);
                PerChgNewBillUtils.setEntryAndBillFields((DynamicObject)bill);
                this.setBillProperty((DynamicObject)bill);
                PerChgNewBillUtils.setEntryFields((DynamicObject)bill);
            }
            catch (Exception exception) {
                LOGGER.error("saveHPFSEffectMessage error billid is {} , error:", (Object)bill.getString("id"), (Object)exception);
            }
        });
        this.saveEntryFields(dys);
        List<PerChgBizInfoNew> perChgBizInfoNews = this.buildPersonParams(dys);
        this.saveBatchPersonAttach(perChgBizInfoNews);
    }

    public void saveHPFSEffectMessageAsync(DynamicObject[] bills) {
        String traceId = RequestContext.get().getTraceId();
        THREAD_POOL.execute(() -> {
            LOGGER.info("saveHPFSEffectMessageAsync execute start, traceid is {}", (Object)traceId);
            this.saveHPFSEffectMessage(bills);
            LOGGER.info("saveHPFSEffectMessageAsync execute end, traceid is {}", (Object)traceId);
        });
    }

    protected DynamicObject[] resetBills(DynamicObject[] bills) {
        return bills;
    }

    public abstract void setPreProperty(DynamicObject var1);

    protected void saveBatchPersonAttach(List<PerChgBizInfoNew> perChgBizInfoNews) {
        HpfsSetSysAndEnddateUtils.setSysDateAndEnddate(perChgBizInfoNews);
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            boolean success = false;
            try (TXHandle txHandle = TX.requiresNew();){
                Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{perChgBizInfoNew.getPersonParams()});
                LOGGER.info("saveBatchPersonAttach result:{}", (Object)result);
                Map delPersonParams = perChgBizInfoNew.getDelPersonParams();
                if (delPersonParams != null && delPersonParams.size() > 0) {
                    Object deleteBatchResult = HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonGenericService", (String)"deleteBatch", (Object[])new Object[]{delPersonParams});
                    LOGGER.info("deleteBatchResult:{}", deleteBatchResult);
                }
                if (success = ((Boolean)result.get("success")).booleanValue()) {
                    this.setChargePerson((PerChgBizInfoNew)perChgBizInfoNew);
                }
                new PerSaveSuccessService().doIfPerSaveSuccessOperate(perChgBizInfoNew, result);
            }
            try {
                this.updateByAcffactionResult((PerChgBizInfoNew)perChgBizInfoNew, success);
            }
            catch (Exception e) {
                LOGGER.error("updateByAffactionResult error, billid is:{}", (Object)perChgBizInfoNew.getBillId(), (Object)e);
            }
        });
    }

    private void setChargePerson(PerChgBizInfoNew perChgBizInfoNew) {
        Boolean flag = this.isCancelChargeInfAndUpdateDepForCharge(perChgBizInfoNew);
        LOGGER.info("HPFSTemplatePropertyHandler#setChargePerson.flag={}", (Object)flag);
        if (flag.booleanValue()) {
            return;
        }
        new PersonParamsBuilder().setChargePersonByPerChgNew(perChgBizInfoNew);
    }

    protected void updateByAcffactionResult(PerChgBizInfoNew perChgBizInfoNew, boolean affectionRecordResult) {
    }

    private Boolean isCancelChargeInfAndUpdateDepForCharge(PerChgBizInfoNew perChgBizInfoNew) {
        try {
            if (this instanceof TransferHPFSTemplatePropertyHandler) {
                Long orgId = perChgBizInfoNew.getDy().getLong("borg.id");
                Date now = new Date();
                Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargePersonByOrgId", (Object[])new Object[]{Collections.singletonList(orgId), now});
                LOGGER.info("saveBatchPersonAttach result:{}", (Object)result);
                Long aOrgId = perChgBizInfoNew.getDy().getLong("aorg.id");
                Long bOrgId = perChgBizInfoNew.getDy().getLong("borg.id");
                LOGGER.info("HPFSTemplatePropertyHandler#isCancelChargeInf.aOrgId={}, bOrgId={}", (Object)bOrgId);
                Long personId = ((PersonBean)perChgBizInfoNew.getPersonList().get(0)).getaPersonId();
                LOGGER.info("HPFSTemplatePropertyHandler#isCancelChargeInf.personId={}", (Object)personId);
                List chargeList = (List)result.get(bOrgId);
                Long bDepempId = perChgBizInfoNew.getDy().getLong("bb_d_tid");
                if (Objects.isNull(bDepempId) || 0L == bDepempId) {
                    LOGGER.info("HPFSTemplatePropertyHandler#isCancelChargeInf.dont get bDepempId");
                    return false;
                }
                Long changeType = 1040L;
                Long finalBDepempId = bDepempId;
                List chargeInfoList = chargeList.stream().filter(map -> personId.equals((Long)map.get("person"))).filter(map -> changeType.equals((Long)map.get("changesource.id"))).filter(map -> finalBDepempId.equals((Long)map.get("depemp"))).filter(map -> HRStringUtils.equals((String)"1", (String)((String)map.get("datastatus")))).collect(Collectors.toList());
                boolean updateFlag = aOrgId.equals(bOrgId) && chargeInfoList.size() > 0;
                LOGGER.info("HPFSTemplatePropertyHandler#isCancelChargeInf.updateFlag={}", (Object)updateFlag);
                if (updateFlag) {
                    for (int i = 0; i < chargeInfoList.size(); ++i) {
                        new PersonParamsBuilder().updateDepEmpIdByPerChgNew(perChgBizInfoNew, (Long)((Map)chargeInfoList.get(i)).get("id"));
                    }
                }
                return updateFlag;
            }
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("HPFSTemplatePropertyHandler#isCancelChargeInf error!", (Throwable)ex);
            return false;
        }
    }

    private List<PerChgBizInfoNew> buildPersonParams(DynamicObject[] bills) {
        List<PerChgBizInfoNew> perChgBizInfoNews = this.personParamsBuilder(bills);
        this.buildCustomPersonParams(perChgBizInfoNews, bills);
        return perChgBizInfoNews;
    }

    private List<PerChgBizInfoNew> personParamsBuilder(DynamicObject[] bills) {
        PersonParamsBuilder builder = new PersonParamsBuilder();
        ArrayList<PerChgBizInfoNew> allPerList = new ArrayList<PerChgBizInfoNew>();
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = new PerChgBizInfoNew();
            perChgBizInfoNew.setBillId(Long.valueOf(bill.getLong("id")));
            perChgBizInfoNew.setBillNo(bill.getString("billno"));
            perChgBizInfoNew.setBillSource(bill.getDataEntityType().getName());
            perChgBizInfoNew.setChgActionId(Long.valueOf(bill.getLong("affaction.id")));
            this.prePersonParamsBuilder(perChgBizInfoNew, (DynamicObject)bill);
            allPerList.add(perChgBizInfoNew);
        });
        builder.validParamsAndBuildParams(allPerList);
        return allPerList;
    }

    protected void prePersonParamsBuilder(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
    }

    public abstract void saveEntryFields(DynamicObject[] var1);

    public abstract void setBillProperty(DynamicObject var1);

    public abstract void buildCustomPersonParams(List<PerChgBizInfoNew> var1, DynamicObject[] var2);

    public static boolean isNewChgAction(String devConfigKey) {
        DynamicObject dynamicObject = DevParamConfigRepository.queryConfigByBusinessKey((String)devConfigKey);
        boolean isNewChgAction = false;
        if (dynamicObject != null) {
            isNewChgAction = dynamicObject.getBoolean("businessvalue");
        }
        return isNewChgAction;
    }
}

