/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.common;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.redis.RedisSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.common.transfer.enums.TransferAppIdEnum;

public class PermissionValidateUtil {
    private static final Log LOGGER = LogFactory.getLog(PermissionValidateUtil.class);
    private static final RedisSessionlessCache sessionCache = new RedisSessionlessCache(null);

    public static boolean checkPermission(String appId, String entityNum, String permItemId) {
        long currUserId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static String getPermissionAppId(IFormView view) {
        String appId = view == null ? null : view.getFormShowParameter().getAppId();
        appId = HRStringUtils.isEmpty((String)appId) ? TransferAppIdEnum.hdm.appId : appId;
        LOGGER.info("PermissionValidateUtil.getPermissionAppId , appId:{}", (Object)appId);
        return appId;
    }

    public static void setAppId(String appId) {
        sessionCache.put(PermissionValidateUtil.getKey(), appId, 8, TimeUnit.HOURS);
    }

    public static String getAppId() {
        String appId = sessionCache.get(PermissionValidateUtil.getKey());
        return HRStringUtils.isEmpty((String)appId) ? TransferAppIdEnum.hdm.appId : appId;
    }

    private static String getKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getTenantId());
        sb.append("hr");
        sb.append(TransferAppIdEnum.hdm.appId);
        sb.append(RequestContext.get().getTraceId());
        return sb.toString();
    }
}

