/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.common;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;

public class VirtualOrgValidateUtil {
    private static final String IS_VIRTUAL_ORG = "isvirtualorg";

    public static Map<Long, Boolean> validate(List<Long> orgIdList) {
        Map<String, Map<String, Object>> adminOrgMap = AdminOrgExternalService.getInstance().invokeAdminOrgInfoQuery(orgIdList);
        if (adminOrgMap == null || adminOrgMap.size() < 1) {
            return new HashMap<Long, Boolean>();
        }
        HashMap virtualOrgMap = Maps.newHashMapWithExpectedSize((int)orgIdList.size());
        orgIdList.forEach(orgId -> {
            Map orgInfoMap = (Map)adminOrgMap.get(String.valueOf(orgId));
            if (orgInfoMap != null && HRStringUtils.equals((String)(orgInfoMap.get(IS_VIRTUAL_ORG) + ""), (String)"true")) {
                virtualOrgMap.put(orgId, true);
            } else {
                virtualOrgMap.put(orgId, false);
            }
        });
        return virtualOrgMap;
    }
}

