/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.common.batch;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hdm.business.common.batch.EntryImportDataBuilder;
import kd.hr.hdm.business.common.batch.EntryImportValidateService;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.common.util.HdmAppConfigUtil;

public abstract class EntryImportController {
    private static final Log LOGGER = LogFactory.getLog(EntryImportController.class);
    private static final ThreadPool THREADPOOL = ThreadPools.newFixedThreadPool((String)"BatchImportServiceImplThreadPool", (int)4);
    private static final int MAX_INVOKE_NUM = 499;
    public static final AtomicInteger I = new AtomicInteger(0);

    public List<EntryImportWrapper> importEntry(List<JSONObject> sourceImportData) {
        List<EntryImportWrapper> entryImportWrappers = this.genEntryImportWrapper(sourceImportData);
        try {
            this.executeEntryImportLogic(entryImportWrappers);
        }
        catch (Exception exception) {
            LOGGER.error("EntryImportController importEntry error:", (Throwable)exception);
        }
        return entryImportWrappers;
    }

    private List<EntryImportWrapper> genEntryImportWrapper(List<JSONObject> sourceImportData) {
        boolean evaluationJobIsCtr = HdmAppConfigUtil.getEvaluationJobIsCtr();
        return sourceImportData.stream().map(temp -> new EntryImportWrapper((JSONObject)temp, new ValidateContext()).setEvaluationJobIsCtr(evaluationJobIsCtr)).collect(Collectors.toList());
    }

    private void executeEntryImportLogic(List<EntryImportWrapper> importWrappers) {
        if (importWrappers.size() > 499) {
            this.executeMoreThanMaxInvokeNum(importWrappers);
        } else {
            this.executeLessEqualsMaxInvokeNum(importWrappers);
        }
    }

    private void executeMoreThanMaxInvokeNum(List<EntryImportWrapper> importWrappers) {
        CopyOnWriteArrayList<EntryImportWrapper> copyOnWriteArrayList = new CopyOnWriteArrayList<EntryImportWrapper>(importWrappers);
        int countDownSize = this.getCountDownSize(importWrappers);
        CountDownLatch countDownLatch = new CountDownLatch(countDownSize);
        try {
            int size = importWrappers.size();
            for (int i = 0; i < countDownSize; ++i) {
                List<EntryImportWrapper> list;
                if (i * 499 + 499 > size) {
                    list = copyOnWriteArrayList.subList(i * 499, size);
                    THREADPOOL.execute((Runnable)new Worker(list, countDownLatch));
                    break;
                }
                list = copyOnWriteArrayList.subList(i * 499, i * 499 + 499);
                THREADPOOL.execute((Runnable)new Worker(list, countDownLatch));
            }
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("executeMoreThanMaxInvokeNum error", (Throwable)e);
        }
    }

    private void executeLessEqualsMaxInvokeNum(List<EntryImportWrapper> entryImportWrappers) {
        CopyOnWriteArrayList<EntryImportWrapper> importWrappers = new CopyOnWriteArrayList<EntryImportWrapper>(entryImportWrappers);
        LOGGER.info("start beforeDataInitValidate");
        this.getEntryImportValidateService().beforeDataInitValidate().test(importWrappers);
        LOGGER.info("end beforeDataInitValidate");
        CopyOnWriteArrayList<EntryImportWrapper> previousPassed = new CopyOnWriteArrayList<EntryImportWrapper>();
        importWrappers.forEach(temp -> {
            if (temp.getValidateContext().getValidateResult().size() < 1) {
                previousPassed.add((EntryImportWrapper)temp);
            }
        });
        LOGGER.info("start EntryImportDataBuilder");
        this.getEntryImportDataBuilder().build(previousPassed);
        LOGGER.info("end EntryImportDataBuilder");
        LOGGER.info("start afterDataInitValidate");
        this.getEntryImportValidateService().afterDataInitValidate().test(previousPassed);
        LOGGER.info("end afterDataInitValidate ");
    }

    private int getCountDownSize(List<EntryImportWrapper> importWrappers) {
        int i = importWrappers.size() / 499;
        int result = i == 0 ? 1 : (importWrappers.size() % 499 != 0 ? i + 1 : i);
        return result;
    }

    protected abstract EntryImportValidateService getEntryImportValidateService();

    protected abstract EntryImportDataBuilder getEntryImportDataBuilder();

    class Worker
    implements Runnable {
        List<EntryImportWrapper> datas;
        CountDownLatch countDownLatch;

        public Worker(List<EntryImportWrapper> datas, CountDownLatch countDownLatch) {
            this.datas = datas;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                LOGGER.info("batch start beforeDataInitValidate");
                EntryImportController.this.getEntryImportValidateService().beforeDataInitValidate().test(this.datas);
                LOGGER.info("batch end beforeDataInitValidate");
                CopyOnWriteArrayList<EntryImportWrapper> previousPassed = new CopyOnWriteArrayList<EntryImportWrapper>();
                this.datas.forEach(temp -> {
                    if (temp.getValidateContext().getValidateResult().size() < 1) {
                        previousPassed.add((EntryImportWrapper)temp);
                    }
                });
                LOGGER.info("batch start EntryImportDataBuilder");
                EntryImportController.this.getEntryImportDataBuilder().build(previousPassed);
                LOGGER.info("batch end EntryImportDataBuilder");
                LOGGER.info("batch start afterDataInitValidate");
                EntryImportController.this.getEntryImportValidateService().afterDataInitValidate().test(previousPassed);
                LOGGER.info("batch end afterDataInitValidate ");
            }
            catch (Exception e) {
                LOGGER.error("EntryImportController Worker run error", (Throwable)e);
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

