/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.common.batch;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;

public abstract class EntryImportDataBuilder {
    private static final Log LOGGER = LogFactory.getLog(EntryImportDataBuilder.class);

    public CopyOnWriteArrayList<EntryImportWrapper> build(CopyOnWriteArrayList<EntryImportWrapper> importSource) {
        this.baseDataNumber2Id().andThen(this.getPeopleRecordByNumber()).andThen(this.setDefaultFieldValue()).andThen(this.getBelongCompany()).andThen(this.getOrgChargers()).andThen(this.setPositionJob()).andThen(this.setStpositionJob()).andThen(this.setBJobInfo()).andThen(this.setRealityDate()).andThen(this.genBillNo()).andThen(this.setAffaction()).andThen(this.setAppremoveInfo()).apply(importSource);
        return importSource;
    }

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> baseDataNumber2Id();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getPeopleRecordByNumber();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setDefaultFieldValue();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setAffaction();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getBelongCompany();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getOrgChargers();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setPositionJob();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setStpositionJob();

    public abstract Predicate<List<EntryImportWrapper>> validateStdPosition();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setBJobInfo();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setRealityDate();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> genBillNo();

    public abstract Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setAppremoveInfo();

    public abstract Map<String, String> getErmanfileMappingMap();

    public JSONObject genJSONObject(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("importprop", (Object)"id");
        jsonObject.put("id", (Object)id);
        return jsonObject;
    }

    public JSONObject genJSONObject(Map<String, Object> ermanfile, String key) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("importprop", (Object)"id");
        jsonObject.put("id", ermanfile.get(key));
        return jsonObject;
    }

    public void setAffactionId(CopyOnWriteArrayList<EntryImportWrapper> importSource, String devConfigKey, String errorMsg) {
        if (importSource.size() < 1) {
            return;
        }
        String type = ((JSONObject)importSource.get(0).getJsonObject().get((Object)"affaction")).containsKey((Object)"number") ? "number" : "name";
        Set<String> affactions = importSource.stream().map(entryImportWrapper -> entryImportWrapper.getJsonObject().getJSONObject("affaction").getString(type)).collect(Collectors.toSet());
        Map<String, DynamicObject> newAffactionMap = PersonnelChangeServiceHelper.getNewAffactionMap(type, affactions, devConfigKey);
        importSource.forEach(temp -> {
            String affactionValue = temp.getJsonObject().getJSONObject("affaction").getString(type);
            if (!newAffactionMap.isEmpty() && newAffactionMap.containsKey(affactionValue)) {
                temp.getJsonObject().put("affaction", (Object)JsonObjectUtil.genJSONObject.apply(((DynamicObject)newAffactionMap.get(affactionValue)).getLong("id")));
            } else {
                temp.getValidateContext().setCompleteValidResult("validateAffaction", errorMsg);
            }
        });
    }
}

