/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.NumberGenerater;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.business.repository.ParttimeEndRepository;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import org.apache.commons.lang3.StringUtils;

public class ParttimeServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ParttimeServiceHelper.class);
    private static final String FIELD_BDEPEMP = "bdepemp";
    private static final String DEPEMP_ID = "depemp_id";

    private static Map<String, Object> getPersonParams(Map<String, Object> ermanFile) {
        HashMap<String, Object> personIdParams = new HashMap<String, Object>();
        personIdParams.put("person", ermanFile.get("person_id"));
        personIdParams.put("employee", ermanFile.get("employee_id"));
        personIdParams.put("depemp", ermanFile.get(DEPEMP_ID));
        personIdParams.put("cmpemp", ermanFile.get("cmpemp_id"));
        personIdParams.put("badminorg", ermanFile.get(DEPEMP_ID));
        personIdParams.put("bposition", ermanFile.get("position_id"));
        return personIdParams;
    }

    public static DynamicObject genParttimeEndBill(Map<String, Object> infoMap) {
        Long personId = (Long)infoMap.get("person");
        Long employeeId = (Long)infoMap.get("employee");
        Long depempId = (Long)infoMap.get("depemp");
        Long cmpempId = (Long)infoMap.get("cmpemp");
        Long adminorgId = (Long)infoMap.get("badminorg");
        Date partEndDate = (Date)infoMap.get("enddate");
        Long actionId = (Long)infoMap.get("affaction");
        Date effectDate = HRDateTimeUtils.addDay((Date)partEndDate, (long)1L);
        Date lastWorkDate = (Date)infoMap.get("lastworkdate");
        DynamicObject parttimeEndDy = ParttimeEndRepository.getInstance().generate();
        long billId = ORM.create().genLongId("hdm_parttimeendbill");
        parttimeEndDy.set("id", (Object)billId);
        ParttimeServiceHelper.setCreateField(parttimeEndDy);
        ParttimeServiceHelper.setModifyField(parttimeEndDy);
        if (HRDateTimeUtils.dayAfter((Date)new Date(), (Date)effectDate) || HRDateTimeUtils.dayEquals((Date)new Date(), (Date)effectDate)) {
            parttimeEndDy.set("isend", (Object)Boolean.TRUE);
        }
        String barCode = NumberGenerater.getInstance().generaterNextNumber(new Date(), "PAE");
        parttimeEndDy.set("barcode", (Object)barCode);
        String applyNum = CodeRuleServiceHelper.getNumber((String)"hdm_parttimeendbill", (DynamicObject)parttimeEndDy, null);
        parttimeEndDy.set("billno", (Object)applyNum);
        parttimeEndDy.set("ismultientry", (Object)"0");
        parttimeEndDy.set("isexistsworkflow", (Object)"0");
        long orgId = RequestContext.get().getOrgId();
        parttimeEndDy.set("org", (Object)orgId);
        parttimeEndDy.set("auditstatus", (Object)"C");
        parttimeEndDy.set("billstatus", (Object)"C");
        parttimeEndDy.set("partfile", infoMap.get("partfile"));
        parttimeEndDy.set("person", (Object)personId);
        parttimeEndDy.set("bemployee", (Object)employeeId);
        parttimeEndDy.set(FIELD_BDEPEMP, (Object)depempId);
        parttimeEndDy.set("bcmpemp", (Object)cmpempId);
        parttimeEndDy.set("badminorg", (Object)adminorgId);
        parttimeEndDy.set("effectdate", (Object)effectDate);
        parttimeEndDy.set("enddate", (Object)partEndDate);
        parttimeEndDy.set("lastworkdate", (Object)lastWorkDate);
        parttimeEndDy.set("affaction", (Object)actionId);
        return parttimeEndDy;
    }

    private static void setCreateField(DynamicObject dy) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date sysCurrentTime = new Date();
        dy.set("creator", (Object)userId);
        dy.set("createtime", (Object)sysCurrentTime);
    }

    private static void setModifyField(DynamicObject dy) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date sysCurrentTime = new Date();
        dy.set("modifier", (Object)userId);
        dy.set("modifytime", (Object)sysCurrentTime);
    }

    public static List<DynamicObject> getDiscardBills(List<DynamicObject> bills) {
        Map<Long, List<DynamicObject>> employeeMap = ParttimeServiceHelper.coverToMap(bills);
        Map<Long, DynamicObject> employeeStatusMap = RegPeronalBillHelper.getInstance().getEmployeeStatus(new ArrayList<Long>(employeeMap.keySet()));
        ArrayList<DynamicObject> discardBills = new ArrayList<DynamicObject>();
        for (Map.Entry<Long, DynamicObject> entry : employeeStatusMap.entrySet()) {
            DynamicObject statusDy = entry.getValue();
            if (!LabRelConstants.QUIT.equals(statusDy.getLong("labrelstatuscls_id"))) continue;
            employeeMap.get(entry.getKey()).forEach(bill -> {
                bill.set("parttimestatus", (Object)"-1");
                bill.set("blaborrelstatus", statusDy.get("id"));
            });
            discardBills.addAll((Collection<DynamicObject>)employeeMap.get(entry.getKey()));
        }
        return discardBills;
    }

    private static Map<Long, List<DynamicObject>> coverToMap(List<DynamicObject> bills) {
        Map<Long, List<DynamicObject>> map = bills.stream().collect(Collectors.toMap(bill -> bill.getLong("primaryemployee.id"), bill -> {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            list.add((DynamicObject)bill);
            return list;
        }, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }));
        return map;
    }

    public static Set<Long> validateTerminateFlow(Object[] primaryKeyValues) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hdm_parttimeapplybill");
        DynamicObject[] dynamicObjects = helper.queryOriginalArray("id, billstatus,parttimestatus", new QFilter("id", "in", (Object)primaryKeyValues).toArray());
        HashSet<Long> failIds = new HashSet<Long>();
        for (DynamicObject lastBillDy : dynamicObjects) {
            String billStatus = lastBillDy.getString("billstatus");
            String partTimeStatus = lastBillDy.getString("parttimestatus");
            if (!HRStringUtils.equals((String)"F", (String)billStatus) && !HRStringUtils.equals((String)"A", (String)billStatus) && HRStringUtils.equals((String)"0", (String)partTimeStatus)) continue;
            failIds.add(lastBillDy.getLong("id"));
        }
        return failIds;
    }

    public static void batchEndParttime(Long actionId, Date partEndDate, List<Map<String, Object>> ermanFiles) {
        DynamicObject[] partBills;
        Map<Long, List<Map>> ermanFilesMap = ermanFiles.stream().collect(Collectors.groupingBy(ermanFile -> (Long)ermanFile.get(DEPEMP_ID)));
        Set<Long> depempSet = ermanFilesMap.keySet();
        DynamicObject[] existBills = ParttimeEndRepository.getInstance().loadDynamicObjectArray(new QFilter[]{new QFilter(FIELD_BDEPEMP, "in", depempSet)});
        ArrayList parttimeEndBillsAddNew = new ArrayList(ermanFiles.size());
        ArrayList<DynamicObject> parttimeEndBillsEffect = new ArrayList<DynamicObject>(ermanFiles.size());
        ArrayList<DynamicObject> isEffectNowBills = new ArrayList<DynamicObject>(ermanFiles.size());
        Date effectDate = HRDateTimeUtils.addDay((Date)new Date(), (long)-1L);
        Date effectdate = HRDateTimeUtils.addDay((Date)partEndDate, (long)1L);
        HashSet<Long> existIds = new HashSet<Long>(existBills.length);
        for (DynamicObject existBill : existBills) {
            existBill.set("enddate", (Object)partEndDate);
            existBill.set("effectdate", (Object)effectdate);
            existBill.set("lastworkdate", (Object)effectdate);
            existBill.set("affaction", (Object)actionId);
            if (HRDateTimeUtils.dayBefore((Date)partEndDate, (Date)effectDate) || HRDateTimeUtils.dayEquals((Date)partEndDate, (Date)effectDate)) {
                isEffectNowBills.add(existBill);
            } else {
                parttimeEndBillsEffect.add(existBill);
            }
            existIds.add(existBill.getLong("bdepemp.id"));
        }
        ermanFilesMap.forEach((bdepempId, ermanFileList) -> {
            if (!existIds.contains(bdepempId)) {
                ermanFileList.forEach(map -> {
                    Map<String, Object> personParams = ParttimeServiceHelper.getPersonParams(map);
                    personParams.put("partfile", map.get("id"));
                    personParams.put("enddate", partEndDate);
                    personParams.put("lastworkdate", HRDateTimeUtils.addDay((Date)partEndDate, (long)1L));
                    personParams.put("affaction", actionId);
                    DynamicObject parttimeEndBill = ParttimeServiceHelper.genParttimeEndBill(personParams);
                    if (HRDateTimeUtils.dayBefore((Date)partEndDate, (Date)effectDate) || HRDateTimeUtils.dayEquals((Date)partEndDate, (Date)effectDate)) {
                        parttimeEndBill.set("isend", (Object)Boolean.TRUE);
                        isEffectNowBills.add(parttimeEndBill);
                    } else {
                        parttimeEndBillsAddNew.add(parttimeEndBill);
                    }
                });
            }
        });
        ArrayList bills = new ArrayList();
        bills.addAll(parttimeEndBillsAddNew);
        bills.addAll(parttimeEndBillsEffect);
        bills.addAll(isEffectNowBills);
        DynamicObject[] savedBills = (DynamicObject[])ParttimeEndRepository.getInstance().save(bills.toArray(new DynamicObject[bills.size()]));
        Long[] ids = (Long[])Arrays.stream(savedBills).map(savedBill -> savedBill.getLong("id")).toArray(Long[]::new);
        DynamicObject[] dynamicObjects = ParttimeEndRepository.getInstance().load(ids);
        if (!isEffectNowBills.isEmpty()) {
            PerChgBizUtils.personChangeOfEndPart(dynamicObjects);
        } else {
            if (!parttimeEndBillsAddNew.isEmpty()) {
                PerChgBizUtils.personChangeRecordPartEnd(dynamicObjects, PerChgBizOperateType.CHGOPERATION_ADDNEW);
            }
            if (!parttimeEndBillsEffect.isEmpty()) {
                PerChgBizUtils.personChangeRecordPartEnd(dynamicObjects, PerChgBizOperateType.CHGOPERATION_EFFECT);
            }
        }
        QFilter adepempQFilter = new QFilter("adepemp", "in", depempSet);
        for (DynamicObject partBill : partBills = ParttimeApplyRepository.getInstance().query("id, partenddate", new QFilter[]{adepempQFilter}, null)) {
            partBill.set("partenddate", (Object)partEndDate);
        }
        ParttimeApplyRepository.getInstance().update(partBills);
    }

    public static List<HRExportHeadObject> getExcelExportHeads(Map<String, String> excelHeads) {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>();
        excelHeads.forEach((columnKey, columnAlias) -> headdatalist.add(new HRExportHeadObject(columnKey, columnAlias)));
        return headdatalist;
    }

    public static List<Map<String, Object>> buildExceportInfo(Map<Long, String> failMap, List<Map<String, Object>> erManFiles) {
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(erManFiles.size());
        String success = ResManager.loadKDString((String)"\u6210\u529f", (String)"ParttimeServiceHelper_11", (String)"hr-hdm-business", (Object[])new Object[0]);
        String fail = ResManager.loadKDString((String)"\u5931\u8d25", (String)"ParttimeServiceHelper_12", (String)"hr-hdm-business", (Object[])new Object[0]);
        Map<String, String> apositiontypeMap = ParttimeServiceHelper.getApositiontype();
        for (Map<String, Object> erManFile : erManFiles) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Long id = (Long)erManFile.get("id");
            map.put("name", erManFile.get("name"));
            map.put("worknumber", erManFile.get("number"));
            map.put("empposrel.company.name", erManFile.get("company"));
            map.put("empposrel.adminorg.name", erManFile.get("adminorg"));
            map.put("empposrel.apositiontype", apositiontypeMap.get((String)erManFile.get("apositiontype")));
            map.put("empposrel.position.name", erManFile.get("position"));
            map.put("empposrel.stdposition.name", erManFile.get("stdposition"));
            map.put("empposrel.job.name", erManFile.get("job"));
            if (failMap.containsKey(id)) {
                map.put("validate.result", fail);
                map.put("validate.description", failMap.get(id));
            } else {
                map.put("validate.result", success);
                map.put("validate.description", "");
            }
            exportDataList.add(map);
        }
        return exportDataList;
    }

    public static String getExcelUrl(String excelName, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headDataList) {
        try {
            String exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName.trim(), exportDataList, headDataList);
            return exportUrl;
        }
        catch (IOException e) {
            LOGGER.error("upload result excel error: ", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getExcelHeads() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ParttimeServiceHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("worknumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ParttimeServiceHelper_2", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("empposrel.company.name", ResManager.loadKDString((String)"\u517c\u804c\u516c\u53f8", (String)"ParttimeServiceHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("empposrel.adminorg.name", ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8", (String)"ParttimeServiceHelper_4", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("empposrel.apositiontype", ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f", (String)"ParttimeServiceHelper_5", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("empposrel.position.name", ResManager.loadKDString((String)"\u517c\u804c\u5c97\u4f4d", (String)"ParttimeServiceHelper_6", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("empposrel.stdposition.name", ResManager.loadKDString((String)"\u517c\u804c\u6807\u51c6\u5c97\u4f4d", (String)"ParttimeServiceHelper_7", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("empposrel.job.name", ResManager.loadKDString((String)"\u517c\u804c\u804c\u4f4d", (String)"ParttimeServiceHelper_8", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("validate.result", ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"ParttimeServiceHelper_9", (String)"hr-hdm-business", (Object[])new Object[0]));
        map.put("validate.description", ResManager.loadKDString((String)"\u6821\u9a8c\u8bf4\u660e", (String)"ParttimeServiceHelper_10", (String)"hr-hdm-business", (Object[])new Object[0]));
        return map;
    }

    public static Map<String, String> getApositiontype() {
        HashMap<String, String> apositiontypeMap = new HashMap<String, String>(8);
        apositiontypeMap.put("1", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"ParttimeServiceHelper_13", (String)"hr-hdm-business", (Object[])new Object[0]));
        apositiontypeMap.put("2", ResManager.loadKDString((String)"\u804c\u4f4d", (String)"ParttimeServiceHelper_14", (String)"hr-hdm-business", (Object[])new Object[0]));
        apositiontypeMap.put("0", ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"ParttimeServiceHelper_15", (String)"hr-hdm-business", (Object[])new Object[0]));
        return apositiontypeMap;
    }

    public static String getAppDispatchNumChangeTip(DynamicObject appointRemoveRelObj, DynamicObject dataEntity) {
        String positionName;
        String adminOrgName;
        StringBuilder tipContent = new StringBuilder();
        String personName = dataEntity.getString("person.name");
        String appDispatchNum = dataEntity.getString("appdispatchnum");
        tipContent.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u5458\u5de5\u201c{0}\u201d\u5df2\u6709\u57fa\u4e8e\u53d1\u6587\u6587\u53f7\u201c{1}\u201d\u4efb\u547d\u4fe1\u606f\uff0c\u786e\u8ba4\u6839\u636e\u8be5\u4efb\u547d\u4fe1\u606f\u8fdb\u884c\u517c\u804c\u7533\u8bf7\uff1f", (String)"ParttimeServiceHelper_16", (String)"hr-hdm-business", (Object[])new Object[]{personName, appDispatchNum}));
        tipContent.append("\r\n");
        tipContent.append(ResManager.loadKDString((String)"\u4efb\u547d\u4fe1\u606f\uff1a", (String)"ParttimeServiceHelper_17", (String)"hr-hdm-business", (Object[])new Object[0]));
        ArrayList appointRemoveInfoList = Lists.newArrayListWithExpectedSize((int)3);
        String companyName = appointRemoveRelObj.getString("company.name");
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            appointRemoveInfoList.add(companyName);
        }
        if (StringUtils.isNotBlank((CharSequence)(adminOrgName = appointRemoveRelObj.getString("adminorgvid.name")))) {
            appointRemoveInfoList.add(adminOrgName);
        }
        if (StringUtils.isNotBlank((CharSequence)(positionName = appointRemoveRelObj.getString("positionvid.name")))) {
            appointRemoveInfoList.add(positionName);
        }
        tipContent.append(String.join((CharSequence)"/", appointRemoveInfoList));
        return tipContent.toString();
    }
}

