/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.parttime.ParttimeEndHPFSTemplateHandler;
import kd.hr.hdm.business.domain.parttime.ParttimeHPFSTemplateHandler;
import kd.hr.hdm.business.domain.parttime.external.IParttimePersonalChangeService;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.hr.hpfs.business.perchg.bizentity.PerChgParam;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;

public class PerChgBizUtils {
    private static final Log LOGGER = LogFactory.getLog(PerChgBizUtils.class);
    private static final String HDM_PART_PERCHG_QUEUE = "hdm_part_perchg_queue";
    private static final String KEY_CROSSVALIDATERANGE = "crossValidNoti";
    private static final String KEY_BILLNO = "billNo";
    private static final String KEY_ACTIONNAME = "actionName";
    private static final String CROSSVALIDATERANGE_WARN = "2";
    private static final String CROSSVALIDATERANGE_BAN = "3";

    public static void personChangeOfPart(DynamicObject[] bills) {
        if (bills == null || bills.length < 1) {
            return;
        }
        if (bills[0].getBoolean("affaction.isnewchgaction")) {
            ParttimeHPFSTemplateHandler.getInstance().saveHPFSEffectMessageAsync(bills);
        } else {
            PerChgBizUtils.personChangeOfPartOld(bills);
        }
    }

    public static void personChangeOfEndPart(DynamicObject[] bills) {
        if (bills[0].getBoolean("affaction.isnewchgaction")) {
            ParttimeEndHPFSTemplateHandler.getInstance().saveHPFSEffectMessageAsync(bills);
        } else {
            PerChgBizUtils.personChangeOfEndPartOld(bills);
        }
    }

    public static void personChangeOfPartOld(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            LOGGER.info("personChangeOfPart:{} start", (Object)bill.getString("id"));
            try {
                Long billId = bill.getLong("id");
                String billno = "entryentity".equals(bill.getDataEntityType().toString()) ? bill.getString("ebillno") : bill.getString("billno");
                PerChgParam perChgParam = new PerChgParam();
                perChgParam.setAppId("hdm");
                perChgParam.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
                ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>();
                PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
                Long actionId = HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("affaction"));
                perChgBizInfo.setActionId(actionId);
                perChgBizInfo.setBillId(billId);
                perChgBizInfo.setOldErfileId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("partperson"))));
                perChgBizInfo.setBillNo(billno);
                perChgBizInfo.setBillSource("hdm_parttimeapplybill");
                perChgBizInfo.setOldPersonId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("person"))));
                perChgBizInfo.setOldEmployeeId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("primaryemployee"))));
                perChgBizInfo.setOldComempId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("primarycmpemp"))));
                perChgBizInfo.setOldDepempId(Long.valueOf(HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("primarydepemp"))));
                perChgBizInfo.setBsed(bill.getDate("effectdate"));
                HashMap<String, List<Long>> dataRow = new HashMap<String, List<Long>>(16);
                dataRow.put("hdm_parttimeapplybill", Collections.singletonList(bill.getLong("id")));
                perChgBizInfo.setDataRow(dataRow);
                bizInfoList.add(perChgBizInfo);
                perChgParam.setBizInfoList(bizInfoList);
                perChgParam.setResultCallBackQueue(HDM_PART_PERCHG_QUEUE);
                HashMap<String, Integer> params = new HashMap<String, Integer>(16);
                params.put("operatetype", PerChgBizOperateType.CHGOPERATION_ADDNEWANDEFFECT.getCode());
                params.put("billdata", (Integer)perChgParam);
                LOGGER.info("personChangeOfPart params\uff1a{}", (Object)JSONObject.toJSONString(params));
                PerChgBizUtils.sendMQMessage(JSONObject.toJSONString(params), "hpfs_perchg_queue");
            }
            catch (KDException exception) {
                LOGGER.error("personChangeOfPart error", (Throwable)exception);
            }
            LOGGER.info("personChangeOfPart:{} end", (Object)bill.getString("id"));
        }
    }

    public static void personChangeRecord(DynamicObject[] bills, PerChgBizOperateType operateType) {
        for (DynamicObject bill : bills) {
            LOGGER.info("personChangeRecord:{} start", (Object)bill.getString("id"));
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("operation", operateType.getCode());
                params.put("actionId", HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("affaction")));
                params.put("personId", HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("person")));
                params.put("employeeId", HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("primaryemployee")));
                params.put("managingScopeId", HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("primarycmpemp")));
                params.put("depEmpId", HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("primarydepemp")));
                params.put("billId", bill.getLong("id"));
                params.put(KEY_BILLNO, "entryentity".equals(bill.getDynamicObjectType().toString()) ? bill.getString("ebillno") : bill.getString("billno"));
                params.put("appId", "hdm");
                params.put("billSource", "hdm_parttimeapplybill");
                params.put("bsed", bill.getDate("effectdate"));
                LOGGER.info("personChangeRecord params\uff1a{}", (Object)JSONObject.toJSONString(params));
                PerChgBizUtils.sendMQMessage(JSONObject.toJSONString(params), "hpfs_chgrecord_queue");
            }
            catch (KDException exception) {
                LOGGER.error("personChangeRecord error", (Throwable)exception);
            }
            LOGGER.info("personChangeRecord:{} end", (Object)bill.getString("id"));
        }
    }

    public static void personChangeRecordPartEnd(DynamicObject[] bills, PerChgBizOperateType operateType) {
        for (DynamicObject bill : bills) {
            LOGGER.info("personChangeRecordPartEnd:{} start", (Object)bill.getString("id"));
            try {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("operation", operateType.getCode());
                Long actionId = HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("affaction"));
                params.put("actionId", actionId);
                params.put("personId", bill.get("person.id"));
                params.put("employeeId", bill.get("bemployee.id"));
                params.put("managingScopeId", bill.get("bcmpemp.id"));
                params.put("depEmpId", bill.get("bdepemp.id"));
                params.put("billId", bill.getLong("id"));
                params.put(KEY_BILLNO, bill.getString("billno"));
                params.put("appId", "hdm");
                params.put("billSource", "hdm_parttimeendbill");
                params.put("bsed", HRDateTimeUtils.addDay((Date)bill.getDate("enddate"), (long)1L));
                LOGGER.info("personChangeOfPart params\uff1a{}", (Object)JSONObject.toJSONString(params));
                PerChgBizUtils.sendMQMessage(JSONObject.toJSONString(params), "hpfs_chgrecord_queue");
            }
            catch (KDException exception) {
                LOGGER.error("personChangeRecordPartEnd error", (Throwable)exception);
            }
            LOGGER.info("personChangeRecordPartEnd:{} end", (Object)bill.getString("id"));
        }
    }

    public static void personChangeOfEndPartOld(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            LOGGER.info("personChangeOfEndPart:{} start", (Object)bill.getString("id"));
            try {
                Long actionId = HRDyObjectPropUtil.getId((DynamicObject)bill.getDynamicObject("affaction"));
                Long billId = bill.getLong("id");
                PerChgParam perChgParam = new PerChgParam();
                perChgParam.setAppId("hdm");
                perChgParam.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
                ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>();
                PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
                perChgBizInfo.setActionId(actionId);
                perChgBizInfo.setBillId(billId);
                Long partfileId = (Long)bill.get("partfile.id");
                perChgBizInfo.setOldErfileId(partfileId);
                perChgBizInfo.setBillNo(bill.getString("billno"));
                perChgBizInfo.setBillSource("hdm_parttimeendbill");
                perChgBizInfo.setOldPersonId((Long)bill.get("person.id"));
                perChgBizInfo.setOldComempId((Long)bill.get("bcmpemp.id"));
                perChgBizInfo.setOldEmployeeId((Long)bill.get("bemployee.id"));
                perChgBizInfo.setOldDepempId((Long)bill.get("bdepemp.id"));
                perChgBizInfo.setBsed(HRDateTimeUtils.addDay((Date)bill.getDate("enddate"), (long)1L));
                HashMap<String, List<Long>> dataRow = new HashMap<String, List<Long>>(1);
                dataRow.put("hdm_parttimeendbill", Collections.singletonList(bill.getLong("id")));
                perChgBizInfo.setDataRow(dataRow);
                bizInfoList.add(perChgBizInfo);
                perChgParam.setBizInfoList(bizInfoList);
                perChgParam.setResultCallBackQueue(HDM_PART_PERCHG_QUEUE);
                HashMap<String, Integer> params = new HashMap<String, Integer>(2);
                params.put("operatetype", PerChgBizOperateType.CHGOPERATION_ADDNEWANDEFFECT.getCode());
                params.put("billdata", (Integer)perChgParam);
                LOGGER.info("personChangeOfEndPart params\uff1a{}", (Object)JSONObject.toJSONString(params));
                PerChgBizUtils.sendMQMessage(JSONObject.toJSONString(params), "hpfs_perchg_queue");
            }
            catch (KDException exception) {
                LOGGER.error("personChangeOfEndPart error", (Throwable)exception);
            }
            LOGGER.info("personChangeOfEndPart:{} end", (Object)bill.getString("id"));
        }
    }

    public static List<Map<String, Object>> singleCrossValidate(DynamicObject parttimeBill) {
        Map<String, Object> param = PerChgBizUtils.buildCrossValidateParam(parttimeBill);
        return PerChgBizUtils.getSingleCrossValidateResult(param);
    }

    public static Map<Long, List<Map<String, Object>>> batchCrossValidate(List<DynamicObject> parttimeBills) {
        if (ObjectUtils.isEmpty(parttimeBills)) {
            return new HashMap<Long, List<Map<String, Object>>>();
        }
        List<Map<String, Object>> params = parttimeBills.stream().map(PerChgBizUtils::buildCrossValidateParam).collect(Collectors.toList());
        return PerChgBizUtils.getBatchCrossValidateResult(params);
    }

    public static boolean dealCrossValidate(List<Map<String, Object>> crossList, DataValidate<DynamicObject> dataValidate) {
        if (HRCollUtil.isEmpty(crossList)) {
            return true;
        }
        crossList.sort(new ParttimeValidateHelper.CrossRangeComparator());
        StringBuilder errorMsg = new StringBuilder();
        StringBuilder warnMsg = new StringBuilder();
        for (Map<String, Object> crossMap : crossList) {
            String crossValidateRange = (String)crossMap.get(KEY_CROSSVALIDATERANGE);
            String actionName = (String)crossMap.get(KEY_ACTIONNAME);
            String crossBillNo = (String)crossMap.get(KEY_BILLNO);
            StringBuilder sb = new StringBuilder().append(actionName).append("\uff08").append(crossBillNo).append("\uff09").append("\u3001");
            if (HRStringUtils.equals((String)CROSSVALIDATERANGE_BAN, (String)crossValidateRange)) {
                errorMsg.append((CharSequence)sb);
            }
            if (errorMsg.length() >= 1 || !HRStringUtils.equals((String)CROSSVALIDATERANGE_WARN, (String)crossValidateRange)) continue;
            warnMsg.append((CharSequence)sb);
        }
        if (errorMsg.length() > 0) {
            PerChgBizUtils.buildCrossBanMessage(dataValidate, errorMsg.substring(0, errorMsg.length() - 1));
        } else {
            PerChgBizUtils.buildCrossWarnMessage(dataValidate, warnMsg.substring(0, warnMsg.length() - 1));
        }
        return false;
    }

    private static void buildCrossBanMessage(DataValidate<DynamicObject> dataValidate, String crossMsg) {
        DynamicObject dy = (DynamicObject)dataValidate.getData();
        String name = dy.getDynamicObjectType().getName();
        String parentName = dy.getDynamicObjectType().getParent() == null ? null : dy.getDynamicObjectType().getParent().getName();
        String errorMsg = null;
        if ("hdm_parttimeapplybill".equals(name) || "hdm_batchparttime".equals(parentName)) {
            errorMsg = PerChgBizUtils.buildParttimeBanCrossMessage(dy, crossMsg);
        }
        dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
    }

    private static void buildCrossWarnMessage(DataValidate<DynamicObject> dataValidate, String crossMsg) {
        DynamicObject dy = (DynamicObject)dataValidate.getData();
        String name = dy.getDynamicObjectType().getName();
        String parentName = dy.getDynamicObjectType().getParent() == null ? null : dy.getDynamicObjectType().getParent().getName();
        String warnMsg = null;
        if ("hdm_parttimeapplybill".equals(name) || "hdm_batchparttime".equals(parentName)) {
            warnMsg = PerChgBizUtils.buildParttimeWarnCrossMessage(dy, crossMsg);
        }
        dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_CONFIRM, "all", warnMsg);
    }

    private static String buildParttimeBanCrossMessage(DynamicObject parttimeBill, String errorMsg) {
        String personName = parttimeBill.getString("partperson.name");
        return String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5df2\u53d1\u751f\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u517c\u804c\u3002", (String)"ParttimeValidateHelper_2", (String)"hr-hdm-business", (Object[])new Object[0]), personName, errorMsg);
    }

    private static String buildParttimeWarnCrossMessage(DynamicObject parttimeBill, String warnMsg) {
        String personName = parttimeBill.getString("partperson.name");
        return String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u201c%2$s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ParttimeValidateHelper_7", (String)"hr-hdm-business", (Object[])new Object[0]), personName, warnMsg);
    }

    private static void sendMQMessage(String params, String mqQueue) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", mqQueue);){
            pub.publish(params);
        }
    }

    private static Map<String, Object> buildCrossValidateParam(DynamicObject parttimeBill) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DynamicObject ermanfile = parttimeBill.getDynamicObject("partperson");
        Date effectDate = parttimeBill.getDate("effectdate");
        String billno = "entryentity".equals(parttimeBill.getDataEntityType().toString()) ? parttimeBill.getString("ebillno") : parttimeBill.getString("billno");
        param.put(KEY_BILLNO, billno);
        param.put("actionId", parttimeBill.getString("affaction.id"));
        param.put("effectTime", effectDate.getTime());
        param.put("personId", ermanfile.getString("person.id"));
        param.put("employeeId", ermanfile.getString("employee.id"));
        param.put("managingScopeId", ermanfile.getString("cmpemp.id"));
        param.put("depEmpId", ermanfile.getString("depemp.id"));
        return param;
    }

    public static List<Map<String, Object>> getSingleCrossValidateResult(Map<String, Object> param) {
        LOGGER.info("getSingleCrossValidateResult param : {}", param);
        Map<String, Object> perChgResult = IParttimePersonalChangeService.getInstance().invokerSingleCrossValidate(param);
        LOGGER.info("getSingleCrossValidateResult result : {}", perChgResult);
        if (ObjectUtils.isEmpty(perChgResult) || !((Boolean)perChgResult.get("success")).booleanValue()) {
            return new ArrayList<Map<String, Object>>();
        }
        return (List)perChgResult.get("data");
    }

    public static Map<Long, List<Map<String, Object>>> getBatchCrossValidateResult(List<Map<String, Object>> params) {
        LOGGER.info("getBatchCrossValidateResult param : {}", params);
        Map<String, Object> perChgResult = IParttimePersonalChangeService.getInstance().invokerBatchCrossValidate(params);
        LOGGER.info("getBatchCrossValidateResult result : {}", perChgResult);
        if (ObjectUtils.isEmpty(perChgResult) || !((Boolean)perChgResult.get("success")).booleanValue()) {
            return new HashMap<Long, List<Map<String, Object>>>();
        }
        return (Map)perChgResult.get("data");
    }
}

