/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.OrgImportHandler;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;

public class PartTimeOrgImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(OrgImportHandler.class);
    private Set<String> orgList = new HashSet<String>();
    private Map<String, Map<String, Object>> orgMap = new HashMap<String, Map<String, Object>>();
    private List<Long> orgIds = new ArrayList<Long>();

    public PartTimeOrgImportHandler(PartTimeEntryImportNumberToIdBO entryImportNumberToIdBO) {
        super(entryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject baseData = entryImportWrapper.getJsonObject().getJSONObject("aadminorg");
        if (baseData == null) {
            return;
        }
        String number = baseData.getString("number");
        this.orgList.add(number);
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                LOGGER.info("start genOrgNumberIdMap");
                Map<String, Map<String, Object>> adminorg = AdminOrgExternalService.getInstance().queryAdminorgByNumber(new ArrayList<String>(this.orgList), new Date());
                if (importSource.size() <= 500) {
                    LOGGER.info("EntryImportSerivceImpl adminorgNumber2Id invokeResult : {} ", (Object)adminorg.toString());
                }
                this.setOrgMap(adminorg);
                LOGGER.info("end genOrgNumberIdMap");
            }
            catch (Exception exception) {
                LOGGER.error("EntryImportSerivceImpl adminorgNumber2Id error exception is : ", (Throwable)exception);
                LOGGER.error("EntryImportSerivceImpl adminorgNumber2Id invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject org = temp.getJsonObject().getJSONObject("aadminorg");
                    if (org != null) {
                        temp.getValidateContext().setCompleteValidResult("orgNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeOrgImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                });
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        try {
            LOGGER.info("start orgNumber2Id");
            String number = (String)((JSONObject)entryImportWrapper.getJsonObject().get((Object)"aadminorg")).get((Object)"number");
            Map<String, Object> orgInfoMap = this.orgMap.get(number);
            if (orgInfoMap == null) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("orgNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeOrgImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            if (!orgInfoMap.get("enable").equals("1")) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("orgNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeOrgImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            Long orgId = (Long)orgInfoMap.get("id");
            JSONObject aadminorg = JsonObjectUtil.genJSONObject.apply(orgId);
            aadminorg.put("boid", (Object)orgId);
            entryImportWrapper.getJsonObject().put("aadminorg", (Object)aadminorg);
            entryImportWrapper.getJsonObject().put("aadminorg_no", (Object)number);
            entryImportWrapper.getJsonObject().put("aadminorg_name", orgInfoMap.get("name"));
            this.orgIds.add(orgId);
            LOGGER.info("end orgNumber2Id orgId:", (Object)orgId);
        }
        catch (Exception exception) {
            LOGGER.error("error orgNumber2id :", (Throwable)exception);
            entryImportWrapper.getValidateContext().setCompleteValidResult("orgNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeOrgImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
    }

    public Set<String> getOrgList() {
        return this.orgList;
    }

    public Map<String, Map<String, Object>> getOrgMap() {
        return this.orgMap;
    }

    public void setOrgList(Set<String> orgList) {
        this.orgList = orgList;
    }

    public void setOrgMap(Map<String, Map<String, Object>> orgMap) {
        this.orgMap = orgMap;
    }

    public List<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }
}

