/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;

public class PartTimePositionImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(PartTimePositionImportHandler.class);
    private Set<String> positionList = new HashSet<String>();
    private Map<String, Map<String, Object>> apositionMap = new HashMap<String, Map<String, Object>>();
    private List<Long> positionIds = new ArrayList<Long>();

    public PartTimePositionImportHandler(PartTimeEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject baseData = entryImportWrapper.getJsonObject().getJSONObject("aposition");
        if (baseData == null) {
            return;
        }
        String number = baseData.getString("number");
        this.positionList.add(number);
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                LOGGER.info("start genPoistionNumberIdMap");
                if (this.positionList.isEmpty()) {
                    return importSource;
                }
                Map<String, Object> position = AdminOrgExternalService.getInstance().queryPositionHisByNumber(new ArrayList<String>(this.positionList), new Date());
                if (importSource.size() <= 500) {
                    LOGGER.info("EntryImportSerivceImpl poistionNumber2Id invokeResult : {} ", (Object)position.toString());
                }
                List data = (List)position.get("data");
                Map<String, Map<String, Object>> collect = data.stream().filter(temp -> temp.get("enable").equals("1")).collect(Collectors.toMap(temp -> (String)temp.get("number"), Function.identity(), (k1, k2) -> k1));
                this.setApositionMap(collect);
                LOGGER.info("end genPoistionNumberIdMap");
            }
            catch (Exception exception) {
                LOGGER.error("EntryImportSerivceImpl poistionNumber2Id error exception is : ", (Throwable)exception);
                LOGGER.error("EntryImportSerivceImpl poistionNumber2Id invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject postion = temp.getJsonObject().getJSONObject("aposition");
                    if (postion != null) {
                        temp.getValidateContext().setCompleteValidResult("positionNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimePositionImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                });
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        try {
            LOGGER.info("start positionNumber2Id");
            JSONObject importSource = entryImportWrapper.getJsonObject();
            String postpattern = importSource.getString("apositiontype");
            if (!postpattern.equals(ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_0", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                return;
            }
            String number = (String)((JSONObject)entryImportWrapper.getJsonObject().get((Object)"aposition")).get((Object)"number");
            Map<String, Object> positonInfoMap = this.apositionMap.get(number);
            Long positionId = (Long)positonInfoMap.get("boid");
            if (positionId == null) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("positionNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimePositionImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            this.positionIds.add(positionId);
            JSONObject aposition = JsonObjectUtil.genJSONObject.apply(positionId);
            aposition.put("boid", (Object)positionId);
            entryImportWrapper.getJsonObject().put("aposition", (Object)aposition);
            entryImportWrapper.getJsonObject().put("aposition_no", (Object)number);
            entryImportWrapper.getJsonObject().put("aposition_name", positonInfoMap.get("name"));
            LOGGER.info("end positionNumber2Id positionId:", (Object)positionId);
        }
        catch (Exception exception) {
            LOGGER.error("error positionNumber2Id exception:", (Throwable)exception);
            entryImportWrapper.getValidateContext().setCompleteValidResult("positionNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimePositionImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
    }

    public Set<String> getPositionList() {
        return this.positionList;
    }

    public void setPositionList(Set<String> positionList) {
        this.positionList = positionList;
    }

    public List<Long> getPositionIds() {
        return this.positionIds;
    }

    public void setPositionIds(List<Long> positionIds) {
        this.positionIds = positionIds;
    }

    public Map<String, Map<String, Object>> getApositionMap() {
        return this.apositionMap;
    }

    public void setApositionMap(Map<String, Map<String, Object>> apositionMap) {
        this.apositionMap = apositionMap;
    }
}

