/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;

public class PartTimeStpositionImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(PartTimeStpositionImportHandler.class);
    private List<Long> stpositionIds = new ArrayList<Long>();
    Set<String> stpositionList = new HashSet<String>();
    private Map<String, Map<String, Object>> astpositionMap = new HashMap<String, Map<String, Object>>();

    public PartTimeStpositionImportHandler(PartTimeEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject baseData = entryImportWrapper.getJsonObject().getJSONObject("astdposition");
        if (baseData == null) {
            return;
        }
        String number = baseData.getString("number");
        this.stpositionList.add(number);
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                LOGGER.info("start genStpoistionNumberIdMap");
                if (this.stpositionList.isEmpty()) {
                    return importSource;
                }
                Map<String, Object> position = AdminOrgExternalService.getInstance().queryStdPositionByNumber(new ArrayList<String>(this.stpositionList), new Date());
                List data = (List)position.get("data");
                Map<String, Map<String, Object>> collect = data.stream().filter(temp -> "1".equals(temp.get("enable"))).collect(Collectors.toMap(temp -> (String)temp.get("number"), Function.identity(), (k1, k2) -> k1));
                this.setAstpositionMap(collect);
                LOGGER.info("end genStpoistionNumberIdMap");
            }
            catch (Exception exception) {
                LOGGER.error("StpositionImportHandler stPoistionNumber2Id error exception: ", (Throwable)exception);
                LOGGER.error("StpositionImportHandler stPoistionNumber2Id invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject stposition = temp.getJsonObject().getJSONObject("astdposition");
                    if (stposition != null) {
                        temp.setCompleteValidResult("stpositionNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeStpositionImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                });
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        try {
            LOGGER.info("start stpositionNumber2Id");
            JSONObject importSource = entryImportWrapper.getJsonObject();
            String postpattern = importSource.getString("apositiontype");
            if (!postpattern.equals(ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_2", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                return;
            }
            String number = (String)((JSONObject)importSource.get((Object)"astdposition")).get((Object)"number");
            Map<String, Object> astpositionInfoMap = this.astpositionMap.get(number);
            Long positionId = (Long)astpositionInfoMap.get("boid");
            if (positionId == null) {
                entryImportWrapper.setCompleteValidResult("stpositionNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeStpositionImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            this.stpositionIds.add(positionId);
            JSONObject astdposition = JsonObjectUtil.genJSONObject.apply(positionId);
            astdposition.put("boid", (Object)positionId);
            importSource.put("astdposition", (Object)astdposition);
            importSource.put("astdposition_no", (Object)number);
            importSource.put("astdposition_name", astpositionInfoMap.get("name"));
            LOGGER.info("end stpositionNumber2Id stpositionId :", (Object)positionId);
        }
        catch (Exception exception) {
            LOGGER.error("error stpositionNumber2Id exception:", (Throwable)exception);
            entryImportWrapper.setCompleteValidResult("stpositionNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeStpositionImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
    }

    public List<Long> getStpositionIds() {
        return this.stpositionIds;
    }

    public Set<String> getStpositionList() {
        return this.stpositionList;
    }

    public void setStpositionIds(List<Long> stpositionIds) {
        this.stpositionIds = stpositionIds;
    }

    public void setStpositionList(Set<String> stpositionList) {
        this.stpositionList = stpositionList;
    }

    public Map<String, Map<String, Object>> getAstpositionMap() {
        return this.astpositionMap;
    }

    public void setAstpositionMap(Map<String, Map<String, Object>> astpositionMap) {
        this.astpositionMap = astpositionMap;
    }
}

