/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.external.IJobExternalService;
import kd.hr.hdm.business.domain.parttime.external.IParttimeAdminOrgExternalService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PositionExternalService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.parttime.service.ParttimeStatusHandler;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class PartimeBillServiceImpl
implements IParttimeBillService {
    private static final Log LOGGER = LogFactory.getLog(PartimeBillServiceImpl.class);
    private static final Integer DARKPOSITION_SUCCESS = 200;
    private static final String PARAM_EMPLOYEEID = "employee_id";
    private static final String PARAM_LABORRELSTATUSID = "alaborrelstatus_id";
    private static final String RESULT_SUCCESS = "success";
    private static final String RESULT_MESSAGE = "msg";
    private static final List<String> EFFECTIVESTATUS_COLLECTIONS = Arrays.asList("A", "B", "C", "G", "D");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> dealQuitMessage(Map<String, Object> quitInfo) {
        LOGGER.info("quitInfo param is :[{}]", quitInfo);
        if (!this.validateRequestParam(quitInfo)) {
            return this.buildResult(Boolean.FALSE, "request param error");
        }
        QFilter employeeFilter = new QFilter("primaryemployee", "=", quitInfo.get(PARAM_EMPLOYEEID));
        QFilter billStatusFilter = new QFilter("billstatus", "in", EFFECTIVESTATUS_COLLECTIONS);
        DynamicObject[] bills = ParttimeApplyRepository.getInstance().load(new QFilter[]{employeeFilter, billStatusFilter});
        if (!ObjectUtils.isEmpty((Object)bills)) {
            Arrays.asList(bills).forEach(bill -> this.dealQuit((DynamicObject)bill, quitInfo.get(PARAM_LABORRELSTATUSID)));
            try (TXHandle txHandle = TX.requiresNew();){
                ParttimeApplyRepository.getInstance().update(bills);
            }
        }
        return this.buildResult(Boolean.TRUE, "");
    }

    @Override
    public Map<String, Long> getJobHisOfPosition(Long boId, Date effectDate) {
        Date now = new Date();
        if (effectDate == null || effectDate.after(now)) {
            effectDate = now;
        }
        Map<String, Object> positionHis = IParttimeAdminOrgExternalService.getInstance().invokeQueryPositionHis(Collections.singletonList(boId), effectDate);
        Object data = positionHis.get("data");
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        if (data == null) {
            return map;
        }
        List hisData = (List)((Map)data).get("hisdata");
        if (hisData != null && hisData.size() > 0) {
            map.put("vid", (Long)((Map)hisData.get(0)).get("id"));
            map.put("job", (Long)((Map)hisData.get(0)).get("job"));
            map.put("jobVid", (Long)((Map)hisData.get(0)).get("job"));
        }
        return map;
    }

    @Override
    public Map<String, Long> getJobHisOfStdPosition(Long boId, Date effectDate) {
        Date now = new Date();
        if (effectDate == null || effectDate.after(now)) {
            effectDate = now;
        }
        Map<String, Object> positionHis = IParttimeAdminOrgExternalService.getInstance().invokeQueryStdPosition(Collections.singletonList(boId), effectDate);
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        Object data = positionHis.get("data");
        if (data != null) {
            List list = (List)data;
            Map hisStdPositionMap = (Map)list.get(0);
            map.put("vid", (Long)hisStdPositionMap.get("id"));
            map.put("jobVid", (Long)hisStdPositionMap.get("job.id"));
        }
        return map;
    }

    @Override
    public void changeBoIdToVId(DynamicObject effectBill) {
        Date effectDate = effectBill.getDate("effectdate");
        String posType = effectBill.getString("apositiontype");
        DynamicObject job = effectBill.getDynamicObject("bjob");
        DynamicObject position = effectBill.getDynamicObject("aposition");
        DynamicObject stdPosition = effectBill.getDynamicObject("astdposition");
        if (PosTypeEnum.JOB.getCode().equals(posType)) {
            Map<String, Long> hisJobMap = this.getNewHisJob(job.getLong("boid"), effectDate);
            effectBill.set("bjob", (Object)hisJobMap.get("jobVid"));
        } else if (PosTypeEnum.POS.getCode().equals(posType)) {
            long boId = position.getLong("boid");
            Map<String, Long> posAndJob = this.getJobHisOfPosition(boId, effectDate);
            Long newHisJobId = posAndJob.get("jobVid");
            effectBill.set("bjob", (Object)newHisJobId);
            effectBill.set("aposition", (Object)posAndJob.get("vid"));
        } else if (PosTypeEnum.STD_POS.getCode().equals(posType)) {
            long boId = stdPosition.getLong("boid");
            Map<String, Long> posAndJob = this.getJobHisOfStdPosition(boId, effectDate);
            Long newHisJobId = posAndJob.get("jobVid");
            effectBill.set("bjob", (Object)newHisJobId);
            effectBill.set("astdposition", (Object)posAndJob.get("vid"));
        }
    }

    @Override
    public void changeToBoId(DynamicObject partBill) {
        try {
            if (PosTypeEnum.POS.getCode().equals(partBill.getString("apositiontype"))) {
                DynamicObject position = partBill.getDynamicObject("aposition");
                partBill.set("aposition", (Object)position.getLong("boid"));
                partBill.set("bjob", (Object)position.getLong("job_id"));
            } else if (PosTypeEnum.JOB.getCode().equals(partBill.getString("apositiontype"))) {
                DynamicObject job = partBill.getDynamicObject("bjob");
                partBill.set("bjob", (Object)job.getLong("boid"));
            } else if (PosTypeEnum.STD_POS.getCode().equals(partBill.getString("apositiontype"))) {
                DynamicObject standardPosition = partBill.getDynamicObject("astdposition");
                partBill.set("astdposition", (Object)standardPosition.getLong("boid"));
                partBill.set("bjob", (Object)standardPosition.getLong("job.id"));
            }
        }
        catch (Exception e) {
            LOGGER.error("changeToBoId error billid:", (Object)partBill.getLong("id"));
            LOGGER.error("changeToBoId error:", (Throwable)e);
        }
    }

    @Override
    public void changeToBoId(DynamicObject[] partBills) {
        Arrays.stream(partBills).forEach(this::changeToBoId);
    }

    @Override
    public List<Map<String, Object>> createReqList(DynamicObject[] effectBills) {
        ArrayList reqList = Lists.newArrayListWithExpectedSize((int)effectBills.length);
        Arrays.stream(effectBills).filter(bill -> PosTypeEnum.JOB.getCode().equals(bill.getString("apositiontype")) || PosTypeEnum.STD_POS.getCode().equals(bill.getString("apositiontype"))).forEach(bill -> {
            try {
                HashMap<String, Object> detail = new HashMap<String, Object>(16);
                detail.put("org", bill.getLong("aadminorg_id"));
                String positionType = bill.getString("apositiontype");
                if (PosTypeEnum.JOB.getCode().equals(positionType)) {
                    detail.put("job", bill.getDynamicObject("bjob").get("boid"));
                } else {
                    detail.put("standardposition", bill.getDynamicObject("astdposition").get("boid"));
                }
                detail.put("effect", bill.getDate("effectdate"));
                detail.put("user", bill.getLong("person_id"));
                reqList.add(detail);
            }
            catch (Exception exception) {
                LOGGER.error("error billNo is:", (Object)bill.getString("billno"));
                LOGGER.error("createReqList error:", (Throwable)exception);
            }
        });
        return reqList;
    }

    @Override
    public void fillTheDarkPosition(DynamicObject[] effectBills, Map<String, Object> darkPosition) {
        if (null == darkPosition || darkPosition.size() == 0) {
            return;
        }
        Integer code = (Integer)darkPosition.get("code");
        if (!DARKPOSITION_SUCCESS.equals(code)) {
            LOGGER.error(MessageFormat.format("addDarkPositionByJob failed , the error msg : %s", darkPosition.get("ErrMsg")));
            return;
        }
        List details = (List)darkPosition.get("data");
        HashMap mapGroupByUser = Maps.newHashMapWithExpectedSize((int)details.size());
        for (Map map : details) {
            if (!((Boolean)map.get("isSuccess")).booleanValue()) continue;
            long user = (Long)map.get("user");
            Map positionMap = mapGroupByUser.putIfAbsent(user, new HashMap());
            if (positionMap == null) {
                positionMap = Maps.newHashMapWithExpectedSize((int)details.size());
            }
            String org = map.get("org").toString();
            if (map.get("standardposition") != null) {
                positionMap.put(org + map.get("standardposition"), map);
            }
            if (map.get("job") != null) {
                positionMap.put(org + map.get("job"), map);
            }
            mapGroupByUser.put(user, positionMap);
        }
        if (mapGroupByUser.size() == 0) {
            LOGGER.info("get dark position all failed ... ");
            return;
        }
        Arrays.stream(effectBills).filter(temp -> PosTypeEnum.JOB.getCode().equals(temp.getString("apositiontype")) || PosTypeEnum.STD_POS.getCode().equals(temp.getString("apositiontype"))).forEach(bill -> {
            long personId = bill.getLong("person_id");
            Map positionMap = (Map)mapGroupByUser.get(personId);
            if (positionMap != null) {
                String org = bill.getString("aadminorg_id");
                Map detailMap = (Map)positionMap.get(org + bill.getLong("bjob.boid"));
                if (detailMap == null) {
                    detailMap = (Map)positionMap.get(org + bill.getLong("astdposition.boid"));
                }
                if (detailMap != null && positionMap.size() > 0) {
                    bill.set("aposition", detailMap.get("position"));
                    if (PosTypeEnum.JOB.getCode().equals(bill.getString("apositiontype"))) {
                        bill.set("astdposition", detailMap.get("standardposition"));
                    }
                }
            }
        });
    }

    @Override
    public void update(DynamicObject partBill) {
        ParttimeApplyRepository.getInstance().update(partBill);
    }

    @Override
    public Map<Long, List<Long>> invokeGetSuperiorByRole(List<Long> roleIds) {
        LOGGER.info("start PartimeBillServiceImpl invokeGetSuperiorByRole param: {}", roleIds);
        Map<Long, List<Map<String, Object>>> map = PersonExternalService.getInstance().listSuperiorByOrg(roleIds);
        if (map == null || map.size() == 0) {
            LOGGER.error("PartimeBillServiceImpl invokeGetSuperiorByRole result is null");
            return new HashMap<Long, List<Long>>();
        }
        LOGGER.info("end PartimeBillServiceImpl invokeGetSuperiorByRole result : {}", map);
        HashMap<Long, List<Long>> superiorMap = new HashMap<Long, List<Long>>(map.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entry : map.entrySet()) {
            List<Map<String, Object>> values = entry.getValue();
            if (values == null || values.size() <= 0) continue;
            List personIdList = values.stream().map(temp -> (Long)temp.get("person.id")).collect(Collectors.toList());
            superiorMap.put(entry.getKey(), personIdList);
        }
        return superiorMap;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getLeaderByRuleFromHRPI(List<Map<String, Object>> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"listSuperior", (Object[])new Object[]{paramList});
    }

    @Override
    public List<Long> getOrgChargers(List<Long> orgIds) {
        LOGGER.info("start PartimeBillServiceImpl invokeGetMainChargeInfoByOrg param: {}", orgIds);
        List<Map<String, Object>> maps = PersonExternalService.getInstance().invokeGetMainChargeInfoByOrg(orgIds);
        if (null == maps || maps.size() == 0) {
            LOGGER.error("PartimeBillServiceImpl invokeGetMainChargeInfoByOrg result is null");
            return new ArrayList<Long>();
        }
        LOGGER.info("end PartimeBillServiceImpl invokeGetMainChargeInfoByOrg result : {}", maps);
        return maps.stream().map(temp -> (Long)temp.get("person")).collect(Collectors.toList());
    }

    @Override
    public DynamicObject[] auditPassEvent(DynamicObject[] bills) {
        ArrayList<DynamicObject> effectBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject bill2 : bills) {
            Date effectDate = bill2.getDate("effectdate");
            if (!HRDateTimeUtils.dayAfter((Date)new Date(), (Date)effectDate) && !HRDateTimeUtils.dayEquals((Date)new Date(), (Date)effectDate)) continue;
            effectBills.add(bill2);
        }
        List<DynamicObject> discardBills = ParttimeServiceHelper.getDiscardBills(effectBills);
        DynamicObject[] effectiveBillArr = (DynamicObject[])effectBills.stream().filter(bill -> !discardBills.contains(bill)).toArray(DynamicObject[]::new);
        List<Map<String, Object>> reqList = this.createReqList(effectiveBillArr);
        if (null != reqList && reqList.size() > 0) {
            ArrayList<Map<String, Object>> bJobReqList = new ArrayList<Map<String, Object>>(reqList.size());
            ArrayList<Map<String, Object>> stdPositionReqList = new ArrayList<Map<String, Object>>(reqList.size());
            for (Map<String, Object> map : reqList) {
                if (map.get("job") != null) {
                    bJobReqList.add(map);
                }
                if (map.get("standardposition") == null) continue;
                stdPositionReqList.add(map);
            }
            if (bJobReqList.size() > 0) {
                Map<String, Object> darkPositionByJob = IJobExternalService.getInstance().getDarkPositionByJob(bJobReqList);
                this.fillTheDarkPosition(effectiveBillArr, darkPositionByJob);
            }
            if (stdPositionReqList.size() > 0) {
                Map<String, Object> darkPositionByStdPosition = PositionExternalService.getInstance().invokerAddDarkPosition(stdPositionReqList);
                this.fillTheDarkPosition(effectiveBillArr, darkPositionByStdPosition);
            }
        }
        this.changeToBoId(effectiveBillArr);
        ParttimeApplyRepository.getInstance().update(bills);
        return effectiveBillArr;
    }

    @Override
    public Map<String, Long> getNewHisJob(Long boId, Date effectDate) {
        Date now = new Date();
        if (effectDate == null || effectDate.after(now)) {
            effectDate = now;
        }
        Map<String, Object> hisJobMap = IJobExternalService.getInstance().selectJobHisInfo(Collections.singletonList(boId), effectDate);
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        if (hisJobMap == null) {
            return map;
        }
        List data = (List)hisJobMap.get("data");
        if (data != null && data.size() > 0) {
            Long vJobId = Long.valueOf((String)((Map)data.get(0)).get("id"));
            map.put("jobVid", vJobId);
        }
        return map;
    }

    private void dealQuit(DynamicObject parttimeApplyBill, Object alaborrelstatusId) {
        String billStatus = parttimeApplyBill.getString("billstatus");
        LOGGER.info("dealQuit begin: the billId is : [{}], the auditStatus is : [{}]", (Object)parttimeApplyBill.getString("id"), (Object)billStatus);
        switch (billStatus) {
            case "B": 
            case "D": 
            case "G": {
                this.invokerDiscard(parttimeApplyBill.get("id"));
                parttimeApplyBill.set("billstatus", (Object)"F");
                break;
            }
            case "C": {
                if (!"0".equals(parttimeApplyBill.getString("parttimestatus"))) break;
                parttimeApplyBill.set("parttimestatus", (Object)"-1");
                parttimeApplyBill.set("auditstatus", (Object)"F");
                break;
            }
            case "A": {
                parttimeApplyBill.set("blaborrelstatus", alaborrelstatusId);
                parttimeApplyBill.set("billstatus", (Object)"F");
                parttimeApplyBill.set("auditstatus", (Object)"F");
                parttimeApplyBill.set("parttimestatus", (Object)"-1");
                break;
            }
        }
    }

    private void invokerDiscard(Object billId) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isListViewOp4Mutex", String.valueOf(false));
        operateOption.setVariableValue("bos_support_bigdata_aysn", String.valueOf(true));
        operateOption.setVariableValue("SpecialDataPerm_CurrentAppId", "hdm");
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        try {
            Object result = DispatchServiceHelper.invokeBOSService((String)"hdm", (String)OperationService.class.getSimpleName(), (String)"invokeOperation", (Object[])new Object[]{"discard", "hdm_parttimeapplybill", new Object[]{billId}, operateOption});
            LOGGER.info("abandonWorkFlow end , the billId is :[{}], invoker result is : [{}]", billId, result);
        }
        catch (Exception exception) {
            LOGGER.info("abandonWorkFlow error, the exception msg is :[{}]", (Object)exception);
        }
    }

    private boolean validateRequestParam(Map<String, Object> noticeInfo) {
        return !ObjectUtils.isEmpty(noticeInfo) && !ObjectUtils.isEmpty((Object)noticeInfo.get(PARAM_EMPLOYEEID)) && !ObjectUtils.isEmpty((Object)noticeInfo.get(PARAM_LABORRELSTATUSID));
    }

    private Map<String, Object> buildResult(Boolean isSuccess, String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(RESULT_SUCCESS, isSuccess);
        result.put(RESULT_MESSAGE, msg);
        return result;
    }

    @Override
    public void beforeValidateUnSubmit(AbstractFormPlugin formPlugin, BeforeDoOperationEventArgs args, String billStatus) {
        if (!"B".equals(billStatus) && !"D".equals(billStatus)) {
            ParttimeStatusHandler billStatusStr = ParttimeStatusHandler.getInstance((String)billStatus);
            if (billStatusStr != null) {
                billStatus = billStatusStr.localString();
            }
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u5f53\u524d\u5355\u636e\u4e3a\u201c%s\u201d\uff0c\u4e0d\u80fd\u64a4\u9500\u3002", (String)"PartimeBillServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[]{billStatus}));
            args.setCancel(true);
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)formPlugin);
            String confirmTip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PartimeBillServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]);
            formPlugin.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
        }
    }
}

