/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.parttime.repository.ParttimeBatchRepository;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.ValidateContext;
import kd.hr.hdm.common.parttime.enums.PartTimeStatusEnum;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import org.apache.commons.lang3.time.StopWatch;

public class BatchParttimeValidateHelper {
    private static final BatchParttimeValidateHelper INSTANCE = new BatchParttimeValidateHelper();
    private static final Log LOGGER = LogFactory.getLog(BatchParttimeValidateHelper.class);
    private static final long PARTTIME_TYPE = 1020L;
    private static final String VALID = "1";

    public static BatchParttimeValidateHelper getInstance() {
        return INSTANCE;
    }

    public void saveValidate(DynamicObject batchParttimeBill, List<DataValidate<DynamicObject>> dataValidateList) {
        this.mustInputValidate(this.filterError(dataValidateList));
        ParttimeValidateHelper.listQuitValidate.accept(this.filterError(dataValidateList));
        ParttimeValidateHelper.listLicenseCheck.accept(this.filterError(dataValidateList));
        ParttimeValidateHelper.listErmanFileChangeValidate.accept(this.filterError(dataValidateList));
        ParttimeValidateHelper.listCrossValidate.accept(this.filterError(dataValidateList));
        BatchParttimeValidateHelper.validateRepeatPattimeBill(dataValidateList);
        this.entryHrbuValidate(batchParttimeBill, this.filterError(dataValidateList));
    }

    public Map<String, Object> buildOperateInfoByValResult(List<DataValidate<DynamicObject>> dataValidateList, TransferOperateTypeEnum operateTypeEnum) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Integer sumPerson = dataValidateList.size();
        Integer failPersoner = 0;
        Integer successPerson = 0;
        ArrayList detailExcelDataList = Lists.newArrayListWithExpectedSize((int)dataValidateList.size());
        Map<String, String> exportFieldMap = this.getExportFieldMap();
        for (DataValidate<DynamicObject> dataDiv : dataValidateList) {
            Integer n;
            Integer n2;
            ValidateContext validatorContext = dataDiv.getValidatorContext();
            if (ValidateRangeEnum.VALIDATE_ERROR == validatorContext.getRange()) {
                n2 = failPersoner;
                n = failPersoner = Integer.valueOf(failPersoner + 1);
            } else {
                n2 = successPerson;
                n = successPerson = Integer.valueOf(successPerson + 1);
            }
            detailExcelDataList.add(this.getDetailExcelData(dataDiv, exportFieldMap));
        }
        result.put("sumperson", sumPerson);
        result.put("failperson", failPersoner);
        result.put("successperson", successPerson);
        result.put("headDataList", this.getDetailExcelHead(exportFieldMap));
        result.put("exportDataList", detailExcelDataList);
        result.put("operatetype", operateTypeEnum.getType());
        return result;
    }

    private List<HRExportHeadObject> getDetailExcelHead(Map<String, String> exportFieldMap) {
        List<HRExportHeadObject> excelHeadList = exportFieldMap.entrySet().stream().map(entry -> new HRExportHeadObject((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        excelHeadList.add(new HRExportHeadObject("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"BatchTransferValidatorServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0])));
        excelHeadList.add(new HRExportHeadObject("errormsg", ResManager.loadKDString((String)"\u6821\u9a8c\u8bf4\u660e", (String)"BatchTransferValidatorServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0])));
        return excelHeadList;
    }

    private Map<String, Object> getDetailExcelData(DataValidate dataDiv, Map<String, String> exportFieldMap) {
        ValidateContext validatorContext = dataDiv.getValidatorContext();
        DynamicObject regBill = (DynamicObject)dataDiv.getData();
        HashMap<String, Object> data = new HashMap<String, Object>(32);
        exportFieldMap.forEach((key, value) -> {
            if ("apositiontype".equals(key)) {
                data.put("apositiontype", PosTypeEnum.getName((String)regBill.getString(key)));
            } else {
                this.putValueToMap((String)key).accept(regBill, data);
            }
        });
        if (ValidateRangeEnum.VALIDATE_ERROR == validatorContext.getRange()) {
            data.put("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25", (String)"BatchTransferValidatorServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]));
            data.put("errormsg", String.join((CharSequence)"\uff1b", validatorContext.getValidateResult().values()));
        } else {
            data.put("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u901a\u8fc7", (String)"BatchTransferValidatorServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]));
            data.put("errormsg", String.join((CharSequence)"\uff1b", validatorContext.getValidateResult().values()));
        }
        return data;
    }

    private BiConsumer<DynamicObject, Map<String, Object>> putValueToMap(String field) {
        return (dynamicObject, map) -> {
            Object value = dynamicObject.get(field);
            if (value == null) {
                return;
            }
            if (DynamicObject.class.equals(value.getClass())) {
                map.put(field, ((DynamicObject)value).getString("name"));
            } else if (Date.class.equals(value.getClass())) {
                map.put(field, HRDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd"));
            } else {
                map.put(field, value.toString());
            }
        };
    }

    private Map<String, String> getExportFieldMap() {
        LinkedHashMap<String, String> exportFieldMap = new LinkedHashMap<String, String>(16);
        exportFieldMap.put("partperson.person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"BatchRegValidateHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("partperson.person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"BatchRegValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("effectdate", ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f", (String)"BatchParttimeValidateHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("acompany.name", ResManager.loadKDString((String)"\u517c\u804c\u516c\u53f8", (String)"BatchParttimeValidateHelper_2", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("aadminorg.name", ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8", (String)"BatchParttimeValidateHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("apositiontype", ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f", (String)"BatchParttimeValidateHelper_4", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("aposition.name", ResManager.loadKDString((String)"\u517c\u804c\u5c97\u4f4d", (String)"BatchParttimeValidateHelper_5", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("astdposition.name", ResManager.loadKDString((String)"\u517c\u804c\u6807\u51c6\u5c97\u4f4d", (String)"BatchParttimeValidateHelper_6", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("bjob", ResManager.loadKDString((String)"\u517c\u804c\u804c\u4f4d", (String)"BatchParttimeValidateHelper_7", (String)"hr-hdm-business", (Object[])new Object[0]));
        return exportFieldMap;
    }

    public void entryHrbuValidate(DynamicObject batchParttimeBill, List<DataValidate<DynamicObject>> dataValidateList) {
        StopWatch stopWatch = new StopWatch("entryHrbuValidate");
        stopWatch.start();
        long batchgParttimeBillOrgId = batchParttimeBill.getLong("org.id");
        dataValidateList.stream().forEach(dataValidate -> {
            DynamicObject parttimeBill = (DynamicObject)dataValidate.getData();
            long personHrbu = parttimeBill.getLong("primaryhrbu.id");
            if (batchgParttimeBillOrgId != personHrbu) {
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "hrbu", ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u4e3b\u6863\u6848\u6240\u5c5e\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u5f53\u524d\u5355\u636e\u7684\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"BatchParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        });
        stopWatch.stop();
        LOGGER.info("entryHrbuValidate finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    public static void validateAffiliationOrg(BeforeDoOperationEventArgs args, AbstractFormPlugin formPlugin, DynamicObject batchPartBill, List<DynamicObject> partBillList) {
        StopWatch stopWatch = new StopWatch("validateAffiliationOrg");
        stopWatch.start();
        long affiliationOrgId = batchPartBill.getLong("affiliationord.id");
        for (DynamicObject partBill : partBillList) {
            long adminOrgId = partBill.getLong("adminorg.id");
            if (affiliationOrgId == adminOrgId) continue;
            FormOperate operate = (FormOperate)args.getSource();
            RefObject afterConfirm = new RefObject();
            if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) break;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)formPlugin);
            String confirmTip = ResManager.loadKDString((String)"\u5458\u5de5\u7684\u4e3b\u4efb\u804c\u90e8\u95e8\u4e0e\u5f53\u524d\u5355\u636e\u7684\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u518d\u6b21\u786e\u5b9a\u3002", (String)"BatchParttimeValidateHelper_8", (String)"hr-hdm-business", (Object[])new Object[0]);
            formPlugin.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
            break;
        }
        stopWatch.stop();
        LOGGER.info("validateAffiliationOrg finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private List<DataValidate<DynamicObject>> filterError(List<DataValidate<DynamicObject>> dataValidates) {
        return dataValidates.stream().filter(dataValidate -> ValidateRangeEnum.VALIDATE_PASS == dataValidate.getValidatorContext().getRange() || ValidateRangeEnum.VALIDATE_WARN == dataValidate.getValidatorContext().getRange()).collect(Collectors.toList());
    }

    public void mustInputValidate(List<DataValidate<DynamicObject>> dataValidateList) {
        dataValidateList.forEach(dataValidate -> {
            DynamicObject parttimeBill = (DynamicObject)dataValidate.getData();
            String positionType = (String)parttimeBill.get("apositiontype");
            String errorMsg = "";
            switch (positionType) {
                case "0": {
                    if (parttimeBill.get("astdposition") != null) break;
                    errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u51c6\u5c97\u4f4d\u201d\u3002", (String)"BatchParttimeValidateHelper_9", (String)"hr-hdm-business", (Object[])new Object[0]);
                    break;
                }
                case "1": {
                    if (parttimeBill.get("aposition") != null) break;
                    errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5c97\u4f4d\u201d\u3002", (String)"BatchParttimeValidateHelper_10", (String)"hr-hdm-business", (Object[])new Object[0]);
                    break;
                }
                case "2": {
                    if (parttimeBill.get("bjob") != null) break;
                    errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u804c\u4f4d\u201d\u3002", (String)"BatchParttimeValidateHelper_11", (String)"hr-hdm-business", (Object[])new Object[0]);
                    break;
                }
            }
            if (!HRStringUtils.isEmpty((String)errorMsg)) {
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "mustinput", errorMsg);
            }
        });
    }

    public static List<DataValidate<DynamicObject>> validateRepeatPattimeBill(List<DataValidate<DynamicObject>> dataValidateList) {
        Map<String, List<DynamicObject>> partFileMap;
        StopWatch stopWatch = new StopWatch("validateRepeatPattimeBill");
        stopWatch.start();
        HashSet<Long> erMainFileIds = new HashSet<Long>(dataValidateList.size());
        HashSet<Long> entryBillIds = new HashSet<Long>(dataValidateList.size());
        HashSet<Long> aadminorgIds = new HashSet<Long>(dataValidateList.size());
        Consumer<DataValidate> getIds = dataValidate -> {
            DynamicObject entryBill = (DynamicObject)dataValidate.getData();
            erMainFileIds.add(entryBill.getLong("partperson.id"));
            entryBillIds.add(entryBill.getLong("id"));
            aadminorgIds.add(entryBill.getLong("aadminorg_id"));
        };
        Map<String, List<DataValidate>> repeatRegBillMap = dataValidateList.stream().peek(getIds).collect(Collectors.groupingBy(temp -> {
            DynamicObject data = (DynamicObject)temp.getData();
            return BatchParttimeValidateHelper.getKey(data);
        }));
        Map<String, List<DynamicObject>> existBillMap = BatchParttimeValidateHelper.getExistBatchParttimeBills(erMainFileIds, entryBillIds, aadminorgIds);
        HashMap<Long, List<DataValidate<DynamicObject>>> errorMaps = new HashMap<Long, List<DataValidate<DynamicObject>>>(8);
        ArrayList<DataValidate<DynamicObject>> needQueryPartFiles = new ArrayList<DataValidate<DynamicObject>>(8);
        repeatRegBillMap.forEach((groupKey, dataValidates) -> {
            if (dataValidates.size() > 1) {
                dataValidates.forEach(temp -> temp.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "validateRepeatPattimeBill", String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u517c\u804c\u5458\u5de5\u4fe1\u606f\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\u201c%1$s\uff0c%2$s\u201d\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"BatchParttimeValidateHelper_12", (String)"hr-hdm-business", (Object[])new Object[0]), ((DynamicObject)temp.getData()).getString("partperson.number"), ((DynamicObject)temp.getData()).getString("partperson.name"))));
            } else {
                DataValidate dataValidate = (DataValidate)dataValidates.get(0);
                if (existBillMap.containsKey(groupKey)) {
                    List dynamicObjects = (List)existBillMap.get(groupKey);
                    HashSet<String> parttimestatusSet = new HashSet<String>(0);
                    for (DynamicObject existBill : dynamicObjects) {
                        String parttimestatus = existBill.getString("parttimestatus");
                        parttimestatusSet.add(parttimestatus);
                        long mid = existBill.getLong("mid");
                        if (!PartTimeStatusEnum.PROCESS.getCode().equals(parttimestatus)) continue;
                        BatchParttimeValidateHelper.setErrorInfo((DataValidate<DynamicObject>)dataValidate, mid, existBill, errorMaps);
                        break;
                    }
                    if (!parttimestatusSet.contains(PartTimeStatusEnum.PROCESS.getCode()) && parttimestatusSet.contains(PartTimeStatusEnum.ALREADY.getCode())) {
                        needQueryPartFiles.add(dataValidate);
                    }
                }
            }
        });
        if (!needQueryPartFiles.isEmpty() && (partFileMap = BatchParttimeValidateHelper.getPartTimeFiles(needQueryPartFiles)) != null) {
            for (DataValidate dataValidate2 : needQueryPartFiles) {
                Optional<DynamicObject> existBill;
                DynamicObject data = (DynamicObject)dataValidate2.getData();
                String key = BatchParttimeValidateHelper.getKey(data);
                if (!partFileMap.containsKey(key) || !(existBill = existBillMap.get(key).stream().filter(exist -> PartTimeStatusEnum.ALREADY.getCode().equals(exist.getString("parttimestatus"))).findFirst()).isPresent()) continue;
                long mid = existBill.get().getLong("mid");
                BatchParttimeValidateHelper.setErrorInfo((DataValidate<DynamicObject>)dataValidate2, mid, existBill.get(), errorMaps);
            }
        }
        if (!errorMaps.isEmpty()) {
            DynamicObject[] dys;
            for (DynamicObject dy : dys = ParttimeBatchRepository.getInstance().queryOriginalArray("billno, id", new QFilter("id", "in", errorMaps.keySet()).toArray())) {
                long mid = dy.getLong("id");
                List validates = (List)errorMaps.get(mid);
                validates.forEach(validate -> validate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c{0}\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c{1}\u201d\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{((DynamicObject)validate.getData()).getString("partperson.name"), dy.getString("billno")})));
            }
        }
        stopWatch.stop();
        LOGGER.info("filterError finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        return dataValidateList;
    }

    public static String getKey(DynamicObject data) {
        String apositiontype = data.getString("apositiontype");
        String key = data.getString("partperson.person.id") + apositiontype + data.getLong("aadminorg.boid");
        if (PosTypeEnum.POS.getCode().equals(apositiontype)) {
            return key + data.getLong("aposition.boid");
        }
        if (PosTypeEnum.STD_POS.getCode().equals(apositiontype)) {
            return key + data.getLong("astdposition.boid");
        }
        if (PosTypeEnum.JOB.getCode().equals(apositiontype)) {
            return key + data.getLong("bjob.boid");
        }
        return "";
    }

    public static Map<String, List<DynamicObject>> getPartTimeFiles(List<DataValidate<DynamicObject>> needQueryPartFiles) {
        HashSet<Long> adminorgs = new HashSet<Long>(needQueryPartFiles.size());
        Set<Long> personIds = needQueryPartFiles.stream().peek(va -> adminorgs.add(((DynamicObject)va.getData()).getLong("aadminorg_id"))).map(va -> ((DynamicObject)va.getData()).getLong("person_id")).collect(Collectors.toSet());
        return BatchParttimeValidateHelper.getPartFileMap(adminorgs, personIds);
    }

    public static Map<String, List<DynamicObject>> getPartFileMap(Set<Long> adminorgs, Set<Long> personIds) {
        String entityName;
        String partfileSelectFields = "person,adminorg,apositiontype,position,stdposition,job,postype,businessstatus";
        QFilter qFilters = new QFilter("person", "in", personIds).and(new QFilter("adminorg", "in", adminorgs)).and(new QFilter("postype", "=", (Object)1020L)).and(new QFilter("businessstatus", "=", (Object)VALID));
        DynamicObject[] fileObjs = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{partfileSelectFields, qFilters, entityName = "hrpi_empposorgrel"});
        if (fileObjs != null && fileObjs.length > 0) {
            Map<String, List<DynamicObject>> partFileMap = Arrays.stream(fileObjs).collect(Collectors.groupingBy(dy -> {
                String apositiontype = dy.getString("apositiontype");
                String key = dy.getString("person.id") + apositiontype + dy.getLong("adminorg.boid");
                if (PosTypeEnum.POS.getCode().equals(apositiontype)) {
                    return key + dy.getLong("position.boid");
                }
                if (PosTypeEnum.STD_POS.getCode().equals(apositiontype)) {
                    return key + dy.getLong("stdposition.boid");
                }
                if (PosTypeEnum.JOB.getCode().equals(apositiontype)) {
                    return key + dy.getLong("job.boid");
                }
                return "";
            }));
            return partFileMap;
        }
        return null;
    }

    public static void setErrorInfo(DataValidate<DynamicObject> dataValidate, long mid, DynamicObject existBill, Map<Long, List<DataValidate<DynamicObject>>> errorMaps) {
        if (mid == 0L) {
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c{0}\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c{1}\u201d\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{((DynamicObject)dataValidate.getData()).getString("partperson.name"), existBill.getString("billno")}));
        } else {
            List orDefault = errorMaps.getOrDefault(mid, new ArrayList());
            orDefault.add(dataValidate);
            errorMaps.put(mid, orDefault);
        }
    }

    public static Map<String, List<DynamicObject>> getExistBatchParttimeBills(Set<Long> erMainFileIds, Set<Long> entryBillIds, Set<Long> aadminorgIds) {
        QFilter billStatusFilter = new QFilter("billstatus", "not in", Arrays.asList("E", "F"));
        billStatusFilter.and(new QFilter("auditstatus", "!=", (Object)"F"));
        billStatusFilter.and(new QFilter("partperson", "in", erMainFileIds));
        billStatusFilter.and(new QFilter("aadminorg.boid", "in", aadminorgIds));
        if (entryBillIds != null && entryBillIds.size() > 0) {
            billStatusFilter.and(new QFilter("id", "not in", entryBillIds));
        }
        String selectFields = "partperson.id, partperson.name,billno,aadminorg, aadminorg.boid,apositiontype,aposition,astdposition,bjob,parttimestatus,aposition.boid,astdposition.boid,bjob.boid,effectdate,mid, person.boid";
        DynamicObject[] entryBills = ParttimeApplyRepository.getInstance().queryOriginalArray(selectFields, billStatusFilter.toArray());
        Map<String, List<DynamicObject>> existBillMap = Arrays.stream(entryBills).collect(Collectors.groupingBy(dy -> {
            String apositiontype = dy.getString("apositiontype");
            String key = dy.getString("person.boid") + apositiontype + dy.getLong("aadminorg.boid");
            if (PosTypeEnum.POS.getCode().equals(apositiontype)) {
                return key + dy.getLong("aposition.boid");
            }
            if (PosTypeEnum.STD_POS.getCode().equals(apositiontype)) {
                return key + dy.getLong("astdposition.boid");
            }
            if (PosTypeEnum.JOB.getCode().equals(apositiontype)) {
                return key + dy.getLong("bjob.boid");
            }
            return "";
        }));
        return existBillMap;
    }
}

