/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.validate;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.external.IParttimePersonService;
import kd.hr.hdm.business.domain.parttime.repository.ParttimeBatchRepository;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.enums.PartTimeCrossActionEnum;
import kd.hr.hdm.common.parttime.enums.PartTimeStatusEnum;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import org.apache.commons.lang3.time.StopWatch;

public class ParttimeValidateHelper {
    private static final Log LOGGER = LogFactory.getLog(ParttimeValidateHelper.class);
    private static final List<String> DISCARD_BILL_STATUS = Arrays.asList("E", "F");
    private static final String CHECK_REPEAT_SELECTFIELDS = "partperson,partperson.name,billno,aadminorg,apositiontype,aposition,astdposition,bjob,parttimestatus,aposition.boid,astdposition.boid,bjob.boid,effectdate,mid,person";
    private static final String SELECT_EMPPOS_PROPERTIES = "person,adminorg,apositiontype,position,stdposition,job,postype,businessstatus";
    private static final String HRPI_ERMANFILE_SELECT_PROPS = "employee";
    private static final String KEY_CROSSVALIDATERANGE = "crossValidNoti";
    private static final String KEY_BILLNOSOURCE = "billNoSource";
    private static final String VALID = "1";
    private static final long PARTTIME_TYPE = 1020L;
    private static final String QUERY_PART_SORT = "effectdate desc";
    public static Predicate<String> validateBillStatus = billStatus -> HRStringUtils.equals((String)billStatus, (String)"A") || HRStringUtils.equals((String)billStatus, (String)"G");
    public static Consumer<List<DataValidate<DynamicObject>>> listLicenseCheck = dataValidates -> {
        StopWatch stopWatch = new StopWatch("listLicenseCheck");
        stopWatch.start();
        List personIdList = dataValidates.stream().map(dataValidate -> {
            DynamicObject data = (DynamicObject)dataValidate.getData();
            return data.getLong("partperson.person.id");
        }).distinct().collect(Collectors.toList());
        try {
            Map personLicenseMap = HRCertValidateServiceHelper.checkPersonLicenses(personIdList);
            if (personLicenseMap == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"ParttimeValidateHelper_5", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            dataValidates.forEach(dataValidate -> {
                DynamicObject data = (DynamicObject)dataValidate.getData();
                long personId = data.getLong("partperson.person.id");
                Map personMap = (Map)personLicenseMap.get(personId);
                if (personMap != null && personMap.size() > 0 && !((Boolean)personMap.get("status")).booleanValue()) {
                    String name = (String)personMap.get("name");
                    String number = (String)personMap.get("number");
                    String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u517c\u804c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"ParttimeValidateHelper_6", (String)"hr-hdm-business", (Object[])new Object[0]), name, number);
                    dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("HRCertValidateServiceHelper checkPersonLicenses exception", (Throwable)e);
            throw new KDBizException("checkPersonLicenses exception,please contact the administrator");
        }
        stopWatch.stop();
        LOGGER.info("listPartPersonCheckRepeat finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    };
    public static Consumer<List<DataValidate<DynamicObject>>> listPartPersonCheckRepeat = dataValidates -> {
        StopWatch stopWatch = new StopWatch("listPartPersonCheckRepeat");
        stopWatch.start();
        List<DynamicObject> newPartBillList = dataValidates.stream().map(DataValidate::getData).collect(Collectors.toList());
        if (newPartBillList.size() == 0) {
            return;
        }
        DynamicObject[] queryPartBills = ParttimeValidateHelper.queryPartTimeBill(newPartBillList);
        if (queryPartBills == null || queryPartBills.length == 0) {
            return;
        }
        Map<String, Boolean> partTimeStatusRepeatMap = ParttimeValidateHelper.validatePartTimeRepeatByProcessStatus(newPartBillList, queryPartBills);
        DynamicObject[] queryPartTimeFiles = ParttimeValidateHelper.queryPartTimeFile(newPartBillList);
        Map<Long, Boolean> effectStatusRepeatMap = ParttimeValidateHelper.validatePartTimeRepeatByEffectStatus(newPartBillList, queryPartTimeFiles);
        HashMap<Long, DynamicObject> processPartBillMap = new HashMap<Long, DynamicObject>(queryPartBills.length);
        HashMap<Long, DynamicObject> alreadyPartBillMap = new HashMap<Long, DynamicObject>(queryPartBills.length);
        for (DynamicObject queryPartBill : queryPartBills) {
            String billNo = queryPartBill.getString("billno");
            if (null == partTimeStatusRepeatMap.get(billNo) || !partTimeStatusRepeatMap.get(billNo).booleanValue()) continue;
            long personId = queryPartBill.getLong("partperson.person.id");
            String partTimeStatus = queryPartBill.getString("parttimestatus");
            if (PartTimeStatusEnum.PROCESS.getCode().equals(partTimeStatus)) {
                processPartBillMap.put(personId, queryPartBill);
            }
            if (!PartTimeStatusEnum.ALREADY.getCode().equals(partTimeStatus)) continue;
            alreadyPartBillMap.put(personId, queryPartBill);
        }
        Map<Long, String> billNoMap = ParttimeValidateHelper.getBillNo(queryPartBills);
        dataValidates.forEach(dataValidate -> {
            DynamicObject alreadyPartBill;
            DynamicObject partDynamicObject = (DynamicObject)dataValidate.getData();
            long personId = partDynamicObject.getLong("partperson.person.id");
            DynamicObject processPartBill = (DynamicObject)processPartBillMap.get(personId);
            if (processPartBill != null) {
                String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230{0}\u5f53\u524d\u6709\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c{1}\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{processPartBill.get("partperson.name"), billNoMap.get(processPartBill.getLong("id"))});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            }
            if ((alreadyPartBill = (DynamicObject)alreadyPartBillMap.get(personId)) != null && effectStatusRepeatMap.get(personId) != null) {
                String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230{0}\u5f53\u524d\u6709\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c{1}\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{alreadyPartBill.get("partperson.name"), billNoMap.get(alreadyPartBill.getLong("id"))});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            }
        });
        stopWatch.stop();
        LOGGER.info("listPartPersonCheckRepeat finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    };
    public static Predicate<DataValidate<DynamicObject>> singleCheckRepeat = dataValidate -> {
        DynamicObject[] existsDy = ParttimeValidateHelper.queryRepeatParttime((DynamicObject)dataValidate.getData());
        if (null != existsDy && existsDy.length > 0) {
            for (DynamicObject queryObj : existsDy) {
                if (!PartTimeStatusEnum.PROCESS.getCode().equals(queryObj.getString("parttimestatus"))) continue;
                String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230{0}\u5f53\u524d\u6709\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c{1}\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{queryObj.get("partperson.name"), ParttimeValidateHelper.getProcessBillNo(queryObj)});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
                return false;
            }
            DynamicObject[] fileObjs = ParttimeValidateHelper.getAllPartTimeFile((DynamicObject)dataValidate.getData());
            if (null != fileObjs && fileObjs.length == 1) {
                DynamicObject effectObj = Arrays.stream(existsDy).filter(dynamicObject -> PartTimeStatusEnum.ALREADY.getCode().equals(dynamicObject.getString("parttimestatus"))).max((a, b) -> {
                    if (a.getDate("effectdate").after(b.getDate("effectdate"))) {
                        return 1;
                    }
                    return -1;
                }).get();
                String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230{0}\u5f53\u524d\u6709\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c{1}\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{effectObj.get("partperson.name"), ParttimeValidateHelper.getProcessBillNo(effectObj)});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
                return false;
            }
            return true;
        }
        return true;
    };
    public static Predicate<ExtendedDataEntity> filterBillStatus = dataEntity -> {
        DynamicObject partBill = dataEntity.getDataEntity();
        String status = partBill.getString("billstatus");
        return validateBillStatus.test(status);
    };
    public static Predicate<DataValidate<DynamicObject>> crossValidate = dataValidate -> {
        DynamicObject partBill = (DynamicObject)dataValidate.getData();
        List<Map<String, Object>> crossList = PerChgBizUtils.singleCrossValidate(partBill);
        return PerChgBizUtils.dealCrossValidate(crossList, (DataValidate<DynamicObject>)dataValidate);
    };
    public static Consumer<List<DataValidate<DynamicObject>>> listCrossValidate = dataValidates -> {
        if (ObjectUtils.isEmpty((Collection)dataValidates)) {
            return;
        }
        String billnoField = ParttimeValidateHelper.isEntryParttime((DynamicObject)((DataValidate)dataValidates.get(0)).getData()) ? "ebillno" : "billno";
        Map depempMap = dataValidates.stream().collect(Collectors.groupingBy(dataValidate -> {
            DynamicObject ermanFile = ((DynamicObject)dataValidate.getData()).getDynamicObject("partperson");
            return ermanFile.getLong("depemp.id");
        }, Collectors.toMap(dataValidate -> ((DynamicObject)dataValidate.getData()).getString(billnoField), Function.identity())));
        List<DynamicObject> parttimeBills = dataValidates.stream().map(DataValidate::getData).collect(Collectors.toList());
        Map<Long, List<Map<String, Object>>> resultMap = PerChgBizUtils.batchCrossValidate(parttimeBills);
        for (Map.Entry<Long, List<Map<String, Object>>> result : resultMap.entrySet()) {
            if (ObjectUtils.isEmpty(result.getValue())) continue;
            List<Map<String, Object>> crossList = result.getValue();
            Map<String, List<Map>> crossMap = crossList.stream().collect(Collectors.groupingBy(cross -> String.valueOf(cross.get(KEY_BILLNOSOURCE))));
            Long depempId = result.getKey();
            Map validateMap = depempMap.get(depempId);
            for (Map.Entry<String, List<Map>> cross2 : crossMap.entrySet()) {
                List<Map<String, Object>> crossValidateList = cross2.getValue();
                DataValidate dataValidate2 = (DataValidate)validateMap.get(cross2.getKey().toString());
                if (ObjectUtils.isEmpty(crossValidateList) || ObjectUtils.isEmpty((Object)dataValidate2)) continue;
                PerChgBizUtils.dealCrossValidate(crossValidateList, (DataValidate<DynamicObject>)dataValidate2);
            }
        }
    };
    public static Predicate<DataValidate<DynamicObject>> ermanfFileChangeValidate = dataValidate -> {
        DynamicObject partBill = (DynamicObject)dataValidate.getData();
        long personId = partBill.getLong("person.id");
        DynamicObject currentErmanfFile = HRServiceUtil.getPrimaryErmanFile((Long)personId);
        if (currentErmanfFile == null) {
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"ParttimeValidateHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]));
            return false;
        }
        String currentFileId = currentErmanfFile.getString("id");
        String snapshotFileId = partBill.getString("partperson.id");
        if (!HRStringUtils.equals((String)snapshotFileId, (String)currentFileId)) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e3b\u4efb\u804c\u4fe1\u606f\u5df2\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"ParttimeValidateHelper_4", (String)"hr-hdm-business", (Object[])new Object[0]);
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            return false;
        }
        return true;
    };
    public static Consumer<List<DataValidate<DynamicObject>>> listErmanFileChangeValidate = dataValidates -> {
        StopWatch stopWatch = new StopWatch("listErmanfFileChangeValidate");
        stopWatch.start();
        List<Long> employeeIdList = dataValidates.stream().map(dataValidate -> ((DynamicObject)dataValidate.getData()).getLong("partperson.employee.id")).distinct().collect(Collectors.toList());
        Map<Long, Long> currentErmanFileIdMap = ParttimeValidateHelper.getCurrentErmanFileIdMap(employeeIdList);
        dataValidates.stream().forEach(dataValidate -> {
            DynamicObject partBill = (DynamicObject)dataValidate.getData();
            long employeeId = partBill.getLong("partperson.employee.id");
            Long currentFileId = (Long)currentErmanFileIdMap.get(employeeId);
            Long snapshotFileId = partBill.getLong("partperson.id");
            if (!snapshotFileId.equals(currentFileId)) {
                String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e3b\u4efb\u804c\u4fe1\u606f\u5df2\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"ParttimeValidateHelper_4", (String)"hr-hdm-business", (Object[])new Object[0]);
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            }
        });
        stopWatch.stop();
        LOGGER.info("listErmanFileChangeValidate finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    };
    public static Predicate<DataValidate<DynamicObject>> quitValidate = dataValidate -> {
        DynamicObject partBill = (DynamicObject)dataValidate.getData();
        DynamicObject ermanFile = partBill.getDynamicObject("partperson");
        boolean isQuit = PersonnelChangeServiceHelper.isQuit(ermanFile.getLong("employee.id"));
        if (isQuit) {
            String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"ParttimeValidateHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]);
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            return false;
        }
        return true;
    };
    public static Consumer<List<DataValidate<DynamicObject>>> listQuitValidate = dataValidates -> {
        StopWatch stopWatch = new StopWatch("listQuitValidate");
        stopWatch.start();
        List<Long> employeeIds = dataValidates.stream().map(dataValidate -> {
            DynamicObject ermanFile = ((DynamicObject)dataValidate.getData()).getDynamicObject("partperson");
            return ermanFile.getLong("employee.id");
        }).collect(Collectors.toList());
        Map<Long, DynamicObject> employeeStatusMap = IParttimePersonService.getInstance().getEmployeeStatus(employeeIds);
        dataValidates.stream().forEach(dataValidate -> {
            DynamicObject partBill = (DynamicObject)dataValidate.getData();
            Long employeeId = partBill.getDynamicObject("partperson").getLong("employee.id");
            DynamicObject statusDy = (DynamicObject)employeeStatusMap.get(employeeId);
            if (LabRelConstants.QUIT.equals(statusDy.getLong("labrelstatuscls_id"))) {
                String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"ParttimeValidateHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]);
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            }
        });
        stopWatch.stop();
        LOGGER.info("listQuitValidate finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    };

    public static boolean illegalSubmitEffect(String operateKey, DynamicObject partTimeBill) {
        String billStatus = partTimeBill.getString("billstatus");
        String auditStatus = partTimeBill.getString("auditstatus");
        return HRStringUtils.equals((String)operateKey, (String)"submiteffect") && (!HRStringUtils.equals((String)billStatus, (String)"A") || !HRStringUtils.equals((String)auditStatus, (String)"A"));
    }

    private static DynamicObject[] queryPartTimeBill(List<DynamicObject> partBillList) {
        ArrayList fidList = new ArrayList(partBillList.size());
        ArrayList erMainFileIdList = new ArrayList(partBillList.size());
        partBillList.forEach(partBill -> {
            Object pkValue = partBill.getPkValue();
            if (pkValue != null) {
                fidList.add((Long)pkValue);
            }
            long erMainFileId = partBill.getLong("partperson.id");
            erMainFileIdList.add(erMainFileId);
        });
        QFilter idFilter = new QFilter("id", "not in", fidList);
        QFilter personFilter = new QFilter("partperson", "in", erMainFileIdList);
        QFilter billStatusFilter = new QFilter("billstatus", "not in", DISCARD_BILL_STATUS);
        QFilter auditStatusFilter = new QFilter("auditstatus", "!=", (Object)"F");
        QFilter statusFilter = billStatusFilter.and(auditStatusFilter);
        return ParttimeApplyRepository.getInstance().query(CHECK_REPEAT_SELECTFIELDS, new QFilter[]{statusFilter, personFilter, idFilter}, QUERY_PART_SORT);
    }

    private static DynamicObject[] queryPartTimeFile(List<DynamicObject> partBillList) {
        ArrayList personIdList = new ArrayList(partBillList.size());
        partBillList.forEach(partBill -> {
            long personId = partBill.getLong("partperson.person.id");
            personIdList.add(personId);
        });
        QFilter qFilters = new QFilter("person", "in", personIdList).and(new QFilter("postype", "=", (Object)1020L)).and(new QFilter("businessstatus", "=", (Object)VALID));
        String entityName = "hrpi_empposorgrel";
        return (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{SELECT_EMPPOS_PROPERTIES, qFilters, entityName});
    }

    public static Map<Long, String> getBillNo(DynamicObject[] queryPartBills) {
        HashMap billNoMap = Maps.newHashMapWithExpectedSize((int)queryPartBills.length);
        List<Long> midList = Arrays.stream(queryPartBills).filter(bill -> bill.getLong("mid") != 0L).map(bill -> bill.getLong("mid")).distinct().collect(Collectors.toList());
        Map<Object, Object> batchBillNoMap = Maps.newHashMapWithExpectedSize((int)queryPartBills.length);
        if (midList.size() > 0) {
            DynamicObject[] dys = ParttimeBatchRepository.getInstance().query("billno", midList);
            batchBillNoMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("billno"), (o, n) -> n));
        }
        for (DynamicObject bill2 : queryPartBills) {
            long mid = bill2.getLong("mid");
            long billId = bill2.getLong("id");
            String billNo = (String)batchBillNoMap.get(mid);
            if (HRStringUtils.isNotEmpty((String)billNo)) {
                billNoMap.put(billId, billNo);
                continue;
            }
            billNoMap.put(billId, bill2.getString("billno"));
        }
        return billNoMap;
    }

    public static Map<String, Boolean> validatePartTimeRepeatByProcessStatus(List<DynamicObject> newPartBillList, DynamicObject[] queryPartBills) {
        Map<Long, DynamicObject> newPartBillMap = newPartBillList.stream().collect(Collectors.toMap(partBill -> partBill.getLong("partperson.person.id"), partBill -> partBill, (n, o) -> n));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(queryPartBills.length);
        for (DynamicObject queryPartBill : queryPartBills) {
            boolean flag;
            String posType;
            long adminOrgId;
            long personId;
            DynamicObject newDynamicObject;
            String partTimeStatus = queryPartBill.getString("parttimestatus");
            if (PartTimeStatusEnum.TERMINATE.getCode().equals(partTimeStatus) || (newDynamicObject = newPartBillMap.get(personId = queryPartBill.getLong("partperson.person.id"))) == null || (adminOrgId = queryPartBill.getLong("aadminorg.id")) != newDynamicObject.getLong("aadminorg.id") || !(posType = queryPartBill.getString("apositiontype")).equals(newDynamicObject.getString("apositiontype")) || !(flag = ParttimeValidateHelper.compareAPositionByPosType(queryPartBill, newDynamicObject))) continue;
            String billNo = queryPartBill.getString("billno");
            map.put(billNo, Boolean.TRUE);
        }
        return map;
    }

    private static Map<Long, Boolean> validatePartTimeRepeatByEffectStatus(List<DynamicObject> newPartBillList, DynamicObject[] queryPartTimeFiles) {
        if (queryPartTimeFiles == null || queryPartTimeFiles.length == 0) {
            return new HashMap<Long, Boolean>();
        }
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(queryPartTimeFiles.length);
        Map<Long, DynamicObject> newPartBillMap = newPartBillList.stream().collect(Collectors.toMap(partBill -> partBill.getLong("partperson.person.id"), partBill -> partBill, (n, o) -> n));
        for (DynamicObject queryPartTimeFile : queryPartTimeFiles) {
            boolean flag;
            String aPositionType;
            long adminOrgId;
            long personId = queryPartTimeFile.getLong("person.id");
            DynamicObject newPartDynamicObject = newPartBillMap.get(personId);
            if (newPartDynamicObject == null || (adminOrgId = queryPartTimeFile.getLong("adminorg.id")) != newPartDynamicObject.getLong("aadminorg_id") || !(aPositionType = queryPartTimeFile.getString("apositiontype")).equals(newPartDynamicObject.getString("apositiontype")) || !(flag = ParttimeValidateHelper.comparePositionByPosType(queryPartTimeFile, newPartDynamicObject))) continue;
            map.put(personId, true);
        }
        return map;
    }

    private static boolean comparePositionByPosType(DynamicObject queryPartTimeFile, DynamicObject newPartDynamicObject) {
        String posType;
        boolean flag = false;
        switch (posType = newPartDynamicObject.getString("apositiontype")) {
            case "0": {
                long stdPositionBoId = newPartDynamicObject.getLong("astdposition.boid");
                if (stdPositionBoId != queryPartTimeFile.getLong("stdposition.id")) break;
                flag = true;
                break;
            }
            case "1": {
                long positionBoId = newPartDynamicObject.getLong("aposition.boid");
                if (positionBoId != queryPartTimeFile.getLong("position.id")) break;
                flag = true;
                break;
            }
            case "2": {
                long jobBoId = newPartDynamicObject.getLong("bjob.boid");
                if (jobBoId != queryPartTimeFile.getLong("job.id")) break;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean compareAPositionByPosType(DynamicObject queryPartBill, DynamicObject newPartDynamicObject) {
        String posType;
        boolean flag = false;
        switch (posType = queryPartBill.getString("apositiontype")) {
            case "0": {
                long stdPositionBoId = queryPartBill.getLong("astdposition.boid");
                if (stdPositionBoId != newPartDynamicObject.getLong("astdposition.boid")) break;
                flag = true;
                break;
            }
            case "1": {
                long positionBoId = queryPartBill.getLong("aposition.boid");
                if (positionBoId != newPartDynamicObject.getLong("aposition.boid")) break;
                flag = true;
                break;
            }
            case "2": {
                long jobBoId = queryPartBill.getLong("bjob.boid");
                if (jobBoId != newPartDynamicObject.getLong("bjob.boid")) break;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private static String getProcessBillNo(DynamicObject parttimeBill) {
        long fMid = parttimeBill.getLong("mid");
        if (fMid != 0L) {
            DynamicObject dy = ParttimeBatchRepository.getInstance().queryOne("billno", fMid);
            return dy.getString("billno");
        }
        return parttimeBill.getString("billno");
    }

    private static DynamicObject[] getAllPartTimeFile(DynamicObject data) {
        long personId = data.getLong("person_id");
        QFilter positionFilter = null;
        positionFilter = VALID.equals(data.getString("apositiontype")) ? new QFilter("position", "=", (Object)data.getDynamicObject("aposition").getLong("boid")) : ("2".equals(data.getString("apositiontype")) ? new QFilter("job", "=", (Object)data.getDynamicObject("bjob").getLong("boid")) : new QFilter("stdposition", "=", (Object)data.getDynamicObject("astdposition").getLong("boid")));
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)data.getLong("aadminorg_id"));
        QFilter qFilters = new QFilter("person", "=", (Object)personId).and(new QFilter("apositiontype", "=", (Object)data.getString("apositiontype"))).and(new QFilter("postype", "=", (Object)1020L)).and(new QFilter("businessstatus", "=", (Object)VALID)).and(positionFilter).and(orgFilter);
        String entityName = "hrpi_empposorgrel";
        return (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{SELECT_EMPPOS_PROPERTIES, qFilters, entityName});
    }

    public static DynamicObject[] queryRepeatParttime(DynamicObject partBill) {
        Long erMainFileId = partBill.getDynamicObject("partperson").getLong("id");
        QFilter billStatusFilter = new QFilter("billstatus", "not in", DISCARD_BILL_STATUS);
        QFilter auditStatusFilter = new QFilter("auditstatus", "!=", (Object)"F");
        QFilter statusFilter = billStatusFilter.and(auditStatusFilter);
        QFilter personFilter = new QFilter("partperson", "=", (Object)erMainFileId);
        QFilter idFilter = new QFilter("id", "!=", partBill.getPkValue());
        QFilter orgFilter = new QFilter("aadminorg", "=", (Object)partBill.getLong("aadminorg_id"));
        QFilter posTypeFilter = new QFilter("apositiontype", "=", (Object)partBill.getString("apositiontype"));
        String positionType = partBill.getString("apositiontype");
        QFilter positionFilter = null;
        switch (positionType) {
            case "0": {
                positionFilter = new QFilter("astdposition.boid", "=", (Object)partBill.getDynamicObject("astdposition").getLong("boid"));
                break;
            }
            case "1": {
                positionFilter = new QFilter("aposition.boid", "=", (Object)partBill.getDynamicObject("aposition").getLong("boid"));
                break;
            }
            case "2": {
                positionFilter = new QFilter("bjob.boid", "=", (Object)partBill.getDynamicObject("bjob").getLong("boid"));
                break;
            }
        }
        if (positionFilter == null) {
            throw new KDBizException("positionType is error");
        }
        return ParttimeApplyRepository.getInstance().query(CHECK_REPEAT_SELECTFIELDS, new QFilter[]{statusFilter, personFilter, positionFilter, idFilter, posTypeFilter, orgFilter}, null);
    }

    private static Map<Long, Long> getCurrentErmanFileIdMap(List<Long> employeeIdList) {
        DynamicObject[] primaryErmanFiles = HRServiceUtil.queryPrimaryErmanFile(employeeIdList, (String)HRPI_ERMANFILE_SELECT_PROPS);
        if (primaryErmanFiles == null || primaryErmanFiles.length < 1) {
            return new HashMap<Long, Long>();
        }
        HashMap<Long, Long> primaryErmanFileMap = new HashMap<Long, Long>(primaryErmanFiles.length);
        for (DynamicObject ermanFile : primaryErmanFiles) {
            long ermanFileId = ermanFile.getLong("id");
            primaryErmanFileMap.put(ermanFile.getLong("employee_id"), ermanFileId);
        }
        return primaryErmanFileMap;
    }

    public static boolean mustValidOp(OperateOption option, String operateKey) {
        return !ParttimeValidateHelper.getCallbackCheckFlag(option, operateKey) && (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"submiteffect"));
    }

    public static boolean getCallbackCheckFlag(OperateOption option, String operateKey) {
        RefObject callbackResult = new RefObject();
        option.tryGetVariableValue(operateKey, callbackResult);
        return HRStringUtils.equals((String)((String)callbackResult.getValue()), (String)"true");
    }

    public static boolean isEntryParttime(DynamicObject parttimeBill) {
        return "entryentity".equals(parttimeBill.getDataEntityType().toString());
    }

    @Deprecated
    public static String buildCrossWarnMessage(PartTimeCrossActionEnum actionEnum) {
        String warmMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u6709\u8fdb\u884c\u4e2d\u7684%s\u4e8b\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ParttimeValidateHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]), actionEnum.getName());
        return warmMsg;
    }

    @Deprecated
    public static String buildCrossBanMessage(PartTimeCrossActionEnum actionEnum, String personName, String crossBillNo) {
        String errMsg = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5df2\u53d1\u751f\u201c%2$s\u201d\u4e8b\u52a1\u201c%3$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u517c\u804c\u3002", (String)"ParttimeValidateHelper_8", (String)"hr-hdm-business", (Object[])new Object[0]), personName, actionEnum.getName(), crossBillNo);
        return errMsg;
    }

    public static class CrossRangeComparator
    implements Comparator<Map<String, Object>> {
        @Override
        public int compare(Map<String, Object> cross1, Map<String, Object> cross2) {
            Integer range1 = Integer.valueOf((String)cross1.get(ParttimeValidateHelper.KEY_CROSSVALIDATERANGE));
            Integer range2 = Integer.valueOf((String)cross2.get(ParttimeValidateHelper.KEY_CROSSVALIDATERANGE));
            return range2 - range1;
        }
    }
}

