/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.service.hrpi.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;

public class IHRPIServiceImpl
implements IHRPIService {
    private static final Log LOGGER = LogFactory.getLog(IHRPIServiceImpl.class);

    @Override
    public List<Map<String, Object>> getTutorByEmployeeId(Long employeeId) {
        LOGGER.info("getTutorByEmployeeId employeeId:{}", (Object)employeeId);
        try {
            List result = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{Collections.singletonList(employeeId), "tutor.name,tutor.headsculpture,tutor_id", "hrpi_emptutor"});
            LOGGER.info("getTutorByEmployeeId result:{}", (Object)JSON.toJSONString((Object)result));
            return result.stream().filter(item -> (Long)item.get("tutor_id") != 0L).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("getTutorByEmployeeId error", (Throwable)e);
            return new ArrayList<Map<String, Object>>();
        }
    }

    @Override
    public Map<Long, List<String>> getTutorByEmployeeIds(List<Long> employeeIds) {
        LOGGER.info("getTutorByEmployeeIds employeeIds:{}", employeeIds);
        try {
            List result = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{employeeIds, "tutor.number,tutor_id,employee_id", "hrpi_emptutor"});
            LOGGER.info("getTutorByEmployeeId result:{}", (Object)JSON.toJSONString((Object)result));
            return result.stream().filter(item -> (Long)item.get("tutor_id") != 0L).collect(Collectors.groupingBy(item -> (Long)item.get("employee_id"), Collectors.mapping(item -> (String)item.get("tutor.number"), Collectors.toList())));
        }
        catch (Exception e) {
            LOGGER.error("getTutorByEmployeeId error", (Throwable)e);
            return new HashMap<Long, List<String>>();
        }
    }

    @Override
    public DynamicObject[] listFieldsFilterInfo(String selectFields, QFilter customFilter, String entityName) {
        return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectFields, customFilter, entityName});
    }

    @Override
    public DynamicObject[] listInfoById(List<Long> ids, String entityName) {
        return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfoById", (Object[])new Object[]{ids, entityName});
    }

    @Override
    public Map<Long, DynamicObject> queryPrimaryErManFileByPersonIds(String[] selectProperties, List<Long> personIds) {
        QFilter filter = new QFilter("person.id", "in", personIds).and(new QFilter("businessstatus", "=", (Object)"1")).and(new QFilter("empposrel.isprimary", "=", (Object)"1").and(new QFilter("empentrel.labrelstatusprd", "=", (Object)1010L)));
        DynamicObject[] erManFiles = this.listFieldsFilterInfo(String.join((CharSequence)",", selectProperties), filter, "hspm_ermanfile");
        if (erManFiles.length == 0) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(erManFiles).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy, (v1, v2) -> v2));
    }
}

