/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.service.hssc.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;

public class IHSSCServiceImpl
implements IHSSCService {
    private static final Log LOGGER = LogFactory.getLog(IHSSCServiceImpl.class);

    @Override
    public void terminateSSCTask(DynamicObject hdmBill) {
        boolean openhrssc = HRBaseDataConfigUtil.getOpenhrssc();
        if (!openhrssc) {
            LOGGER.warn("hdm-terminateSSCTask, openhrssc is false.");
            return;
        }
        String entityNumber = hdmBill.getDataEntityType().getName();
        Long id = (Long)hdmBill.getPkValue();
        HashMap billIdMap = new HashMap(1);
        billIdMap.put(id, new HashMap(1));
        Long userId = UserServiceHelper.getCurrentUserId();
        HashMap<String, Long> paramMap = new HashMap<String, Long>(1);
        paramMap.put("operatorId", userId);
        LOGGER.info("hdm-terminateSSCTask begin, entityNumber:{}, billIdMap:{}, paramMap:{}", new Object[]{entityNumber, billIdMap, paramMap});
        if ("hdm_transferbasebill".equals(entityNumber)) {
            List transferEntityNumbers = Stream.of("hdm_transferapply", "hdm_transferinbill", "hdm_transferoutbill", "hdm_mytransferbill").collect(Collectors.toList());
            for (String transferEntityNumber : transferEntityNumbers) {
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"hstc", (String)"ITaskService", (String)"terminateOrDeleteTask", (Object[])new Object[]{transferEntityNumber, billIdMap, paramMap});
                LOGGER.info("hdm-terminateSSCTask-basebill, resultMap:{}", (Object)resultMap);
            }
        } else {
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"hstc", (String)"ITaskService", (String)"terminateOrDeleteTask", (Object[])new Object[]{entityNumber, billIdMap, paramMap});
            LOGGER.info("hdm-terminateSSCTask end, resultMap:{}", (Object)resultMap);
        }
    }
}

