/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.JobImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.PositionImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.StpositionImportHandler;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;

public class EvaluationJobImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(EvaluationJobImportHandler.class);
    private final Set<String> evaluationJobList = new HashSet<String>(0);
    private final Map<String, Long> evaluationJobMap = new HashMap<String, Long>(0);
    private final Map<Long, Map<String, Object>> jobGradeScmInfoMap = new HashMap<Long, Map<String, Object>>(0);
    private final Map<Long, String> jobClassInfoMap = new HashMap<Long, String>(0);
    private final Map<Long, Long> jobIdAndCrateOrgIdMap = new HashMap<Long, Long>(0);
    private final Map<Long, Long> jobIdAndJobGradeScmIdMap = new HashMap<Long, Long>(0);
    private final Map<Long, Long> jobIdAndJobLevelScmIdMap = new HashMap<Long, Long>(0);
    private final Map<Long, List<Long>> jobIdAndJobLevelRangeMap = new HashMap<Long, List<Long>>(0);
    private final Map<Long, List<Long>> jobIdAndJobGradeRangeMap = new HashMap<Long, List<Long>>(0);
    private static final String ERROR_SCENE = "evaluationJobNumber2Id";

    public EvaluationJobImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        String number = this.getJsonBaseDataDyNumber(jsonObject, "aevaluationjob");
        if (HRStringUtils.isNotEmpty((String)number)) {
            this.evaluationJobList.add(number);
        }
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                Map<String, Object> jobHisInfoMap;
                Map<Long, Map<String, Object>> jobLevelResult;
                LOGGER.info("start EvaluationJobImportHandler listAllIdByNumber");
                JobExternalService jobExternalService = JobExternalService.getInstance();
                if (!this.evaluationJobList.isEmpty()) {
                    Map<String, Object> jobHisSimpleInfo = jobExternalService.invokeQueryJobHisSimpleInfo(new ArrayList<String>(this.evaluationJobList), null);
                    if (jobHisSimpleInfo == null) {
                        LOGGER.warn("EvaluationJobImportHandler listAllIdByNumber jobHisSimpleInfo is null");
                        CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                        return copyOnWriteArrayList;
                    }
                    Object data = jobHisSimpleInfo.get("data");
                    if (data == null) {
                        LOGGER.warn("EvaluationJobImportHandler listAllIdByNumber data is null");
                        CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                        return copyOnWriteArrayList;
                    }
                    DynamicObjectCollection collection = (DynamicObjectCollection)data;
                    Map<String, Long> jobInfoMap = this.hisBaseDataToNumberBoIdGroupMap(collection);
                    this.evaluationJobMap.putAll(jobInfoMap);
                }
                ArrayList<Long> jobIds = new ArrayList<Long>(this.evaluationJobMap.values());
                PositionImportHandler positionimporthandler = (PositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("PositionImportHandler");
                StpositionImportHandler stdPositionImportHandler = (StpositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("StpositionImportHandler");
                JobImportHandler jobImportHandler = (JobImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("JobImportHandler");
                jobIds.addAll(positionimporthandler.getPositionJobIdAndNumberMap().keySet());
                jobIds.addAll(stdPositionImportHandler.getStdPositionJobIdAndNumberMap().keySet());
                jobIds.addAll(jobImportHandler.getJobNumberAndIdMap().values());
                Map<Long, Map<String, Object>> jobGradeResult = jobExternalService.getJobGradeRangeByJobId(jobIds, new Date());
                if (jobGradeResult != null) {
                    jobGradeResult.forEach((jobId, jobGradeInfo) -> {
                        List jobGradeRang;
                        Long jobGradeScmId = (Long)jobGradeInfo.get("jobGradeScmId");
                        Long createOrgId = (Long)jobGradeInfo.get("createOrgId");
                        if (createOrgId != null && createOrgId != 0L) {
                            this.jobIdAndCrateOrgIdMap.put((Long)jobId, createOrgId);
                        }
                        if (jobGradeScmId != null && jobGradeScmId != 0L) {
                            this.jobIdAndJobGradeScmIdMap.put((Long)jobId, jobGradeScmId);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)(jobGradeRang = (List)jobGradeInfo.get("jobGradeRange")))) {
                            List jobGradeIds = jobGradeRang.stream().map(dy -> (Long)dy.get("jobGradeId")).collect(Collectors.toList());
                            this.jobIdAndJobGradeRangeMap.put((Long)jobId, jobGradeIds);
                        }
                    });
                }
                if ((jobLevelResult = jobExternalService.getJobLevelRangeByJobId(jobIds, new Date())) != null) {
                    jobLevelResult.forEach((jobId, jobLevelInfo) -> {
                        List jobLevelRang;
                        Long jobLevelScmId = (Long)jobLevelInfo.get("jobLevelScmId");
                        Long createOrgId = (Long)jobLevelInfo.get("createOrgId");
                        if (createOrgId != null && createOrgId != 0L) {
                            this.jobIdAndCrateOrgIdMap.put((Long)jobId, createOrgId);
                        }
                        if (jobLevelScmId != null && jobLevelScmId != 0L) {
                            this.jobIdAndJobLevelScmIdMap.put((Long)jobId, jobLevelScmId);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)(jobLevelRang = (List)jobLevelInfo.get("jobLevelRange")))) {
                            List jobLevelIds = jobLevelRang.stream().map(dy -> (Long)dy.get("jobLevelId")).collect(Collectors.toList());
                            this.jobIdAndJobLevelRangeMap.put((Long)jobId, jobLevelIds);
                        }
                    });
                }
                if ((jobHisInfoMap = AdminOrgExternalService.getInstance().invokeSelectJobHisinfo(jobIds, new Date())) != null) {
                    Map<Long, String> jobClassInfoMap;
                    List jobHisInfoData = (List)jobHisInfoMap.get("data");
                    if (CollectionUtils.isNotEmpty((Collection)jobHisInfoData)) {
                        Map<Long, Map> jobGradeScmInfoMap = jobHisInfoData.stream().collect(Collectors.toMap(temp -> (Long)temp.get("boid"), temp -> temp, (v1, v2) -> v1));
                        this.jobGradeScmInfoMap.putAll(jobGradeScmInfoMap);
                    }
                    if ((jobClassInfoMap = jobExternalService.invokeGetJobClassLongNameByJobAndBsed(jobIds, new Date())) != null) {
                        this.jobClassInfoMap.putAll(jobClassInfoMap);
                    }
                }
                LOGGER.info("end EvaluationJobImportHandler listAllIdByNumber");
            }
            catch (Exception e) {
                LOGGER.error("EntryImportSerivceImpl EvaluationJobImportHandler listAllIdByNumber error ", (Throwable)e);
                LOGGER.error("EntryImportSerivceImpl EvaluationJobImportHandler listAllIdByNumber invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject jsonObject = temp.getJsonObject();
                    String number = this.getJsonBaseDataDyNumber(jsonObject, "aevaluationjob");
                    if (HRStringUtils.isNotEmpty((String)number)) {
                        temp.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_9", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                    }
                });
            }
            finally {
                LOGGER.info("EvaluationJobImportHandler evaluationJobMap:{}", this.evaluationJobMap);
                LOGGER.info("EvaluationJobImportHandler jobIdAndCrateOrgIdMap:{}", this.jobIdAndCrateOrgIdMap);
                LOGGER.info("EvaluationJobImportHandler jobIdAndJobGradeScmIdMap:{}", this.jobIdAndJobGradeScmIdMap);
                LOGGER.info("EvaluationJobImportHandler jobIdAndJobLevelScmIdMap:{}", this.jobIdAndJobLevelScmIdMap);
                LOGGER.info("EvaluationJobImportHandler jobIdAndJobGradeRangeMap:{}", this.jobIdAndJobGradeRangeMap);
                LOGGER.info("EvaluationJobImportHandler jobIdAndJobLevelRangeMap:{}", this.jobIdAndJobLevelRangeMap);
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        LOGGER.info("start EvaluationJobImportHandler number2Id");
        JSONObject importJson = entryImportWrapper.getJsonObject();
        String number = this.getJsonBaseDataDyNumber(importJson, "aevaluationjob");
        try {
            Map<String, Object> jobInfo;
            long aEvaluationJob;
            long inputEvaluationJobId = 0L;
            if (HRStringUtils.isNotEmpty((String)number)) {
                inputEvaluationJobId = Optional.ofNullable(this.evaluationJobMap.get(number)).orElse(0L);
                if (inputEvaluationJobId == 0L) {
                    entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_9", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                    return;
                }
                importJson.put("aevaluationjob", (Object)JsonObjectUtil.genJSONObject.apply(inputEvaluationJobId));
            }
            if (entryImportWrapper.isEvaluationJobIsCtr()) {
                JSONObject jsonObject = entryImportWrapper.getJsonObject();
                String postPattern = jsonObject.getString("postpattern");
                long inputAEvaluationJobId = this.getJsonBaseDataDyId(jsonObject, "aevaluationjob");
                if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportDataBuilder_11", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                    PositionImportHandler positionimporthandler = (PositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("PositionImportHandler");
                    Map<Long, Long> positionAndJobIdMap = positionimporthandler.getPositionAndJobIdMap();
                    Map<Long, String> positionJobIdAndNumberMap = positionimporthandler.getPositionJobIdAndNumberMap();
                    long aPositionId = this.getJsonBaseDataDyId(importJson, "aposition");
                    long positionRelJobId = Optional.ofNullable(positionAndJobIdMap.get(aPositionId)).orElse(0L);
                    if (positionRelJobId != 0L) {
                        importJson.put("aevaluationjob", (Object)JsonObjectUtil.genJSONObject.apply(positionRelJobId));
                        String positionRelJobIdNumber = positionJobIdAndNumberMap.get(positionRelJobId);
                        if (inputAEvaluationJobId != 0L && positionRelJobId != inputAEvaluationJobId) {
                            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8c03\u5165\u201c%1$s\u201d\u5173\u8054\u7684\u804c\u4f4d\u4e3a\u201c%2$s\u201d\uff0c\u4e0e\u586b\u5199\u7684\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4d\u4e0d\u4e00\u81f4\u3002", (String)"EntryImportDataBuilder_21", (String)"hr-hdm-business", (Object[])new Object[0]), postPattern, positionRelJobIdNumber));
                            return;
                        }
                    } else if (inputAEvaluationJobId != 0L) {
                        Map<Long, Long> noRelJobPositionIdAndJobGradeScmIdMap = positionimporthandler.getNoRelJobPositionIdAndJobGradeScmIdMap();
                        long positionRelJobGradeScmId = Optional.ofNullable(noRelJobPositionIdAndJobGradeScmIdMap.get(aPositionId)).orElse(0L);
                        Map<Long, Long> noRelJobPositionIdAndJobLevelScmIdMap = positionimporthandler.getNoRelJobPositionIdAndJobLevelScmIdMap();
                        long positionRelJobLevelScmId = Optional.ofNullable(noRelJobPositionIdAndJobLevelScmIdMap.get(aPositionId)).orElse(0L);
                        if (positionRelJobGradeScmId != 0L || positionRelJobLevelScmId != 0L) {
                            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8c03\u5165\u201c%1$s\u201d\u5173\u8054\u7684\u804c\u4f4d\u4e3a\u201c%2$s\u201d\uff0c\u4e0e\u586b\u5199\u7684\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4d\u4e0d\u4e00\u81f4\u3002", (String)"EntryImportDataBuilder_21", (String)"hr-hdm-business", (Object[])new Object[0]), postPattern, ResManager.loadKDString((String)"\u7a7a", (String)"EntryImportDataBuilder_10", (String)"hr-hdm-business", (Object[])new Object[0])));
                            importJson.put("aevaluationjob", null);
                            return;
                        }
                    }
                } else if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportDataBuilder_7", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                    StpositionImportHandler stdPositionImportHandler = (StpositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("StpositionImportHandler");
                    Map<Long, Long> stdPositionAndJobIdMap = stdPositionImportHandler.getStdPositionAndJobIdMap();
                    Map<Long, String> stdPositionJobIdAndNumberMap = stdPositionImportHandler.getStdPositionJobIdAndNumberMap();
                    long aStdPositionId = this.getJsonBaseDataDyId(importJson, "astposition");
                    long stdPositionRelJobId = Optional.ofNullable(stdPositionAndJobIdMap.get(aStdPositionId)).orElse(0L);
                    if (stdPositionRelJobId != 0L) {
                        importJson.put("aevaluationjob", (Object)JsonObjectUtil.genJSONObject.apply(stdPositionRelJobId));
                        String stdPositionRelJobIdNumber = stdPositionJobIdAndNumberMap.get(stdPositionRelJobId);
                        if (inputAEvaluationJobId != 0L && stdPositionRelJobId != inputAEvaluationJobId) {
                            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8c03\u5165\u201c%1$s\u201d\u5173\u8054\u7684\u804c\u4f4d\u4e3a\u201c%2$s\u201d\uff0c\u4e0e\u586b\u5199\u7684\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4d\u4e0d\u4e00\u81f4\u3002", (String)"EntryImportDataBuilder_21", (String)"hr-hdm-business", (Object[])new Object[0]), postPattern, stdPositionRelJobIdNumber));
                            return;
                        }
                    } else if (inputAEvaluationJobId != 0L) {
                        Map<Long, Long> noRelJobStdPositionIdAndJobGradeScmIdMap = stdPositionImportHandler.getNoRelJobStdPositionIdAndJobGradeScmIdMap();
                        long stdPositionRelJobGradeScmId = Optional.ofNullable(noRelJobStdPositionIdAndJobGradeScmIdMap.get(aStdPositionId)).orElse(0L);
                        Map<Long, Long> noRelJobStdPositionIdAndJobLevelScmIdMap = stdPositionImportHandler.getNoRelJobStdPositionIdAndJobLevelScmIdMap();
                        long stdPositionRelJobLevelScmId = Optional.ofNullable(noRelJobStdPositionIdAndJobLevelScmIdMap.get(aStdPositionId)).orElse(0L);
                        if (stdPositionRelJobGradeScmId != 0L || stdPositionRelJobLevelScmId != 0L) {
                            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8c03\u5165\u201c%1$s\u201d\u5173\u8054\u7684\u804c\u4f4d\u4e3a\u201c%2$s\u201d\uff0c\u4e0e\u586b\u5199\u7684\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4d\u4e0d\u4e00\u81f4\u3002", (String)"EntryImportDataBuilder_21", (String)"hr-hdm-business", (Object[])new Object[0]), postPattern, ResManager.loadKDString((String)"\u7a7a", (String)"EntryImportDataBuilder_10", (String)"hr-hdm-business", (Object[])new Object[0])));
                            importJson.put("aevaluationjob", null);
                            return;
                        }
                    }
                } else {
                    JSONObject aJob = jsonObject.getJSONObject("ajob");
                    long aJobId = aJob.getLong("id");
                    JobImportHandler jobImportHandler = (JobImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("JobImportHandler");
                    Map<Long, String> jobIdAndNumberMap = jobImportHandler.getJobIdAndNumberMap();
                    String aJobNumber = jobIdAndNumberMap.get(aJobId);
                    if (inputAEvaluationJobId == 0L) {
                        importJson.put("aevaluationjob", (Object)JsonObjectUtil.genJSONObject.apply(aJobId));
                    } else if (aJobId != inputEvaluationJobId) {
                        entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u914d\u7f6e\u8bc4\u5b9a\u4fe1\u606f\u53d7\u4efb\u804c\u4fe1\u606f\u63a7\u5236\uff0c\u5373\u5458\u5de5\u4efb\u804c\u5230\u201c%1$s\u201d\uff0c\u8bc4\u5b9a\u804c\u4f4d\u4e5f\u5e94\u4e3a\u201c%2$s\u201d\u3002", (String)"EntryImportNumberToIdBO_10", (String)"hr-hdm-business", (Object[])new Object[0]), aJobNumber, aJobNumber));
                        return;
                    }
                }
            }
            if ((aEvaluationJob = this.getJsonBaseDataDyId(importJson, "aevaluationjob")) != 0L && (jobInfo = this.jobGradeScmInfoMap.get(aEvaluationJob)) != null) {
                importJson.put("ajoborg", (Object)JsonObjectUtil.genJSONObject.apply((Long)jobInfo.get("createorg")));
                importJson.put("ajobscm", (Object)JsonObjectUtil.genJSONObject.apply((Long)jobInfo.get("jobscmhrid")));
                importJson.put("ajobseq", (Object)JsonObjectUtil.genJSONObject.apply((Long)jobInfo.get("jobseqhrid")));
                importJson.put("ajobfamily", (Object)JsonObjectUtil.genJSONObject.apply((Long)jobInfo.get("jobfamilyhrid")));
                importJson.put("ajobclass", (Object)JsonObjectUtil.genJSONObject.apply((Long)jobInfo.get("jobclasshrid")));
                String jobAllClass = this.jobClassInfoMap.getOrDefault(aEvaluationJob, "");
                importJson.put("ajobclasstext", (Object)jobAllClass);
            }
            LOGGER.info("end EvaluationJobImportHandler number2Id");
        }
        catch (Exception exception) {
            LOGGER.error("EvaluationJobImportHandler number2Id error", (Throwable)exception);
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_9", (String)"hr-hdm-business", (Object[])new Object[0]), number));
        }
    }

    public Set<String> getEvaluationJobList() {
        return this.evaluationJobList;
    }

    public Map<String, Long> getEvaluationJobMap() {
        return this.evaluationJobMap;
    }

    public Map<Long, Map<String, Object>> getJobGradeScmInfoMap() {
        return this.jobGradeScmInfoMap;
    }

    public Map<Long, String> getJobClassInfoMap() {
        return this.jobClassInfoMap;
    }

    public Map<Long, Long> getJobIdAndCrateOrgIdMap() {
        return this.jobIdAndCrateOrgIdMap;
    }

    public Map<Long, Long> getJobIdAndJobGradeScmIdMap() {
        return this.jobIdAndJobGradeScmIdMap;
    }

    public Map<Long, Long> getJobIdAndJobLevelScmIdMap() {
        return this.jobIdAndJobLevelScmIdMap;
    }

    public Map<Long, List<Long>> getJobIdAndJobLevelRangeMap() {
        return this.jobIdAndJobLevelRangeMap;
    }

    public Map<Long, List<Long>> getJobIdAndJobGradeRangeMap() {
        return this.jobIdAndJobGradeRangeMap;
    }
}

