/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;

public class OrgImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(OrgImportHandler.class);
    private final Set<String> orgNumbers = new HashSet<String>(16);
    private final Map<String, Long> orgNumberAndIdMap = new HashMap<String, Long>(16);
    private final List<Long> orgIds = new ArrayList<Long>(0);
    private static final String ERROR_SCENE = "orgNumber2Id";

    public OrgImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        String number = this.getJsonBaseDataDyNumber(jsonObject, "aorg");
        if (HRStringUtils.isNotEmpty((String)number)) {
            this.orgNumbers.add(number);
        }
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                LOGGER.info("start OrgImportHandler listAllIdByNumber");
                AdminOrgExternalService adminOrgExternalService = AdminOrgExternalService.getInstance();
                Map<String, Map<String, Object>> adminOrg = adminOrgExternalService.queryAdminorgByNumber(new ArrayList<String>(this.orgNumbers), new Date());
                adminOrg.forEach((key, value) -> {
                    if (HRStringUtils.equals((String)((String)value.get("enable")), (String)"1")) {
                        Long orgId = (Long)value.get("id");
                        this.orgNumberAndIdMap.put((String)key, orgId);
                    }
                });
                LOGGER.info("end OrgImportHandler listAllIdByNumber");
            }
            catch (Exception exception) {
                LOGGER.error("EntryImportSerivceImpl OrgImportHandler listAllIdByNumber error", (Throwable)exception);
                LOGGER.error("EntryImportSerivceImpl OrgImportHandler listAllIdByNumber invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject org = temp.getJsonObject().getJSONObject("aorg");
                    if (org != null) {
                        temp.getValidateContext().setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8\u7f16\u7801\u6ca1\u6709\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"EntryImportNumberToIdBO_3", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                });
            }
            finally {
                LOGGER.info("OrgImportHandler orgIds:{}", this.orgIds);
                LOGGER.info("OrgImportHandler orgNumberAndIdMap:{}", this.orgNumberAndIdMap);
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        try {
            LOGGER.info("OrgImportHandler start number2Id");
            JSONObject jsonObject = entryImportWrapper.getJsonObject();
            String number = this.getJsonBaseDataDyNumber(jsonObject, "aorg");
            Long orgId = this.orgNumberAndIdMap.get(number);
            if (orgId == null) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8\u7f16\u7801\u6ca1\u6709\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"EntryImportNumberToIdBO_3", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            JSONObject orgJson = JsonObjectUtil.genJSONObject.apply(orgId);
            jsonObject.put("aorg", (Object)orgJson);
            jsonObject.put("arealityorg", (Object)orgJson);
            jsonObject.put("aaffiliateorg", (Object)orgJson);
            this.orgIds.add(orgId);
            LOGGER.info("OrgImportHandler end number2Id orgId:", (Object)orgId);
        }
        catch (Exception exception) {
            LOGGER.error("OrgImportHandler error number2Id", (Throwable)exception);
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8\u7f16\u7801\u6ca1\u6709\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"EntryImportNumberToIdBO_3", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
    }

    public Set<String> getOrgNumbers() {
        return this.orgNumbers;
    }

    public List<Long> getOrgIds() {
        return this.orgIds;
    }

    public Map<String, Long> getOrgNumberAndIdMap() {
        return this.orgNumberAndIdMap;
    }
}

