/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.service.hbpm.IHBPMService;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.OrgImportHandler;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;

public class PositionImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(OrgImportHandler.class);
    private final Set<String> positionNumbers = new HashSet<String>(16);
    private final Map<String, Long> positionNumberAndIdMap = new HashMap<String, Long>(16);
    private final Map<Long, Long> positionAndJobIdMap = new HashMap<Long, Long>(0);
    private final Map<Long, String> positionJobIdAndNumberMap = new HashMap<Long, String>(0);
    private final Map<Long, Long> positionAndOrgIdMap = new HashMap<Long, Long>(16);
    private final Map<Long, Long> noRelJobPositionIdAndJobLevelScmIdMap = new HashMap<Long, Long>(0);
    private final Map<Long, Long> noRelJobPositionIdAndJobGradeScmIdMap = new HashMap<Long, Long>(0);
    private final Set<String> noRelJobLevelScmNumberSet = new HashSet<String>(0);
    private final Set<String> noRelJobGradeScmNumberSet = new HashSet<String>(0);
    private final Map<Long, List<Long>> noRelJobLevelRangMap = new HashMap<Long, List<Long>>(0);
    private final Map<Long, List<Long>> noRelJobGradeRangMap = new HashMap<Long, List<Long>>(0);
    private static final String ERROR_SCENE = "positionNumber2Id";

    public PositionImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        String number = this.getJsonBaseDataDyNumber(jsonObject, "aposition");
        String postPattern = jsonObject.getString("postpattern");
        if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_0", (String)"hr-hdm-business", (Object[])new Object[0])) && HRStringUtils.isNotEmpty((String)number)) {
            jsonObject.put("ajob", null);
            jsonObject.put("astposition", null);
            this.positionNumbers.add(number);
        }
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                LOGGER.info("start PositionImportHandler listAllIdByNumber");
                if (this.positionNumbers.isEmpty()) {
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                AdminOrgExternalService adminOrgExternalService = AdminOrgExternalService.getInstance();
                Map<String, Object> positionHisSimpleInfo = adminOrgExternalService.queryPositionHisByNumber(new ArrayList<String>(this.positionNumbers), new Date());
                if (positionHisSimpleInfo == null) {
                    LOGGER.warn("PositionImportHandler listAllIdByNumber positionHisSimpleInfo is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                Object positionHisSimpleData = positionHisSimpleInfo.get("data");
                if (positionHisSimpleData == null) {
                    LOGGER.warn("PositionImportHandler listAllIdByNumber positionHisSimpleData is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                List dataList = (List)positionHisSimpleData;
                Map<String, Long> positionMap = this.hisBaseDataMapToNumberBoIdGroupMap(dataList);
                this.positionNumberAndIdMap.putAll(positionMap);
                Map<String, Object> positionHisInfo = adminOrgExternalService.invokeQueryPositionHis(new ArrayList<Long>(positionMap.values()), new Date());
                Map positionHisData = (Map)positionHisInfo.get("data");
                if (positionHisData == null) {
                    LOGGER.warn("PositionImportHandler positionHisData is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                List hisData = (List)positionHisData.get("hisdata");
                if (hisData == null) {
                    LOGGER.warn("PositionImportHandler hisData is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                boolean evaluationJobIsCtr = ((EntryImportWrapper)importSource.get(0)).isEvaluationJobIsCtr();
                HashSet noJobPositionIds = new HashSet(16);
                hisData.forEach(temp -> {
                    Long positionId = (Long)temp.get("boid");
                    Long jobId = (Long)temp.get("job");
                    String jobNumber = (String)temp.get("jobVnumber");
                    Long adminOrgId = (Long)temp.get("adminorg");
                    this.positionAndOrgIdMap.put(positionId, adminOrgId);
                    this.positionAndJobIdMap.put(positionId, jobId);
                    if (evaluationJobIsCtr) {
                        if (jobId != 0L) {
                            this.positionJobIdAndNumberMap.put(jobId, jobNumber);
                        } else {
                            noJobPositionIds.add(positionId);
                        }
                    }
                });
                if (noJobPositionIds.size() > 0) {
                    ArrayList<Long> noJobPositionIdList = new ArrayList<Long>(noJobPositionIds);
                    Map<Long, Object> noJobPositionData = IHBPMService.getInstance().queryJobLevelGradeRangeAndScmByPositionVersion(noJobPositionIdList, null);
                    if (noJobPositionData != null) {
                        noJobPositionData.forEach((positionId, jobLevelGradeRangeAndScmData) -> {
                            Long jobLevelScmId;
                            Map jobLevelData;
                            Long jobGradeScmId;
                            Map jobLevelGradeRangeAndScm = (Map)jobLevelGradeRangeAndScmData;
                            Map jobGradeData = (Map)jobLevelGradeRangeAndScm.get("jobGradeData");
                            if (jobGradeData != null && (jobGradeScmId = (Long)jobGradeData.get("id")) != null && jobGradeScmId != 0L) {
                                String jobGradeScmNumber = (String)jobGradeData.get("number");
                                List jobGradeRang = (List)jobGradeData.get("ranges");
                                this.noRelJobPositionIdAndJobGradeScmIdMap.put((Long)positionId, jobGradeScmId);
                                this.noRelJobGradeScmNumberSet.add(jobGradeScmNumber);
                                if (CollectionUtils.isNotEmpty((Collection)jobGradeRang)) {
                                    List jobGradeIds = jobGradeRang.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                                    this.noRelJobGradeRangMap.put((Long)positionId, jobGradeIds);
                                }
                            }
                            if ((jobLevelData = (Map)jobLevelGradeRangeAndScm.get("jobLevelData")) != null && (jobLevelScmId = (Long)jobLevelData.get("id")) != null && jobLevelScmId != 0L) {
                                String jobLevelScmNumber = (String)jobLevelData.get("number");
                                List jobLevelRang = (List)jobLevelData.get("ranges");
                                this.noRelJobPositionIdAndJobLevelScmIdMap.put((Long)positionId, jobLevelScmId);
                                this.noRelJobLevelScmNumberSet.add(jobLevelScmNumber);
                                if (CollectionUtils.isNotEmpty((Collection)jobLevelRang)) {
                                    List jobLevelIds = jobLevelRang.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                                    this.noRelJobLevelRangMap.put((Long)positionId, jobLevelIds);
                                }
                            }
                        });
                    }
                }
                LOGGER.info("end PositionImportHandler listAllIdByNumber");
            }
            catch (Exception e) {
                LOGGER.error("EntryImportSerivceImpl PositionImportHandler listAllIdByNumber error ", (Throwable)e);
                LOGGER.error("EntryImportSerivceImpl PositionImportHandler listAllIdByNumber invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject jsonObject = temp.getJsonObject();
                    String number = this.getJsonBaseDataDyNumber(jsonObject, "aposition");
                    if (HRStringUtils.isNotEmpty((String)number)) {
                        temp.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u5c97\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_4", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                    }
                });
            }
            finally {
                LOGGER.info("PositionImportHandler positionAndJobIdMap:{}", this.positionAndJobIdMap);
                LOGGER.info("PositionImportHandler positionJobIdAndNumberMap:{}", this.positionJobIdAndNumberMap);
                LOGGER.info("PositionImportHandler noRelJobPositionIdAndJobLevelScmIdMap:{}", this.noRelJobPositionIdAndJobLevelScmIdMap);
                LOGGER.info("PositionImportHandler noRelJobPositionIdAndJobGradeScmIdMap:{}", this.noRelJobPositionIdAndJobGradeScmIdMap);
                LOGGER.info("PositionImportHandler noRelJobLevelScmNumberSet:{}", this.noRelJobLevelScmNumberSet);
                LOGGER.info("PositionImportHandler noRelJobGradeScmNumberSet:{}", this.noRelJobGradeScmNumberSet);
                LOGGER.info("PositionImportHandler noRelJobLevelRangMap:{}", this.noRelJobLevelRangMap);
                LOGGER.info("PositionImportHandler noRelJobGradeRangMap:{}", this.noRelJobGradeRangMap);
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        LOGGER.info("start PositionImportHandler number2Id");
        JSONObject importSource = entryImportWrapper.getJsonObject();
        String postPattern = importSource.getString("postpattern");
        if (!HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_0", (String)"hr-hdm-business", (Object[])new Object[0]))) {
            return;
        }
        String number = this.getJsonBaseDataDyNumber(importSource, "aposition");
        try {
            Long positionId = this.positionNumberAndIdMap.get(number);
            if (positionId == null) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u5c97\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_4", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                return;
            }
            importSource.put("aposition", (Object)JsonObjectUtil.genJSONObject.apply(positionId));
            importSource.put("arealityposition", (Object)JsonObjectUtil.genJSONObject.apply(positionId));
            long aOrgId = this.getJsonBaseDataDyId(importSource, "aorg");
            Long positionOrgId = this.positionAndOrgIdMap.get(positionId);
            if (positionOrgId == null || positionOrgId != aOrgId) {
                entryImportWrapper.setCompleteValidResult("validatePositionBelongsToOrg", ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8\u4e0b\u4e0d\u5b58\u5728\u6240\u586b\u5199\u7684\u8c03\u5165\u5c97\u4f4d\u3002", (String)"EntryImportDataBuilder_6", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            Long jobId = Optional.ofNullable(this.positionAndJobIdMap.get(positionId)).orElse(0L);
            JSONObject jobJson = JsonObjectUtil.genJSONObject.apply(jobId);
            importSource.put("ajob", (Object)jobJson);
            importSource.put("arealityjob", (Object)jobJson);
            Long jobLevelScmId = Optional.ofNullable(this.noRelJobPositionIdAndJobLevelScmIdMap.get(positionId)).orElse(0L);
            Long jobGradeScmId = Optional.ofNullable(this.noRelJobPositionIdAndJobGradeScmIdMap.get(positionId)).orElse(0L);
            if (jobId == 0L && jobLevelScmId == 0L && jobGradeScmId == 0L) {
                entryImportWrapper.setEvaluationJobIsCtr(false);
            }
            LOGGER.info("end PositionImportHandler number2Id positionId:", (Object)positionId);
        }
        catch (Exception e) {
            LOGGER.error("PositionImportHandler number2Id error:", (Throwable)e);
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u5c97\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_4", (String)"hr-hdm-business", (Object[])new Object[0]), number));
        }
    }

    public Set<String> getPositionNumbers() {
        return this.positionNumbers;
    }

    public Map<String, Long> getPositionNumberAndIdMap() {
        return this.positionNumberAndIdMap;
    }

    public Map<Long, Long> getPositionAndJobIdMap() {
        return this.positionAndJobIdMap;
    }

    public Map<Long, String> getPositionJobIdAndNumberMap() {
        return this.positionJobIdAndNumberMap;
    }

    public Map<Long, Long> getNoRelJobPositionIdAndJobLevelScmIdMap() {
        return this.noRelJobPositionIdAndJobLevelScmIdMap;
    }

    public Map<Long, Long> getNoRelJobPositionIdAndJobGradeScmIdMap() {
        return this.noRelJobPositionIdAndJobGradeScmIdMap;
    }

    public Set<String> getNoRelJobLevelScmNumberSet() {
        return this.noRelJobLevelScmNumberSet;
    }

    public Set<String> getNoRelJobGradeScmNumberSet() {
        return this.noRelJobGradeScmNumberSet;
    }

    public Map<Long, List<Long>> getNoRelJobLevelRangMap() {
        return this.noRelJobLevelRangMap;
    }

    public Map<Long, List<Long>> getNoRelJobGradeRangMap() {
        return this.noRelJobGradeRangMap;
    }
}

