/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.entity;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.TransferStaffEnum;

public class TransferStaffVO {
    private Long candidateId;
    private static final String OUTSUBMIT_CHANGEEVENT_NUMBER = "1070_S";
    private static final String INSUBMIT_CHANGEEVENT_NUMBER = "1050_S";
    private Long bizBillId;
    private Boolean beforeChange;
    private Long personId;
    private Long depEmpId;
    private Long orgTeamId;
    private Long dutyWorkRoleId;
    private Long jobId;
    private Long jobLevelId;
    private Long laborRelTypeId;
    private Date effDate;
    private Long bJobId;
    private Long bDutyWorkRoleId;
    private Long bOrgTeamId;
    private Long bJobLevelId;
    private boolean isUpdate;

    public TransferStaffVO(DynamicObject transferBill) {
        this.personId = transferBill.getDynamicObject("person").getLong("id");
        this.depEmpId = transferBill.getDynamicObject("bdepemp").getLong("id");
        this.orgTeamId = TransferStaffService.getInstance().getRealOrgTeamId("arealityorg.id", transferBill);
        this.dutyWorkRoleId = Optional.ofNullable(transferBill.getLong("arealityposition.id")).orElseGet(() -> 0L);
        this.jobId = Optional.ofNullable(transferBill.getLong("arealityjob.id")).orElseGet(() -> 0L);
        this.jobLevelId = 0L;
        this.laborRelTypeId = transferBill.getLong("laborreltype.id");
        this.effDate = transferBill.getDate("realitydate");
        this.bizBillId = transferBill.getLong("id");
        this.bJobId = Optional.ofNullable(transferBill.getLong("bjob.id")).orElseGet(() -> 0L);
        this.bJobLevelId = 0L;
        this.bDutyWorkRoleId = Optional.ofNullable(transferBill.getLong("bposition.id")).orElseGet(() -> 0L);
        this.bOrgTeamId = Optional.ofNullable(transferBill.getLong("borg.id")).orElseGet(() -> 0L);
    }

    public Long getPersonId() {
        return this.personId;
    }

    public Long getDepEmpId() {
        return this.depEmpId;
    }

    public Long getOrgTeamId() {
        return this.orgTeamId;
    }

    public Long getDutyWorkRoleId() {
        return this.dutyWorkRoleId;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Long getJobLevelId() {
        return this.jobLevelId;
    }

    public Long getLaborRelTypeId() {
        return this.laborRelTypeId;
    }

    public Date getEffDate() {
        return this.effDate;
    }

    public Long getCandidateId() {
        return this.candidateId;
    }

    public Long getBizBillId() {
        return this.bizBillId;
    }

    public Boolean getBeforeChange() {
        return this.beforeChange;
    }

    public Long getbJobId() {
        return this.bJobId;
    }

    public Long getbDutyWorkRoleId() {
        return this.bDutyWorkRoleId;
    }

    public Long getbOrgTeamId() {
        return this.bOrgTeamId;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setCandidateId(Long candidateId) {
        this.candidateId = candidateId;
    }

    public void setBeforeChange(Boolean beforeChange) {
        this.beforeChange = beforeChange;
    }

    public Long getbJobLevelId() {
        return this.bJobLevelId;
    }

    public static String getQueryStaffKey(DynamicObject transferBill) {
        return String.format("D%s", transferBill.getDynamicObject("bdepemp").get("id").toString());
    }

    public StaffQueryInParam genStaffQueryInParam(String condition, DynamicObject transferbill, List<Map<String, String>> dimension) {
        StaffQueryInParam staffQueryInParam = new StaffQueryInParam();
        TransferStaffVO transferStaffVO = new TransferStaffVO(transferbill);
        staffQueryInParam.setDepEmpId(transferStaffVO.getDepEmpId());
        staffQueryInParam.setDutyWorkRoleId(transferStaffVO.getDutyWorkRoleId());
        staffQueryInParam.setEffDate(transferStaffVO.getEffDate());
        staffQueryInParam.setJobId(transferStaffVO.getJobId());
        staffQueryInParam.setJobLevelId(transferStaffVO.getJobLevelId());
        staffQueryInParam.setLaborRelTypeId(transferStaffVO.getLaborRelTypeId());
        staffQueryInParam.setOrgTeamId(transferStaffVO.getOrgTeamId());
        staffQueryInParam.setPersonId(transferStaffVO.getPersonId());
        if (dimension != null && !dimension.isEmpty()) {
            HashMap other = Maps.newHashMapWithExpectedSize((int)dimension.size());
            dimension.stream().forEach(item -> other.put(item.get("staffdimension"), TransferStaffService.getInstance().getDimensionValue((String)item.get("mapfield"), transferbill)));
            staffQueryInParam.setOther((Map)other);
        }
        boolean isUpdate = condition.equals(TransferStaffEnum.UPDATE.name());
        staffQueryInParam.setUpdate(isUpdate);
        return staffQueryInParam;
    }

    public StaffUseParam genStaffUseParam(DynamicObject transferbill, StaffUseParam staffUseParam) {
        return staffUseParam;
    }

    public Function<StaffUseParam, StaffUseParam> genNewTransferInStaffParam(DynamicObject transferBill, boolean isUpdate, List<Map<String, String>> dimension) {
        return staffUseParam -> {
            TransferStaffVO transferStaffVO = new TransferStaffVO(transferBill);
            List staffUseInParamList = staffUseParam.getStaffUseInParamList();
            StaffUseInParam staffUseInParam = new StaffUseInParam();
            staffUseInParam.setDepEmpId(transferStaffVO.getDepEmpId());
            staffUseInParam.setDutyWorkRoleId(transferStaffVO.getDutyWorkRoleId());
            staffUseInParam.setEffDate(transferStaffVO.getEffDate());
            staffUseInParam.setJobId(transferStaffVO.getJobId());
            staffUseInParam.setJobLevelId(transferStaffVO.getJobLevelId());
            staffUseInParam.setLaborRelTypeId(transferStaffVO.getLaborRelTypeId());
            staffUseInParam.setOrgTeamId(transferStaffVO.getOrgTeamId());
            staffUseInParam.setPersonId(transferStaffVO.getPersonId());
            staffUseInParam.setBizBillId(transferStaffVO.getBizBillId());
            staffUseInParam.setChangeEventNumber(INSUBMIT_CHANGEEVENT_NUMBER);
            staffUseInParam.setBeforeChange(Boolean.FALSE);
            staffUseInParam.setUpdate(isUpdate);
            this.setDimensionInfo(transferBill, staffUseInParam, dimension);
            staffUseInParamList.add(staffUseInParam);
            return staffUseParam;
        };
    }

    public Function<StaffUseParam, StaffUseParam> genNewTransferOutStaffParam(DynamicObject transferBill, boolean isUpdate) {
        return staffUseParam -> {
            TransferStaffVO transferStaffVO = new TransferStaffVO(transferBill);
            List staffUseInParamList = staffUseParam.getStaffUseInParamList();
            StaffUseInParam staffUseInParam = new StaffUseInParam();
            staffUseInParam.setDepEmpId(transferStaffVO.getDepEmpId());
            staffUseInParam.setDutyWorkRoleId(transferStaffVO.getbDutyWorkRoleId());
            staffUseInParam.setEffDate(transferStaffVO.getEffDate());
            staffUseInParam.setJobId(transferStaffVO.getbJobId());
            staffUseInParam.setJobId(transferStaffVO.getbJobLevelId());
            staffUseInParam.setLaborRelTypeId(transferStaffVO.getLaborRelTypeId());
            staffUseInParam.setOrgTeamId(transferStaffVO.getbOrgTeamId());
            staffUseInParam.setPersonId(transferStaffVO.getPersonId());
            staffUseInParam.setBizBillId(transferStaffVO.getBizBillId());
            staffUseInParam.setChangeEventNumber(OUTSUBMIT_CHANGEEVENT_NUMBER);
            staffUseInParam.setBeforeChange(Boolean.FALSE);
            staffUseInParam.setUpdate(isUpdate);
            staffUseInParamList.add(staffUseInParam);
            return staffUseParam;
        };
    }

    public Function<StaffUseParam, StaffUseParam> genOldTransferInStaffParam(DynamicObject transferBill, boolean isUpdate, List<Map<String, String>> dimension) {
        return staffUseParam -> {
            TransferStaffVO transferStaffVO = new TransferStaffVO(transferBill);
            List staffUseInParamList = staffUseParam.getStaffUseInParamList();
            StaffUseInParam staffUseInParam = new StaffUseInParam();
            staffUseInParam.setDepEmpId(transferStaffVO.getDepEmpId());
            staffUseInParam.setDutyWorkRoleId(transferStaffVO.getDutyWorkRoleId());
            staffUseInParam.setEffDate(transferStaffVO.getEffDate());
            staffUseInParam.setJobId(transferStaffVO.getJobId());
            staffUseInParam.setJobLevelId(transferStaffVO.getJobLevelId());
            staffUseInParam.setLaborRelTypeId(transferStaffVO.getLaborRelTypeId());
            staffUseInParam.setOrgTeamId(transferStaffVO.getOrgTeamId());
            staffUseInParam.setPersonId(transferStaffVO.getPersonId());
            staffUseInParam.setBizBillId(transferStaffVO.getBizBillId());
            staffUseInParam.setChangeEventNumber(INSUBMIT_CHANGEEVENT_NUMBER);
            staffUseInParam.setUpdate(isUpdate);
            staffUseInParam.setBeforeChange(Boolean.TRUE);
            this.setDimensionInfo(transferBill, staffUseInParam, dimension);
            staffUseInParamList.add(staffUseInParam);
            return staffUseParam;
        };
    }

    private void setDimensionInfo(DynamicObject transferBill, StaffUseInParam staffUseInParam, List<Map<String, String>> dimension) {
        if (dimension != null && !dimension.isEmpty()) {
            HashMap other = Maps.newHashMapWithExpectedSize((int)dimension.size());
            dimension.stream().forEach(item -> other.put(item.get("staffdimension"), TransferStaffService.getInstance().getDimensionValue((String)item.get("mapfield"), transferBill)));
            staffUseInParam.setOther((Map)other);
        }
    }

    public Function<StaffUseParam, StaffUseParam> genOldTransferOutStaffParam(DynamicObject transferBill, boolean isUpdate) {
        return staffUseParam -> {
            TransferStaffVO transferStaffVO = new TransferStaffVO(transferBill);
            List staffUseInParamList = staffUseParam.getStaffUseInParamList();
            StaffUseInParam staffUseInParam = new StaffUseInParam();
            staffUseInParam.setDepEmpId(transferStaffVO.getDepEmpId());
            staffUseInParam.setDutyWorkRoleId(transferStaffVO.getbDutyWorkRoleId());
            staffUseInParam.setEffDate(transferStaffVO.getEffDate());
            staffUseInParam.setJobId(transferStaffVO.getbJobId());
            staffUseInParam.setJobId(transferStaffVO.getbJobLevelId());
            staffUseInParam.setLaborRelTypeId(transferStaffVO.getLaborRelTypeId());
            staffUseInParam.setOrgTeamId(transferStaffVO.getbOrgTeamId());
            staffUseInParam.setPersonId(transferStaffVO.getPersonId());
            staffUseInParam.setBizBillId(transferStaffVO.getBizBillId());
            staffUseInParam.setChangeEventNumber(OUTSUBMIT_CHANGEEVENT_NUMBER);
            staffUseInParam.setBeforeChange(Boolean.TRUE);
            staffUseInParam.setUpdate(isUpdate);
            staffUseInParamList.add(staffUseInParam);
            return staffUseParam;
        };
    }
}

